/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2.port;

import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerThreads
extends Thread {
    private BufferedReader lineReader = null;
    private Process chimera = null;
    private Map<String, List<String>> replyLog = null;
    private Logger logger;
    private StructureManager structureManager = null;
    private boolean stopMe = false;

    public ListenerThreads(Process chimera, StructureManager structureManager) {
        this.chimera = chimera;
        this.structureManager = structureManager;
        this.replyLog = new HashMap<String, List<String>>();
        InputStream readChan = chimera.getInputStream();
        this.lineReader = new BufferedReader(new InputStreamReader(readChan));
        this.logger = LoggerFactory.getLogger(ListenerThreads.class);
    }

    @Override
    public void run() {
        while (!this.stopMe) {
            try {
                this.chimeraRead();
            }
            catch (IOException e) {
                this.logger.warn("UCSF Chimera has exited: " + e.getMessage());
                return;
            }
            finally {
                if (this.lineReader == null) continue;
                try {
                    this.lineReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResponse(String command) {
        List<String> reply;
        while (!this.replyLog.containsKey(command)) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Map<String, List<String>> map = this.replyLog;
        synchronized (map) {
            reply = this.replyLog.get(command);
            this.replyLog.remove(command);
        }
        return reply;
    }

    public void clearResponse(String command) {
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.replyLog.containsKey(command)) {
            this.replyLog.remove(command);
        }
    }

    private void chimeraRead() throws IOException {
        if (this.chimera == null) {
            return;
        }
        String line = null;
        while ((line = this.lineReader.readLine()) != null) {
            if (line.startsWith("CMD")) {
                this.chimeraCommandRead(line.substring(4));
                continue;
            }
            if (line.startsWith("ModelChanged: ")) {
                new ModelUpdater().start();
                continue;
            }
            if (line.startsWith("SelectionChanged: ")) {
                new SelectionUpdater().start();
                continue;
            }
            if (!line.startsWith("Trajectory residue network info:")) continue;
            new NetworkUpdater(line).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chimeraCommandRead(String command) throws IOException {
        ArrayList<String> reply = new ArrayList<String>();
        boolean updateModels = false;
        boolean updateSelection = false;
        boolean importNetwork = false;
        String line = null;
        Map<String, List<String>> map = this.replyLog;
        synchronized (map) {
            while ((line = this.lineReader.readLine()) != null) {
                if (line.startsWith("CMD")) {
                    this.logger.warn("Got unexpected command from Chimera: " + line);
                } else if (line.startsWith("END")) break;
                if (line.startsWith("ModelChanged: ")) {
                    updateModels = true;
                    continue;
                }
                if (line.startsWith("SelectionChanged: ")) {
                    updateSelection = true;
                    continue;
                }
                if (line.length() == 0) continue;
                if (!line.startsWith("CMD")) {
                    reply.add(line);
                    continue;
                }
                if (!line.startsWith("Trajectory residue network info:")) continue;
                importNetwork = true;
            }
            this.replyLog.put(command, reply);
        }
        if (updateModels) {
            new ModelUpdater().start();
        }
        if (updateSelection) {
            new SelectionUpdater().start();
        }
        if (importNetwork) {
            new NetworkUpdater(line).start();
        }
    }

    public void requestStop() {
        this.stopMe = true;
    }

    class NetworkUpdater
    extends Thread {
        private String line;

        public NetworkUpdater(String line) {
            this.line = line;
        }

        @Override
        public void run() {
        }
    }

    class SelectionUpdater
    extends Thread {
        @Override
        public void run() {
            try {
                ListenerThreads.this.logger.info("Responding to chimera selection");
                ListenerThreads.this.structureManager.chimeraSelectionChanged();
            }
            catch (Exception e) {
                ListenerThreads.this.logger.warn("Could not update selection", (Throwable)e);
            }
        }
    }

    class ModelUpdater
    extends Thread {
        @Override
        public void run() {
            ListenerThreads.this.structureManager.updateModels();
            ListenerThreads.this.structureManager.modelChanged();
        }
    }
}

