/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.io;

import htsjdk.samtools.util.RuntimeEOFException;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LTF8 {
    static final int MAX_BYTES = 9;
    static final int MAX_BITS = 72;

    public static long readUnsignedLTF8(InputStream inputStream) {
        try {
            int b1 = inputStream.read();
            if (b1 == -1) {
                throw new RuntimeEOFException();
            }
            if ((b1 & 0x80) == 0) {
                return b1;
            }
            if ((b1 & 0x40) == 0) {
                return (b1 & 0x7F) << 8 | inputStream.read();
            }
            if ((b1 & 0x20) == 0) {
                int b2 = inputStream.read();
                int b3 = inputStream.read();
                return (b1 & 0x3F) << 16 | b2 << 8 | b3;
            }
            if ((b1 & 0x10) == 0) {
                long result = (long)(b1 & 0x1F) << 24;
                result |= (long)(inputStream.read() << 16);
                result |= (long)(inputStream.read() << 8);
                return result |= (long)inputStream.read();
            }
            if ((b1 & 8) == 0) {
                long value = (long)(b1 & 0xF) << 32;
                value |= (0xFFL & (long)inputStream.read()) << 24;
                value |= (long)(inputStream.read() << 16);
                value |= (long)(inputStream.read() << 8);
                return value |= (long)inputStream.read();
            }
            if ((b1 & 4) == 0) {
                long result = (long)(b1 & 7) << 40;
                result |= (0xFFL & (long)inputStream.read()) << 32;
                result |= (0xFFL & (long)inputStream.read()) << 24;
                result |= (long)(inputStream.read() << 16);
                result |= (long)(inputStream.read() << 8);
                return result |= (long)inputStream.read();
            }
            if ((b1 & 2) == 0) {
                long result = (long)(b1 & 3) << 48;
                result |= (0xFFL & (long)inputStream.read()) << 40;
                result |= (0xFFL & (long)inputStream.read()) << 32;
                result |= (0xFFL & (long)inputStream.read()) << 24;
                result |= (long)(inputStream.read() << 16);
                result |= (long)(inputStream.read() << 8);
                return result |= (long)inputStream.read();
            }
            if ((b1 & 1) == 0) {
                long result = (0xFFL & (long)inputStream.read()) << 48;
                result |= (0xFFL & (long)inputStream.read()) << 40;
                result |= (0xFFL & (long)inputStream.read()) << 32;
                result |= (0xFFL & (long)inputStream.read()) << 24;
                result |= (long)(inputStream.read() << 16);
                result |= (long)(inputStream.read() << 8);
                return result |= (long)inputStream.read();
            }
            long result = (0xFFL & (long)inputStream.read()) << 56;
            result |= (0xFFL & (long)inputStream.read()) << 48;
            result |= (0xFFL & (long)inputStream.read()) << 40;
            result |= (0xFFL & (long)inputStream.read()) << 32;
            result |= (0xFFL & (long)inputStream.read()) << 24;
            result |= (long)(inputStream.read() << 16);
            result |= (long)(inputStream.read() << 8);
            return result |= (long)inputStream.read();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static int writeUnsignedLTF8(long value, OutputStream outputStream) {
        try {
            if (value >>> 7 == 0L) {
                outputStream.write((int)value);
                return 8;
            }
            if (value >>> 14 == 0L) {
                outputStream.write((int)(value >> 8 | 0x80L));
                outputStream.write((int)(value & 0xFFL));
                return 16;
            }
            if (value >>> 21 == 0L) {
                outputStream.write((int)(value >> 16 | 0xC0L));
                outputStream.write((int)(value >> 8 & 0xFFL));
                outputStream.write((int)(value & 0xFFL));
                return 24;
            }
            if (value >>> 28 == 0L) {
                outputStream.write((int)(value >> 24 | 0xE0L));
                outputStream.write((int)(value >> 16 & 0xFFL));
                outputStream.write((int)(value >> 8 & 0xFFL));
                outputStream.write((int)(value & 0xFFL));
                return 32;
            }
            if (value >>> 35 == 0L) {
                outputStream.write((int)(value >> 32 | 0xF0L));
                outputStream.write((int)(value >> 24 & 0xFFL));
                outputStream.write((int)(value >> 16 & 0xFFL));
                outputStream.write((int)(value >> 8 & 0xFFL));
                outputStream.write((int)(value & 0xFFL));
                return 40;
            }
            if (value >>> 42 == 0L) {
                outputStream.write((int)(value >> 40 | 0xF8L));
                outputStream.write((int)(value >> 32 & 0xFFL));
                outputStream.write((int)(value >> 24 & 0xFFL));
                outputStream.write((int)(value >> 16 & 0xFFL));
                outputStream.write((int)(value >> 8 & 0xFFL));
                outputStream.write((int)(value & 0xFFL));
                return 48;
            }
            if (value >>> 49 == 0L) {
                outputStream.write((int)(value >> 48 | 0xFCL));
                outputStream.write((int)(value >> 40 & 0xFFL));
                outputStream.write((int)(value >> 32 & 0xFFL));
                outputStream.write((int)(value >> 24 & 0xFFL));
                outputStream.write((int)(value >> 16 & 0xFFL));
                outputStream.write((int)(value >> 8 & 0xFFL));
                outputStream.write((int)(value & 0xFFL));
                return 56;
            }
            if (value >>> 56 == 0L) {
                outputStream.write(254);
                outputStream.write((int)(value >> 48 & 0xFFL));
                outputStream.write((int)(value >> 40 & 0xFFL));
                outputStream.write((int)(value >> 32 & 0xFFL));
                outputStream.write((int)(value >> 24 & 0xFFL));
                outputStream.write((int)(value >> 16 & 0xFFL));
                outputStream.write((int)(value >> 8 & 0xFFL));
                outputStream.write((int)(value & 0xFFL));
                return 64;
            }
            outputStream.write(255);
            outputStream.write((int)(value >> 56 & 0xFFL));
            outputStream.write((int)(value >> 48 & 0xFFL));
            outputStream.write((int)(value >> 40 & 0xFFL));
            outputStream.write((int)(value >> 32 & 0xFFL));
            outputStream.write((int)(value >> 28 & 0xFFL));
            outputStream.write((int)(value >> 16 & 0xFFL));
            outputStream.write((int)(value >> 8 & 0xFFL));
            outputStream.write((int)(value & 0xFFL));
            return 72;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }
}

