/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.core.sequence.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.core.sequence.template.Compound;
import org.biojava.nbio.core.sequence.template.CompoundSet;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.core.util.Equals;
import org.biojava.nbio.core.util.Hashcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompoundSet<C extends Compound>
implements CompoundSet<C> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCompoundSet.class);
    private Map<CharSequence, C> charSeqToCompound = new HashMap<CharSequence, C>();
    private int maxCompoundCharSequenceLength = -1;
    private Boolean compoundStringLengthEqual = null;
    Map<C, Set<C>> equivalentsMap = new HashMap<C, Set<C>>();

    protected void addCompound(C compound, C lowerCasedCompound, Iterable<C> equivalents) {
        this.addCompound(compound);
        this.addCompound(lowerCasedCompound);
        this.addEquivalent(compound, lowerCasedCompound);
        this.addEquivalent(lowerCasedCompound, compound);
        for (Compound equivalent : equivalents) {
            this.addEquivalent(compound, equivalent);
            this.addEquivalent(equivalent, compound);
            this.addEquivalent(lowerCasedCompound, equivalent);
            this.addEquivalent(equivalent, lowerCasedCompound);
        }
    }

    protected void addCompound(C compound, C lowerCasedCompound, C ... equivalents) {
        ArrayList<C> equiv = new ArrayList<C>(equivalents.length);
        equiv.addAll(Arrays.asList(equivalents));
        this.addCompound(compound, lowerCasedCompound, (Iterable<C>)equiv);
    }

    protected void addEquivalent(C compound, C equivalent) {
        Set<C> s = this.equivalentsMap.get(compound);
        if (s == null) {
            s = new HashSet<C>();
            this.equivalentsMap.put(compound, s);
        }
        s.add(equivalent);
    }

    protected void addCompound(C compound) {
        this.charSeqToCompound.put(compound.toString(), compound);
        this.maxCompoundCharSequenceLength = -1;
        this.compoundStringLengthEqual = null;
    }

    @Override
    public String getStringForCompound(C compound) {
        return compound.toString();
    }

    @Override
    public C getCompoundForString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Given a null CharSequence to process");
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.length() > this.getMaxSingleCompoundStringLength()) {
            throw new IllegalArgumentException("CharSequence supplied is too long.");
        }
        return (C)((Compound)this.charSeqToCompound.get(string));
    }

    @Override
    public int getMaxSingleCompoundStringLength() {
        if (this.maxCompoundCharSequenceLength == -1) {
            for (Compound compound : this.charSeqToCompound.values()) {
                int size = this.getStringForCompound(compound).length();
                if (size <= this.maxCompoundCharSequenceLength) continue;
                this.maxCompoundCharSequenceLength = size;
            }
        }
        return this.maxCompoundCharSequenceLength;
    }

    @Override
    public boolean isCompoundStringLengthEqual() {
        if (this.compoundStringLengthEqual == null) {
            int lastSize = -1;
            this.compoundStringLengthEqual = Boolean.TRUE;
            for (CharSequence c : this.charSeqToCompound.keySet()) {
                if (lastSize == c.length()) continue;
                this.compoundStringLengthEqual = Boolean.FALSE;
                break;
            }
        }
        return this.compoundStringLengthEqual;
    }

    @Override
    public boolean hasCompound(C compound) {
        C retrievedCompound = this.getCompoundForString(compound.toString());
        return retrievedCompound != null;
    }

    @Override
    public boolean compoundsEquivalent(C compoundOne, C compoundTwo) {
        this.assertCompound(compoundOne);
        this.assertCompound(compoundTwo);
        return compoundOne.equals(compoundTwo) || this.equivalentsMap.get(compoundOne).contains(compoundTwo);
    }

    @Override
    public Set<C> getEquivalentCompounds(C compound) {
        return this.equivalentsMap.get(compound);
    }

    public boolean compoundsEqual(C compoundOne, C compoundTwo) {
        this.assertCompound(compoundOne);
        this.assertCompound(compoundTwo);
        return compoundOne.equalsIgnoreCase((Compound)compoundTwo);
    }

    @Override
    public boolean isValidSequence(Sequence<C> sequence) {
        for (Compound compound : sequence) {
            if (this.hasCompound(compound)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<C> getAllCompounds() {
        return new ArrayList<C>(this.charSeqToCompound.values());
    }

    private void assertCompound(C compound) {
        if (!this.hasCompound(compound)) {
            logger.warn("The CompoundSet {} knows nothing about the compound {}", (Object)this.getClass().getSimpleName(), compound);
        }
    }

    @Override
    public boolean isComplementable() {
        return false;
    }

    public int hashCode() {
        int s = 9;
        s = Hashcoder.hash(s, this.charSeqToCompound);
        s = Hashcoder.hash(s, this.equivalentsMap);
        return s;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractCompoundSet)) {
            return false;
        }
        if (Equals.classEqual(this, o)) {
            AbstractCompoundSet that = (AbstractCompoundSet)o;
            return Equals.equal(this.charSeqToCompound, that.charSeqToCompound) && Equals.equal(this.equivalentsMap, that.equivalentsMap);
        }
        return false;
    }
}

