/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.GetMemory;
import jalview.util.ErrorLog;
import java.util.Locale;

public class MemorySetting {
    public static final String MAX_HEAPSIZE_PERCENT_PROPERTY_NAME = "jvmmempc";
    public static final String MAX_HEAPSIZE_PROPERTY_NAME = "jvmmemmax";
    private static final int MAX_HEAPSIZE_PERCENT_DEFAULT = 90;
    private static final long GIGABYTE = 0x40000000L;
    public static final long LEAVE_FREE_MIN_MEMORY = 0x20000000L;
    public static final long APPLICATION_MIN_MEMORY = 0x20000000L;
    private static final long MAX_HEAPSIZE_GB_DEFAULT = 32L;
    private static final long NOMEM_MAX_HEAPSIZE_GB_DEFAULT = 8L;
    public static final String NS = "MEMORY";
    public static final String CUSTOMISED_SETTINGS = "MEMORY_CUSTOMISED_SETTINGS";
    public static final String MEMORY_JVMMEMPC = "MEMORY_" + "jvmmempc".toUpperCase(Locale.ROOT);
    public static final String MEMORY_JVMMEMMAX = "MEMORY_" + "jvmmemmax".toUpperCase(Locale.ROOT);
    protected static boolean logToClassChecked = false;
    public static String memorySuffixes = "bkmgt";
    private static String ADJUSTMENT_MESSAGE = null;

    public static long getMemorySetting() {
        return MemorySetting.getMemorySetting(null, null);
    }

    public static long getMemorySetting(String jvmmemmaxarg, String jvmmempcarg) {
        return MemorySetting.getMemorySetting(jvmmemmaxarg, jvmmempcarg, true, false);
    }

    public static long getMemorySetting(String jvmmemmaxarg, String jvmmempcarg, boolean useProps, boolean quiet) {
        String jvmmemmax;
        long maxMemLong = -1L;
        MemorySetting.clearAdjustmentMessage();
        long memmax = 0x800000000L;
        if (jvmmemmaxarg == null && useProps) {
            jvmmemmaxarg = System.getProperty(MAX_HEAPSIZE_PROPERTY_NAME);
        }
        if ((jvmmemmax = jvmmemmaxarg) != null && jvmmemmax.length() > 0) {
            try {
                memmax = MemorySetting.memoryStringToLong(jvmmemmax);
                if (memmax == 0L) {
                    throw new NumberFormatException("Not allowing 0");
                }
            }
            catch (NumberFormatException e) {
                memmax = 0x800000000L;
                MemorySetting.setAdjustmentMessage("MemorySetting Property 'jvmmemmax' (" + jvmmemmaxarg + "') badly formatted or 0, using default (" + 32L + "g).", quiet);
            }
            if (memmax < 0x20000000L) {
                memmax = 0x20000000L;
                MemorySetting.setAdjustmentMessage("MemorySetting Property 'jvmmemmax' (" + jvmmemmaxarg + ") too small, using minimum (" + 0x20000000L + ").", quiet);
            }
        }
        float percent = 90.0f;
        if (jvmmempcarg == null && useProps) {
            jvmmempcarg = System.getProperty(MAX_HEAPSIZE_PERCENT_PROPERTY_NAME);
        }
        String jvmmempc = jvmmempcarg;
        long mempc = -1L;
        try {
            if (jvmmempc != null) {
                int trypercent = Integer.parseInt(jvmmempc);
                if (0 <= trypercent && trypercent <= 100) {
                    percent = trypercent;
                } else {
                    MemorySetting.setAdjustmentMessage("MemorySetting Property 'jvmmempc' should be in range 0..100. Using default " + percent + "%", quiet);
                }
            }
        }
        catch (NumberFormatException e) {
            MemorySetting.setAdjustmentMessage("MemorySetting property 'jvmmempc' (" + jvmmempcarg + ") badly formatted", quiet);
        }
        boolean memoryPercentError = false;
        try {
            long physicalMem = GetMemory.getPhysicalMemory();
            if (physicalMem > 0x20000000L) {
                mempc = (long)((float)physicalMem / 100.0f * percent);
                boolean reducedmempc = false;
                if (physicalMem - mempc < 0x20000000L) {
                    mempc = physicalMem - 0x20000000L;
                    reducedmempc = true;
                    MemorySetting.setAdjustmentMessage("MemorySetting Property 'jvmmempc' (" + jvmmempcarg + ") too large. Leaving free space for OS and reducing to (" + mempc + ").", quiet);
                }
                if (mempc < 0x20000000L) {
                    if (reducedmempc) {
                        MemorySetting.setAdjustmentMessage("Reduced MemorySetting (" + mempc + ") too small. Increasing to application minimum (" + 0x20000000L + ").", quiet);
                    } else {
                        MemorySetting.setAdjustmentMessage("MemorySetting Property 'jvmmempc' (" + jvmmempcarg + ") too small. Using minimum (" + 0x20000000L + ").", quiet);
                    }
                    mempc = 0x20000000L;
                }
            } else {
                mempc = physicalMem;
                MemorySetting.setAdjustmentMessage("Not enough physical memory for application. Ignoring MemorySetting Property 'jvmmempc' (" + jvmmempcarg + "). Using maximum memory available (" + physicalMem + ").", quiet);
            }
        }
        catch (Throwable t) {
            memoryPercentError = true;
            MemorySetting.setAdjustmentMessage("Problem calling GetMemory.getPhysicalMemory(). Likely to be problem with com.sun.management.OperatingSystemMXBean", quiet);
            t.printStackTrace();
        }
        if (memoryPercentError && mempc == -1L && (jvmmempcarg != null || jvmmemmaxarg == null) && memmax > 0x200000000L) {
            MemorySetting.setAdjustmentMessage("Capping maximum memory to 8g due to failure to read physical memory size.", quiet);
            memmax = 0x200000000L;
        }
        maxMemLong = mempc == -1L ? memmax : Math.min(mempc, memmax);
        return maxMemLong;
    }

    public static boolean isValidMemoryString(String text) {
        if (text.length() > 0) {
            char[] otherChars;
            char lastChar = text.charAt(text.length() - 1);
            for (char c : otherChars = text.substring(0, text.length() - 1).toCharArray()) {
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            if ((lastChar < '0' || lastChar > '9') && memorySuffixes.indexOf(Character.toLowerCase(lastChar)) == -1) {
                return false;
            }
        }
        return true;
    }

    public static long memoryStringToLong(String memString) throws NumberFormatException {
        if (!MemorySetting.isValidMemoryString(memString)) {
            throw new NumberFormatException("Not a valid memory string");
        }
        char suffix = Character.toLowerCase(memString.charAt(memString.length() - 1));
        if ('0' <= suffix && suffix <= '9') {
            return Long.valueOf(memString);
        }
        if (memorySuffixes.indexOf(suffix) == -1) {
            return -1L;
        }
        long multiplier = (long)Math.pow(2.0, memorySuffixes.indexOf(suffix) * 10);
        long mem = Long.parseLong(memString.substring(0, memString.length() - 1));
        if (mem == 0L) {
            return 0L;
        }
        if (Long.MAX_VALUE / mem > multiplier) {
            return multiplier * mem;
        }
        ErrorLog.outPrintln("Memory parsing of '" + memString + "' produces number too big.  Limiting to Long.MAX_VALUE=" + Long.MAX_VALUE);
        return Long.MAX_VALUE;
    }

    public static String memoryLongToString(long mem) {
        return MemorySetting.memoryLongToString(mem, "%.3f");
    }

    public static String memoryLongToString(long mem, String format) {
        int exponent = 0;
        float num = mem;
        char suffix = 'b';
        for (int i = 0; i < memorySuffixes.length(); ++i) {
            char s = Character.toUpperCase(memorySuffixes.charAt(i));
            if (mem < (long)Math.pow(2.0, exponent + 10) || i == memorySuffixes.length() - 1) {
                suffix = s;
                num = (float)((double)mem / Math.pow(2.0, exponent));
                break;
            }
            exponent += 10;
        }
        return String.format(format, Float.valueOf(num)) + suffix;
    }

    private static void setAdjustmentMessage(String reason, boolean quiet) {
        ADJUSTMENT_MESSAGE = reason;
        if (!quiet) {
            ErrorLog.outPrintln(reason);
        }
    }

    public static void clearAdjustmentMessage() {
        ADJUSTMENT_MESSAGE = null;
    }

    public static String getAdjustmentMessage() {
        return ADJUSTMENT_MESSAGE;
    }
}

