/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import jalview.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class Downloader {
    protected Map<Resource, Long> _sizes = new HashMap<Resource, Long>();
    protected Map<Resource, Long> _downloaded = new HashMap<Resource, Long>();
    protected long _start;
    protected long _bytesPerSecond;
    protected long _lastUpdate;
    protected volatile State _state = State.DOWNLOADING;
    protected static final long UPDATE_DELAY = 500L;

    public boolean download(Collection<Resource> resources, int maxConcurrent) {
        this.resolvingDownloads();
        for (Resource rsrc : resources) {
            try {
                this._sizes.put(rsrc, Math.max(this.checkSize(rsrc), 0L));
            }
            catch (IOException ioe) {
                this.downloadFailed(rsrc, ioe);
            }
        }
        long totalSize = Downloader.sum(this._sizes.values());
        Log.log.info("Downloading " + resources.size() + " resources", "totalBytes", totalSize, "maxConcurrent", maxConcurrent);
        this._start = System.currentTimeMillis();
        ExecutorService exec = Executors.newFixedThreadPool(maxConcurrent);
        for (final Resource rsrc : resources) {
            File parent = new File(rsrc.getLocal().getParent());
            if (!parent.exists() && !FileUtils.mkdirs(parent)) {
                Log.log.warning("Failed to create target directory for resource '" + rsrc + "'.", new Object[0]);
            }
            exec.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Downloader.this._state != State.ABORTED) {
                            Downloader.this.download(rsrc);
                        }
                    }
                    catch (IOException ioe) {
                        Downloader.this._state = State.FAILED;
                        Downloader.this.downloadFailed(rsrc, ioe);
                    }
                }
            });
        }
        exec.shutdown();
        try {
            exec.awaitTermination(10L, TimeUnit.DAYS);
            if (this._state == State.DOWNLOADING) {
                this.downloadProgress(100, 0L);
            }
        }
        catch (InterruptedException ie) {
            exec.shutdownNow();
            this.downloadFailed(null, ie);
        }
        return this._state != State.ABORTED;
    }

    public void abort() {
        this._state = State.ABORTED;
    }

    protected void resolvingDownloads() {
    }

    protected void downloadProgress(int percent, long remaining) {
    }

    protected void downloadFailed(Resource rsrc, Exception cause) {
    }

    protected abstract long checkSize(Resource var1) throws IOException;

    protected synchronized void reportProgress(Resource rsrc, long currentSize, long actualSize) {
        actualSize = Math.max(actualSize, this._sizes.get(rsrc));
        this._sizes.put(rsrc, actualSize);
        this._downloaded.put(rsrc, Math.min(actualSize, currentSize));
        long now = System.currentTimeMillis();
        if (now - this._lastUpdate >= 500L) {
            long remaining;
            this._lastUpdate = now;
            long downloaded = Downloader.sum(this._downloaded.values());
            long totalSize = Downloader.sum(this._sizes.values());
            long secs = (now - this._start) / 1000L;
            long bps = secs == 0L ? 0L : downloaded / secs;
            int pctdone = totalSize == 0L ? 0 : (int)((float)downloaded * 100.0f / (float)totalSize);
            long l = remaining = bps <= 0L || totalSize == 0L ? -1L : (totalSize - downloaded) / bps;
            if (this._state == State.DOWNLOADING) {
                if (pctdone == 100) {
                    this._state = State.COMPLETE;
                }
                this.downloadProgress(pctdone, remaining);
            }
        }
    }

    protected static long sum(Iterable<Long> values) {
        long acc = 0L;
        for (Long value : values) {
            acc += value.longValue();
        }
        return acc;
    }

    protected abstract void download(Resource var1) throws IOException;

    protected static enum State {
        DOWNLOADING,
        COMPLETE,
        FAILED,
        ABORTED;

    }
}

