/*
 * Decompiled with CFR 0.152.
 */
package org.jcolorbrewer;

import java.awt.Color;
import java.util.ArrayList;

public enum ColorBrewer {
    BrBG(1, "Brown-Blue-Green", true, new int[][]{{14201701}, {14201701, 5944492}, {14201701, 0xF5F5F5, 5944492}, {0xA6611A, 14664317, 8441281, 99697}, {0xA6611A, 14664317, 0xF5F5F5, 8441281, 99697}, {9195786, 14201701, 16181443, 13101797, 5944492, 91742}, {9195786, 14201701, 16181443, 0xF5F5F5, 13101797, 5944492, 91742}, {9195786, 12550445, 14664317, 16181443, 13101797, 8441281, 3512207, 91742}, {9195786, 12550445, 14664317, 16181443, 0xF5F5F5, 13101797, 8441281, 3512207, 91742}, {5517317, 9195786, 12550445, 14664317, 16181443, 13101797, 8441281, 3512207, 91742, 15408}, {5517317, 9195786, 12550445, 14664317, 16181443, 0xF5F5F5, 13101797, 8441281, 3512207, 91742, 15408}}),
    PiYG(1, "Magenta-Yellow-Green", true, new int[][]{{15311817}, {15311817, 10606442}, {15311817, 0xF7F7F7, 10606442}, {13638795, 15840986, 12116358, 5090342}, {13638795, 15840986, 0xF7F7F7, 12116358, 5090342}, {12917629, 15311817, 16638191, 15136208, 10606442, 5083681}, {12917629, 15311817, 16638191, 0xF7F7F7, 15136208, 10606442, 5083681}, {12917629, 14579630, 15840986, 16638191, 15136208, 12116358, 8371265, 5083681}, {12917629, 14579630, 15840986, 16638191, 0xF7F7F7, 15136208, 12116358, 8371265, 5083681}, {9306450, 12917629, 14579630, 15840986, 16638191, 15136208, 12116358, 8371265, 5083681, 2581529}, {9306450, 12917629, 14579630, 15840986, 16638191, 0xF7F7F7, 15136208, 12116358, 8371265, 5083681, 2581529}}),
    PRGn(1, "Purple-Red-Green", true, new int[][]{{11505091}, {11505091, 0x7FBF7B}, {11505091, 0xF7F7F7, 0x7FBF7B}, {8073876, 12756431, 10935200, 34871}, {8073876, 12756431, 0xF7F7F7, 10935200, 34871}, {7744131, 11505091, 15193320, 14282963, 0x7FBF7B, 1800247}, {7744131, 11505091, 15193320, 0xF7F7F7, 14282963, 0x7FBF7B, 1800247}, {7744131, 10055851, 12756431, 15193320, 14282963, 10935200, 5942881, 1800247}, {7744131, 10055851, 12756431, 15193320, 0xF7F7F7, 14282963, 10935200, 5942881, 1800247}, {0x40004B, 7744131, 10055851, 12756431, 15193320, 14282963, 10935200, 5942881, 1800247, 17435}, {0x40004B, 7744131, 10055851, 12756431, 15193320, 0xF7F7F7, 14282963, 10935200, 5942881, 1800247, 17435}}),
    PuOr(1, "Purple-Orange", true, new int[][]{{15835968}, {15835968, 10063555}, {15835968, 0xF7F7F7, 10063555}, {15098113, 16627811, 11709394, 6175897}, {15098113, 16627811, 0xF7F7F7, 11709394, 6175897}, {11753478, 15835968, 16703670, 14211819, 10063555, 5515144}, {11753478, 15835968, 16703670, 0xF7F7F7, 14211819, 10063555, 5515144}, {11753478, 14713364, 16627811, 16703670, 14211819, 11709394, 8418220, 5515144}, {11753478, 14713364, 16627811, 16703670, 0xF7F7F7, 14211819, 11709394, 8418220, 5515144}, {8338184, 11753478, 14713364, 16627811, 16703670, 14211819, 11709394, 8418220, 5515144, 2949195}, {8338184, 11753478, 14713364, 16627811, 16703670, 0xF7F7F7, 14211819, 11709394, 8418220, 5515144, 2949195}}),
    RdBu(1, "Red-Blue", true, new int[][]{{15698530}, {15698530, 6793679}, {15698530, 0xF7F7F7, 6793679}, {13238304, 16033154, 9618910, 356784}, {13238304, 16033154, 0xF7F7F7, 9618910, 356784}, {11671595, 15698530, 16636871, 13755888, 6793679, 2188972}, {11671595, 15698530, 16636871, 0xF7F7F7, 13755888, 6793679, 2188972}, {11671595, 14049357, 16033154, 16636871, 13755888, 9618910, 4428739, 2188972}, {11671595, 14049357, 16033154, 16636871, 0xF7F7F7, 13755888, 9618910, 4428739, 2188972}, {6750239, 11671595, 14049357, 16033154, 16636871, 13755888, 9618910, 4428739, 2188972, 340065}, {6750239, 11671595, 14049357, 16033154, 16636871, 0xF7F7F7, 13755888, 9618910, 4428739, 2188972, 340065}}),
    RdGy(1, "Red-Grey", false, new int[][]{{15698530}, {15698530, 0x999999}, {15698530, 0xFFFFFF, 0x999999}, {13238304, 16033154, 0xBABABA, 0x404040}, {13238304, 16033154, 0xFFFFFF, 0xBABABA, 0x404040}, {11671595, 15698530, 16636871, 0xE0E0E0, 0x999999, 0x4D4D4D}, {11671595, 15698530, 16636871, 0xFFFFFF, 0xE0E0E0, 0x999999, 0x4D4D4D}, {11671595, 14049357, 16033154, 16636871, 0xE0E0E0, 0xBABABA, 0x878787, 0x4D4D4D}, {11671595, 14049357, 16033154, 16636871, 0xFFFFFF, 0xE0E0E0, 0xBABABA, 0x878787, 0x4D4D4D}, {6750239, 11671595, 14049357, 16033154, 16636871, 0xE0E0E0, 0xBABABA, 0x878787, 0x4D4D4D, 0x1A1A1A}, {6750239, 11671595, 14049357, 16033154, 16636871, 0xFFFFFF, 0xE0E0E0, 0xBABABA, 0x878787, 0x4D4D4D, 0x1A1A1A}}),
    RdYlBu(1, "Red-Yellow-Blue", true, new int[][]{{16551257}, {16551257, 9551835}, {16551257, 0xFFFFBF, 9551835}, {14096668, 16625249, 11262441, 2915254}, {14096668, 16625249, 0xFFFFBF, 11262441, 2915254}, {14102567, 16551257, 16703632, 14742520, 9551835, 4552116}, {14102567, 16551257, 16703632, 0xFFFFBF, 14742520, 9551835, 4552116}, {14102567, 16018755, 16625249, 16703632, 14742520, 11262441, 7646673, 4552116}, {14102567, 16018755, 16625249, 16703632, 0xFFFFBF, 14742520, 11262441, 7646673, 4552116}, {10813478, 14102567, 16018755, 16625249, 16703632, 14742520, 11262441, 7646673, 4552116, 3225237}, {10813478, 14102567, 16018755, 16625249, 16703632, 0xFFFFBF, 14742520, 11262441, 7646673, 4552116, 3225237}}),
    RdYlGn(1, "Red-Yellow-Green", false, new int[][]{{16551257}, {16551257, 9555808}, {16551257, 0xFFFFBF, 9555808}, {14096668, 16625249, 10934634, 1742401}, {14096668, 16625249, 0xFFFFBF, 10934634, 1742401}, {14102567, 16551257, 16703627, 14282635, 9555808, 1742928}, {14102567, 16551257, 16703627, 0xFFFFBF, 14282635, 9555808, 1742928}, {14102567, 16018755, 16625249, 16703627, 14282635, 10934634, 6733155, 1742928}, {14102567, 16018755, 16625249, 16703627, 0xFFFFBF, 14282635, 10934634, 6733155, 1742928}, {10813478, 14102567, 16018755, 16625249, 16703627, 14282635, 10934634, 6733155, 1742928, 26679}, {10813478, 14102567, 16018755, 16625249, 16703627, 0xFFFFBF, 14282635, 10934634, 6733155, 1742928, 26679}}),
    Spectral(1, "Spectral colors", false, new int[][]{{16551257}, {16551257, 10081684}, {16551257, 0xFFFFBF, 10081684}, {14096668, 16625249, 11263396, 2851770}, {14096668, 16625249, 0xFFFFBF, 11263396, 2851770}, {13975119, 16551257, 16703627, 15136152, 10081684, 3311805}, {13975119, 16551257, 16703627, 0xFFFFBF, 15136152, 10081684, 3311805}, {13975119, 16018755, 16625249, 16703627, 15136152, 11263396, 6734501, 3311805}, {13975119, 16018755, 16625249, 16703627, 0xFFFFBF, 15136152, 11263396, 6734501, 3311805}, {10355010, 13975119, 16018755, 16625249, 16703627, 15136152, 11263396, 6734501, 3311805, 6180770}, {10355010, 13975119, 16018755, 16625249, 16703627, 0xFFFFBF, 15136152, 11263396, 6734501, 3311805, 6180770}}),
    Accent(2, "Accents", false, new int[][]{{8374655}, {8374655, 16629894}, {8374655, 12496596, 16629894}, {8374655, 12496596, 16629894, 0xFFFF99}, {8374655, 12496596, 16629894, 0xFFFF99, 3697840}, {8374655, 12496596, 16629894, 0xFFFF99, 3697840, 15729279}, {8374655, 12496596, 16629894, 0xFFFF99, 3697840, 15729279, 12540695}, {8374655, 12496596, 16629894, 0xFFFF99, 3697840, 15729279, 12540695, 0x666666}}),
    Dark2(2, "Dark colors", false, new int[][]{{1810039}, {1810039, 7696563}, {1810039, 14245634, 7696563}, {1810039, 14245634, 7696563, 15149450}, {1810039, 14245634, 7696563, 15149450, 6727198}, {1810039, 14245634, 7696563, 15149450, 6727198, 15117058}, {1810039, 14245634, 7696563, 15149450, 6727198, 15117058, 10909213}, {1810039, 14245634, 7696563, 15149450, 6727198, 15117058, 10909213, 0x666666}}),
    Paired(2, "Paired colors", true, new int[][]{{10931939}, {10931939, 11722634}, {10931939, 2062516, 11722634}, {10931939, 2062516, 11722634, 3383340}, {10931939, 2062516, 11722634, 3383340, 16489113}, {10931939, 2062516, 11722634, 3383340, 16489113, 14883356}, {10931939, 2062516, 11722634, 3383340, 16489113, 14883356, 16629615}, {10931939, 2062516, 11722634, 3383340, 16489113, 14883356, 16629615, 0xFF7F00}, {10931939, 2062516, 11722634, 3383340, 16489113, 14883356, 16629615, 0xFF7F00, 13284054}, {10931939, 2062516, 11722634, 3383340, 16489113, 14883356, 16629615, 0xFF7F00, 13284054, 6962586}, {10931939, 2062516, 11722634, 3383340, 16489113, 14883356, 16629615, 0xFF7F00, 13284054, 6962586, 0xFFFF99}}),
    Pastel1(2, "Pastel1 colors", false, new int[][]{{16495790}, {16495790, 13429701}, {16495790, 11783651, 13429701}, {16495790, 11783651, 13429701, 14601188}, {16495790, 11783651, 13429701, 14601188, 16701862}, {16495790, 11783651, 13429701, 14601188, 16701862, 0xFFFFCC}, {16495790, 11783651, 13429701, 14601188, 16701862, 0xFFFFCC, 15063229}, {16495790, 11783651, 13429701, 14601188, 16701862, 0xFFFFCC, 15063229, 16636652}, {16495790, 11783651, 13429701, 14601188, 16701862, 0xFFFFCC, 15063229, 16636652, 0xF2F2F2}}),
    Pastel2(2, "Pastel2 colors", false, new int[][]{{11789005}, {11789005, 13358568}, {11789005, 16633260, 13358568}, {11789005, 16633260, 13358568, 16042724}, {11789005, 16633260, 13358568, 16042724, 15136201}, {11789005, 16633260, 13358568, 16042724, 15136201, 16773806}, {11789005, 16633260, 13358568, 16042724, 15136201, 16773806, 15852236}, {11789005, 16633260, 13358568, 16042724, 15136201, 16773806, 15852236, 0xCCCCCC}}),
    Set1(2, "Set1 colors", false, new int[][]{{14948892}, {14948892, 5091146}, {14948892, 3636920, 5091146}, {14948892, 3636920, 5091146, 9981603}, {14948892, 3636920, 5091146, 9981603, 0xFF7F00}, {14948892, 3636920, 5091146, 9981603, 0xFF7F00, 0xFFFF33}, {14948892, 3636920, 5091146, 9981603, 0xFF7F00, 0xFFFF33, 10901032}, {14948892, 3636920, 5091146, 9981603, 0xFF7F00, 0xFFFF33, 10901032, 16220607}, {14948892, 3636920, 5091146, 9981603, 0xFF7F00, 0xFFFF33, 10901032, 16220607, 0x999999}}),
    Set2(2, "Set2 colors", false, new int[][]{{6734501}, {6734501, 9281739}, {6734501, 16551266, 9281739}, {6734501, 16551266, 9281739, 15174339}, {6734501, 16551266, 9281739, 15174339, 10934356}, {6734501, 16551266, 9281739, 15174339, 10934356, 16767279}, {6734501, 16551266, 9281739, 15174339, 10934356, 16767279, 15058068}, {6734501, 16551266, 9281739, 15174339, 10934356, 16767279, 15058068, 736059}}),
    Set3(2, "Set3 colors", false, new int[][]{{9294791}, {9294791, 12499674}, {9294791, 0xFFFFB3, 12499674}, {9294791, 0xFFFFB3, 12499674, 16482418}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131, 16626786}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131, 16626786, 11787881}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131, 16626786, 11787881, 16567781}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131, 16626786, 11787881, 16567781, 0xD9D9D9}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131, 16626786, 11787881, 16567781, 0xD9D9D9, 12353725}, {9294791, 0xFFFFB3, 12499674, 16482418, 8434131, 16626786, 11787881, 16567781, 0xD9D9D9, 12353725, 13429701}}),
    Blues(3, "Blue shades", true, new int[][]{{14609399}, {14609399, 3244733}, {14609399, 10406625, 3244733}, {0xEFF3FF, 12441575, 7057110, 2191797}, {0xEFF3FF, 12441575, 7057110, 3244733, 545180}, {0xEFF3FF, 13032431, 10406625, 7057110, 3244733, 545180}, {0xEFF3FF, 13032431, 10406625, 7057110, 4362950, 2191797, 542100}, {0xF7FBFF, 14609399, 13032431, 10406625, 7057110, 4362950, 2191797, 542100}, {0xF7FBFF, 14609399, 13032431, 10406625, 7057110, 4362950, 2191797, 545180, 536683}}),
    BuGn(3, "Blue-Green shades", true, new int[][]{{15070713}, {15070713, 2925151}, {15070713, 10082505, 2925151}, {15595771, 0xB2E2E2, 6734500, 2329413}, {15595771, 0xB2E2E2, 6734500, 2925151, 27948}, {15595771, 0xCCECE6, 10082505, 6734500, 2925151, 27948}, {15595771, 0xCCECE6, 10082505, 6734500, 4304502, 2329413, 22564}, {16252157, 15070713, 0xCCECE6, 10082505, 6734500, 4304502, 2329413, 22564}, {16252157, 15070713, 0xCCECE6, 10082505, 6734500, 4304502, 2329413, 27948, 17435}}),
    BuPu(3, "Blue-Purple shades", true, new int[][]{{14740724}, {14740724, 8935079}, {14740724, 10403034, 8935079}, {15595771, 11783651, 9213638, 8929693}, {15595771, 11783651, 9213638, 8935079, 8458108}, {15595771, 12571622, 10403034, 9213638, 8935079, 8458108}, {15595771, 12571622, 10403034, 9213638, 9202609, 8929693, 7209323}, {16252157, 14740724, 12571622, 10403034, 9213638, 9202609, 8929693, 7209323}, {16252157, 14740724, 12571622, 10403034, 9213638, 9202609, 8929693, 8458108, 5046347}}),
    GnBu(3, "Green-Blue shades", true, new int[][]{{14742491}, {14742491, 4432586}, {14742491, 11066805, 4432586}, {15792616, 12248252, 8113348, 2854078}, {15792616, 12248252, 8113348, 4432586, 551084}, {15792616, 13429701, 11066805, 8113348, 4432586, 551084}, {15792616, 13429701, 11066805, 8113348, 5157843, 2854078, 546974}, {16252144, 14742491, 13429701, 11066805, 8113348, 5157843, 2854078, 546974}, {16252144, 14742491, 13429701, 11066805, 8113348, 5157843, 2854078, 551084, 540801}}),
    Greens(3, "Green shades", true, new int[][]{{15070688}, {15070688, 3253076}, {15070688, 10607003, 3253076}, {15595753, 12248243, 7652470, 2329413}, {15595753, 12248243, 7652470, 3253076, 27948}, {15595753, 13101504, 10607003, 7652470, 3253076, 27948}, {15595753, 13101504, 10607003, 7652470, 4303709, 2329413, 23090}, {16252149, 15070688, 13101504, 10607003, 7652470, 4303709, 2329413, 23090}, {16252149, 15070688, 13101504, 10607003, 7652470, 4303709, 2329413, 27948, 17435}}),
    Greys(3, "Grey shades", true, new int[][]{{0xF0F0F0}, {0xF0F0F0, 0x636363}, {0xF0F0F0, 0xBDBDBD, 0x636363}, {0xF7F7F7, 0xCCCCCC, 0x969696, 0x525252}, {0xF7F7F7, 0xCCCCCC, 0x969696, 0x636363, 0x252525}, {0xF7F7F7, 0xD9D9D9, 0xBDBDBD, 0x969696, 0x636363, 0x252525}, {0xF7F7F7, 0xD9D9D9, 0xBDBDBD, 0x969696, 0x737373, 0x525252, 0x252525}, {0xFFFFFF, 0xF0F0F0, 0xD9D9D9, 0xBDBDBD, 0x969696, 0x737373, 0x525252, 0x252525}, {0xFFFFFF, 0xF0F0F0, 0xD9D9D9, 0xBDBDBD, 0x969696, 0x737373, 0x525252, 0x252525, 0}}),
    Oranges(3, "Orange shades", true, new int[][]{{16705230}, {16705230, 15095053}, {16705230, 16625259, 15095053}, {0xFEEDDE, 16629381, 16616764, 14239489}, {0xFEEDDE, 16629381, 16616764, 15095053, 10892803}, {0xFEEDDE, 16634018, 16625259, 16616764, 15095053, 10892803}, {0xFEEDDE, 16634018, 16625259, 16616764, 15821075, 14239745, 9186564}, {16774635, 16705230, 16634018, 16625259, 16616764, 15821075, 14239745, 9186564}, {16774635, 16705230, 16634018, 16625259, 16616764, 15821075, 14239745, 10892803, 8333060}}),
    OrRd(3, "Orange-Red shades", true, new int[][]{{16705736}, {16705736, 14895667}, {16705736, 16628612, 14895667}, {16707801, 16632970, 16551257, 14102559}, {16707801, 16632970, 16551257, 14895667, 0xB30000}, {16707801, 16635038, 16628612, 16551257, 14895667, 0xB30000}, {16707801, 16635038, 16628612, 16551257, 15689032, 14102559, 0x990000}, {16775148, 16705736, 16635038, 16628612, 16551257, 15689032, 14102559, 0x990000}, {16775148, 16705736, 16635038, 16628612, 16551257, 15689032, 14102559, 0xB30000, 0x7F0000}}),
    PuBu(3, "Purple-Blue shades", true, new int[][]{{15525874}, {15525874, 2854078}, {15525874, 10927579, 2854078}, {15855350, 12437985, 7645647, 356528}, {15855350, 12437985, 7645647, 2854078, 285325}, {15855350, 13685222, 10927579, 7645647, 2854078, 285325}, {15855350, 13685222, 10927579, 7645647, 3576000, 356528, 216699}, {0xFFF7FB, 15525874, 13685222, 10927579, 7645647, 3576000, 356528, 216699}, {0xFFF7FB, 15525874, 13685222, 10927579, 7645647, 3576000, 356528, 285325, 145496}}),
    PuBuGn(3, "Purple-Blue-Green shades", true, new int[][]{{15524592}, {15524592, 1872025}, {15524592, 10927579, 1872025}, {16183287, 12437985, 6793679, 164234}, {16183287, 12437985, 6793679, 1872025, 93273}, {16183287, 13685222, 10927579, 6793679, 1872025, 93273}, {16183287, 13685222, 10927579, 6793679, 3576000, 164234, 91216}, {0xFFF7FB, 15524592, 13685222, 10927579, 6793679, 3576000, 164234, 91216}, {0xFFF7FB, 15524592, 13685222, 10927579, 6793679, 3576000, 164234, 93273, 83510}}),
    PuRd(3, "Purple-Red shades", true, new int[][]{{15196655}, {15196655, 14490743}, {15196655, 13210823, 14490743}, {15855350, 14136792, 14640560, 13505110}, {15855350, 14136792, 14640560, 14490743, 9961539}, {15855350, 13941210, 13210823, 14640560, 14490743, 9961539}, {15855350, 13941210, 13210823, 14640560, 15149450, 13505110, 9502783}, {16250105, 15196655, 13941210, 13210823, 14640560, 15149450, 13505110, 9502783}, {16250105, 15196655, 13941210, 13210823, 14640560, 15149450, 13505110, 9961539, 6750239}}),
    Purples(3, "Purple shades", true, new int[][]{{15724021}, {15724021, 7695281}, {15724021, 0xBCBDDC, 7695281}, {15921399, 13355490, 10394312, 6967715}, {15921399, 13355490, 10394312, 7695281, 5515151}, {15921399, 14342891, 0xBCBDDC, 10394312, 7695281, 5515151}, {15921399, 14342891, 0xBCBDDC, 10394312, 8420794, 6967715, 4854918}, {16579581, 15724021, 14342891, 0xBCBDDC, 10394312, 8420794, 6967715, 4854918}, {16579581, 15724021, 14342891, 0xBCBDDC, 10394312, 8420794, 6967715, 5515151, 4128893}}),
    RdPu(3, "Red-Purple shades", true, new int[][]{{16638173}, {16638173, 12917642}, {16638173, 16424885, 12917642}, {16706530, 16495801, 16214177, 11403646}, {16706530, 16495801, 16214177, 12917642, 7995767}, {16706530, 16565696, 16424885, 16214177, 12917642, 7995767}, {16706530, 16565696, 16424885, 16214177, 14496919, 11403646, 7995767}, {0xFFF7F3, 16638173, 16565696, 16424885, 16214177, 14496919, 11403646, 7995767}, {0xFFF7F3, 16638173, 16565696, 16424885, 16214177, 14496919, 11403646, 7995767, 4784234}}),
    Reds(3, "Red shades", true, new int[][]{{16703698}, {16703698, 14560550}, {16703698, 16552562, 14560550}, {16704985, 16559761, 16476746, 13309981}, {16704985, 16559761, 16476746, 14560550, 10817301}, {16704985, 16563105, 16552562, 16476746, 14560550, 10817301}, {16704985, 16563105, 16552562, 16476746, 15678252, 13309981, 0x99000D}, {0xFFF5F0, 16703698, 16563105, 16552562, 16476746, 15678252, 13309981, 0x99000D}, {0xFFF5F0, 16703698, 16563105, 16552562, 16476746, 15678252, 13309981, 10817301, 6750221}}),
    YlGn(3, "Yellow-Green shades", true, new int[][]{{16252089}, {16252089, 3253076}, {16252089, 11394446, 3253076}, {0xFFFFCC, 12773017, 7915129, 2327619}, {0xFFFFCC, 12773017, 7915129, 3253076, 26679}, {0xFFFFCC, 14282915, 11394446, 7915129, 3253076, 26679}, {0xFFFFCC, 14282915, 11394446, 7915129, 4303709, 2327619, 23090}, {0xFFFFE5, 16252089, 14282915, 11394446, 7915129, 4303709, 2327619, 23090}, {0xFFFFE5, 16252089, 14282915, 11394446, 7915129, 4303709, 2327619, 26679, 17705}}),
    YlGnBu(3, "Yellow-Green-Blue shades", true, new int[][]{{15595697}, {15595697, 2916280}, {15595697, 8375739, 2916280}, {0xFFFFCC, 10607284, 4306628, 2252456}, {0xFFFFCC, 10607284, 4306628, 2916280, 2438292}, {0xFFFFCC, 13101492, 8375739, 4306628, 2916280, 2438292}, {0xFFFFCC, 13101492, 8375739, 4306628, 1937856, 2252456, 797828}, {0xFFFFD9, 15595697, 13101492, 8375739, 4306628, 1937856, 2252456, 797828}, {0xFFFFD9, 15595697, 13101492, 8375739, 4306628, 1937856, 2252456, 2438292, 531800}}),
    YlOrBr(3, "Yellow-Orange-Brown shades", true, new int[][]{{16775100}, {16775100, 14245646}, {16775100, 16696399, 14245646}, {0xFFFFD4, 16701838, 16685353, 13388802}, {0xFFFFD4, 16701838, 16685353, 14245646, 10040324}, {0xFFFFD4, 16704401, 16696399, 16685353, 14245646, 10040324}, {0xFFFFD4, 16704401, 16696399, 16685353, 15495188, 13388802, 9186564}, {0xFFFFE5, 16775100, 16704401, 16696399, 16685353, 15495188, 13388802, 9186564}, {0xFFFFE5, 16775100, 16704401, 16696399, 16685353, 15495188, 13388802, 10040324, 6694150}}),
    YlOrRd(3, "Yellow-Orange-Red shades", true, new int[][]{{16772512}, {16772512, 15743776}, {16772512, 16691788, 15743776}, {0xFFFFB2, 16698460, 16616764, 14883356}, {0xFFFFB2, 16698460, 16616764, 15743776, 12386342}, {0xFFFFB2, 16701814, 16691788, 16616764, 15743776, 12386342}, {0xFFFFB2, 16701814, 16691788, 16616764, 16535082, 14883356, 11599910}, {0xFFFFCC, 16772512, 16701814, 16691788, 16616764, 16535082, 14883356, 11599910}, {0xFFFFCC, 16772512, 16701814, 16691788, 16616764, 16535082, 14883356, 12386342, 8388646}}),
    hsvRdBl(1, "HSV Red-Blue", true, new int[][]{{0xFF0000}, {0xFF0000, 255}, {0xFF0000, 0xFFFFFF, 255}, {0xFF0000, 0xFFAAAA, 0xAAAAFF, 255}, {0xFF0000, 0xFF8080, 0xFFFFFF, 0x8080FF, 255}, {0xFF0000, 0xFF6666, 0xFFCCCC, 0xCCCCFF, 0x6666FF, 255}, {0xFF0000, 0xFF5555, 0xFFAAAA, 0xFFFFFF, 0xAAAAFF, 0x5555FF, 255}, {0xFF0000, 0xFF4949, 0xFF9292, 0xFFDBDB, 0xDBDBFF, 0x9292FF, 0x4949FF, 255}, {0xFF0000, 0xFF4040, 0xFF8080, 0xFFBFBF, 0xFFFFFF, 0xBFBFFF, 0x8080FF, 0x4040FF, 255}, {0xFF0000, 0xFF3939, 0xFF7171, 0xFFAAAA, 0xFFE3E3, 0xE3E3FF, 0xAAAAFF, 0x7171FF, 0x3939FF, 255}, {0xFF0000, 0xFF3333, 0xFF6666, 0xFF9999, 0xFFCCCC, 0xFFFFFF, 0xCCCCFF, 0x9999FF, 0x6666FF, 0x3333FF, 255}}),
    hsvCyMg(1, "HSV Red-Blue", true, new int[][]{{65535}, {65535, 0xFF00FF}, {65535, 0xFFFFFF, 0xFF00FF}, {65535, 0xAAFFFF, 0xFFAAFF, 0xFF00FF}, {65535, 0x80FFFF, 0xFFFFFF, 0xFF80FF, 0xFF00FF}, {65535, 0x66FFFF, 0xCCFFFF, 0xFFCCFF, 0xFF66FF, 0xFF00FF}, {65535, 0x55FFFF, 0xAAFFFF, 0xFFFFFF, 0xFFAAFF, 0xFF55FF, 0xFF00FF}, {65535, 0x49FFFF, 0x92FFFF, 0xDBFFFF, 0xFFDBFF, 0xFF92FF, 0xFF49FF, 0xFF00FF}, {65535, 0x40FFFF, 0x80FFFF, 0xBFFFFF, 0xFFFFFF, 0xFFBFFF, 0xFF80FF, 0xFF40FF, 0xFF00FF}, {65535, 0x39FFFF, 0x71FFFF, 0xAAFFFF, 0xE3FFFF, 0xFFE3FF, 0xFFAAFF, 0xFF71FF, 0xFF39FF, 0xFF00FF}, {65535, 0x33FFFF, 0x66FFFF, 0x99FFFF, 0xCCFFFF, 0xFFFFFF, 0xFFCCFF, 0xFF99FF, 0xFF66FF, 0xFF33FF, 0xFF00FF}});

    private final int paletteType;
    private final String paletteDescription;
    private final int[][] hexColors;
    private boolean colorBlindSave;

    private ColorBrewer(int paletteType, String paletteDescription, boolean colorBlindSave, int[][] hexColors) {
        this.paletteType = paletteType;
        this.paletteDescription = paletteDescription;
        this.colorBlindSave = colorBlindSave;
        this.hexColors = hexColors;
    }

    public String getPaletteDescription() {
        return this.paletteDescription;
    }

    public int getMaximumColorCount() {
        return this.hexColors.length;
    }

    public boolean isColorBlindSave() {
        return this.colorBlindSave;
    }

    public Color[] getColorPalette(int colorCount) {
        if (colorCount < this.getMaximumColorCount()) {
            return this.toColor(colorCount);
        }
        return this.interpolatedColors(colorCount);
    }

    public static ColorBrewer[] getSequentialColorPalettes(boolean colorBlindSave) {
        return ColorBrewer.getPalettes(3, colorBlindSave);
    }

    public static ColorBrewer[] getDivergingColorPalettes(boolean colorBlindSave) {
        return ColorBrewer.getPalettes(1, colorBlindSave);
    }

    public static ColorBrewer[] getQualitativeColorPalettes(boolean colorBlindSave) {
        return ColorBrewer.getPalettes(2, colorBlindSave);
    }

    private static ColorBrewer[] getPalettes(int paletteType, boolean colorBlindSave) {
        ArrayList<ColorBrewer> palettes = new ArrayList<ColorBrewer>();
        if (colorBlindSave) {
            for (ColorBrewer palette : ColorBrewer.values()) {
                if (palette.paletteType != paletteType || !palette.colorBlindSave) continue;
                palettes.add(palette);
            }
        } else {
            for (ColorBrewer palette : ColorBrewer.values()) {
                if (palette.paletteType != paletteType) continue;
                palettes.add(palette);
            }
        }
        return palettes.toArray(new ColorBrewer[palettes.size()]);
    }

    private Color[] interpolatedColors(int colorCount) {
        Color[] colors = new Color[colorCount];
        int maxIndex = this.getMaximumColorCount() - 1;
        float scale = (float)maxIndex / (float)(colorCount - 1);
        for (int i = 0; i < colorCount; ++i) {
            float value = scale * (float)i;
            int index = (int)Math.floor(value);
            Color c1 = new Color(this.hexColors[maxIndex][index]);
            float remainder = 0.0f;
            Color c2 = null;
            if (index + 1 < this.hexColors.length) {
                c2 = new Color(this.hexColors[maxIndex][index + 1]);
                remainder = value - (float)index;
            } else {
                c2 = new Color(this.hexColors[maxIndex][index]);
            }
            int red = Math.round((1.0f - remainder) * (float)c1.getRed() + remainder * (float)c2.getRed());
            int green = Math.round((1.0f - remainder) * (float)c1.getGreen() + remainder * (float)c2.getGreen());
            int blue = Math.round((1.0f - remainder) * (float)c1.getBlue() + remainder * (float)c2.getBlue());
            colors[i] = new Color(red, green, blue);
        }
        return colors;
    }

    private Color[] toColor(int numberOfColors) {
        Color[] colors = new Color[numberOfColors];
        for (int i = 0; i < numberOfColors; ++i) {
            colors[i] = new Color(this.hexColors[numberOfColors - 1][i]);
        }
        return colors;
    }
}

