/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignCalcManagerI;
import jalview.api.AlignCalcWorkerI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import java.util.List;

public abstract class AlignCalcWorker
implements AlignCalcWorkerI {
    protected AlignViewportI alignViewport;
    protected AlignCalcManagerI calcMan;
    protected AlignmentViewPanel ap;
    protected List<AlignmentAnnotation> ourAnnots;

    public AlignCalcWorker(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        this.alignViewport = alignViewport;
        this.calcMan = alignViewport.getCalcManager();
        this.ap = alignPanel;
    }

    protected void abortAndDestroy() {
        if (this.calcMan != null) {
            this.calcMan.workerComplete(this);
        }
        this.alignViewport = null;
        this.calcMan = null;
        this.ap = null;
    }

    @Override
    public boolean involves(AlignmentAnnotation i) {
        return this.ourAnnots != null && this.ourAnnots.contains(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAnnotation() {
        if (this.ourAnnots != null && this.alignViewport != null) {
            AlignmentI alignment = this.alignViewport.getAlignment();
            List<AlignmentAnnotation> list = this.ourAnnots;
            synchronized (list) {
                for (AlignmentAnnotation aa : this.ourAnnots) {
                    alignment.deleteAnnotation(aa, true);
                }
            }
            this.ourAnnots.clear();
        }
    }

    @Override
    public boolean isDeletable() {
        return false;
    }

    protected void setGraphMinMax(AlignmentAnnotation ann, Annotation[] anns) {
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        boolean set = false;
        for (Annotation a : anns) {
            if (a == null) continue;
            set = true;
            float val = a.value;
            max = Math.max(max, val);
            min = Math.min(min, val);
        }
        if (set) {
            ann.graphMin = min;
            ann.graphMax = max;
        }
    }
}

