/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import java.awt.Color;

public class RNAInteractionColourScheme
extends ResidueColourScheme {
    @Override
    public Color findColour(char c) {
        return this.colors[ResidueProperties.nucleotideIndex[c]];
    }

    @Override
    public Color findColour(char c, int j, SequenceI seq) {
        Color currentColour = Color.white;
        try {
            currentColour = this.colors[ResidueProperties.nucleotideIndex[c]];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return currentColour;
    }

    @Override
    public boolean isNucleotideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return "RNA Interaction type";
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new RNAInteractionColourScheme();
    }
}

