/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.packed;

import jalview.analysis.SeqsetUtils;
import jalview.analysis.TreeModel;
import jalview.api.FeatureColourI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.io.NewickFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class JalviewDataset {
    AlignmentI parentDataset = null;
    List<AlignmentSet> al;
    Map<String, FeatureColourI> featureColours;
    Hashtable seqDetails = new Hashtable();
    public boolean relaxedIdMatching = false;

    public AlignmentI getParentDataset() {
        return this.parentDataset;
    }

    public void setParentDataset(AlignmentI parentDataset) {
        this.parentDataset = parentDataset;
    }

    public Map<String, FeatureColourI> getFeatureColours() {
        return this.featureColours;
    }

    public void setFeatureColours(Map<String, FeatureColourI> featureColours) {
        this.featureColours = featureColours;
    }

    public Hashtable getSeqDetails() {
        return this.seqDetails;
    }

    public void setSeqDetails(Hashtable seqDetails) {
        this.seqDetails = seqDetails;
    }

    public List<AlignmentSet> getAl() {
        return this.al == null ? new ArrayList() : this.al;
    }

    public JalviewDataset() {
        this.al = new ArrayList<AlignmentSet>();
        this.featureColours = new HashMap<String, FeatureColourI>();
    }

    public JalviewDataset(AlignmentI aldataset, Map<String, FeatureColourI> fc, Hashtable seqDets) {
        this(aldataset, fc, seqDets, null);
    }

    public JalviewDataset(AlignmentI aldataset, Map<String, FeatureColourI> fc, Hashtable seqDets, AlignmentI parentAlignment) {
        this();
        this.parentDataset = aldataset;
        if (parentAlignment != null) {
            this.parentDataset = parentAlignment.getDataset();
            if (this.parentDataset == null) {
                this.parentDataset = parentAlignment;
            } else {
                this.addAlignment(parentAlignment);
            }
        }
        if (seqDets != null) {
            this.seqDetails = seqDets;
        }
        if (fc != null) {
            this.featureColours = fc;
        }
    }

    public boolean hasAlignments() {
        return this.al != null && this.al.size() > 0;
    }

    public AlignmentI getLastAlignment() {
        return this.al == null || this.al.size() < 1 ? null : this.al.get((int)(this.al.size() - 1)).al;
    }

    public AlignmentSet getLastAlignmentSet() {
        return this.al == null || this.al.size() < 1 ? null : this.al.get(this.al.size() - 1);
    }

    public void addAlignment(AlignmentI newal) {
        AlignmentSet last;
        if (!this.hasAlignments()) {
            this.al = new ArrayList<AlignmentSet>();
        }
        if ((last = this.getLastAlignmentSet()) != null) {
            Console.errPrintln("Deuniquifying last alignment set.");
            last.deuniquifyAlignment();
        }
        this.al.add(new AlignmentSet(newal));
    }

    public void addTreeFromFile(NewickFile nf) {
        AlignmentSet lal = this.getLastAlignmentSet();
        lal.trees.add(nf);
    }

    public boolean hasSequenceAssoc() {
        return false;
    }

    public SequenceI getLastAssociatedSequence() {
        return null;
    }

    public void updateSetModified(boolean modified) {
        this.getLastAlignmentSet().updateSetModified(modified);
    }

    public class AlignmentSet {
        public AlignmentI al;
        public List<NewickFile> trees;
        private boolean modified = false;

        AlignmentSet(AlignmentI a) {
            this.al = a;
            this.trees = new ArrayList<NewickFile>();
        }

        void deuniquifyAlignment() {
            if (JalviewDataset.this.seqDetails == null || JalviewDataset.this.seqDetails.size() == 0) {
                return;
            }
            SeqsetUtils.deuniquify(JalviewDataset.this.seqDetails, this.al.getSequencesArray(), true);
            for (NewickFile nf : this.trees) {
                TreeModel njt = new TreeModel(this.al.getSequencesArray(), null, nf, null);
                njt.renameAssociatedNodes();
            }
        }

        public boolean isModified() {
            return this.modified;
        }

        public void updateSetModified(boolean modifiedFromAction) {
            this.modified |= modifiedFromAction;
        }
    }
}

