/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import com.stevesoft.pat.Regex;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ModellerDescription {
    final String[] seqTypes = new String[]{"sequence", "structure", "structureX", "structureN"};
    final String[] Fields = new String[]{"objectType", "objectId", "startField", "startCode", "endField", "endCode", "description1", "description2", "resolutionField", "tailField"};
    final int TYPE = 0;
    final int LOCALID = 1;
    final int START = 2;
    final int START_CHAIN = 3;
    final int END = 4;
    final int END_CHAIN = 5;
    final int DESCRIPTION1 = 6;
    final int DESCRIPTION2 = 7;
    final int RESOLUTION = 8;
    final int TAIL = 9;
    final int[] Types = new int[]{0, 0, 1, 0, 1, 0, 0, 0, 0, 0};
    final char[] Padding = new char[]{' ', ' ', ' ', '.', ' ', '.', '.', '.', '.', '.'};
    Hashtable fields = new Hashtable();

    ModellerDescription() {
        this.fields.put(this.Fields[9], "");
    }

    private resCode validResidueCode(String field) {
        Integer val = null;
        Regex r = new Regex("\\s*((([-0-9]+).?)|FIRST|LAST|@)");
        if (!r.search(field)) {
            return null;
        }
        String value = r.stringMatched(3);
        if (value == null) {
            value = r.stringMatched(1);
        }
        try {
            val = Integer.valueOf(value);
            return new resCode(field, val);
        }
        catch (Exception exception) {
            return new resCode(field, null);
        }
    }

    private Hashtable parseDescription(String desc) {
        Hashtable<String, Object> fields = new Hashtable<String, Object>();
        StringTokenizer st = new StringTokenizer(desc, ":", true);
        int type = -1;
        if (st.countTokens() > 0) {
            int i = 0;
            Object field = st.nextToken(":");
            while (!this.seqTypes[i].equalsIgnoreCase((String)field) && ++i < this.seqTypes.length) {
            }
            if (i < this.seqTypes.length) {
                st.nextToken();
                type = i;
                i = 1;
                while (i < 9 && st.hasMoreTokens()) {
                    field = st.nextToken(":");
                    if (field == null) continue;
                    if (!((String)field).equals(":")) {
                        if (this.Types[i] == 1) {
                            resCode val = this.validResidueCode((String)field);
                            if (val != null) {
                                fields.put(new String(this.Fields[i] + "num"), val);
                            } else {
                                type = -1;
                            }
                        }
                        fields.put(this.Fields[i++], field);
                        if (!st.hasMoreTokens()) continue;
                        st.nextToken();
                        continue;
                    }
                    ++i;
                }
                if (i == 9) {
                    while (st.hasMoreTokens()) {
                        String tl = st.nextToken(":");
                        field = (String)field + (String)(tl.equals(":") ? tl : ":" + tl);
                    }
                    fields.put(this.Fields[9], field);
                }
            }
        }
        if (type == -1) {
            fields = new Hashtable();
            fields.put(this.Fields[9], new String(desc));
        } else {
            fields.put(this.Fields[0], this.seqTypes[type]);
        }
        return fields;
    }

    ModellerDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.fields = this.parseDescription(desc);
    }

    void setStartCode(int v) {
        resCode r = new resCode(v);
        this.fields.put(this.Fields[2] + "num", r);
        this.fields.put(this.Fields[2], r.field);
    }

    void setEndCode(int v) {
        resCode r = new resCode(v);
        this.fields.put(this.Fields[4] + "num", r);
        this.fields.put(this.Fields[4], r.field);
    }

    ModellerDescription(SequenceI seq) {
        if (seq.getDescription() != null) {
            this.fields = this.parseDescription(seq.getDescription());
        }
        if (this.isModellerFieldset()) {
            if (this.getStartCode() == null || this.getStartNum() != seq.getStart() && this.getStartCode().val != null) {
                this.setStartCode(seq.getStart());
            }
            if (this.getEndCode() == null || this.getEndNum() != seq.getEnd() && this.getStartCode() != null && this.getStartCode().val != null) {
                this.setEndCode(seq.getEnd());
            }
        } else {
            this.setStartCode(seq.getStart());
            this.setEndCode(seq.getEnd());
            this.fields.put(this.Fields[1], seq.getName());
            int t = 0;
            if (seq.getDatasetSequence() != null && seq.getDatasetSequence().getDBRefs() != null) {
                Sequence.DBModList<DBRefEntry> dbr = seq.getDatasetSequence().getDBRefs();
                int ni = dbr.size();
                for (int i = 0; i < ni; ++i) {
                    DBRefEntry dbri = (DBRefEntry)dbr.get(i);
                    if (dbri == null || !dbri.getSource().equals("PDB")) continue;
                    this.fields.put(this.Fields[1], dbri.getAccessionId());
                    t = 2;
                    break;
                }
            }
            this.fields.put(this.Fields[0], this.seqTypes[t]);
        }
    }

    boolean isModellerFieldset() {
        return this.fields.containsKey(this.Fields[0]);
    }

    String getDescriptionLine() {
        int lastfield;
        Object desc = "";
        if (this.isModellerFieldset()) {
            for (lastfield = this.Fields.length - 1; lastfield > 6 && !this.fields.containsKey(this.Fields[lastfield]); --lastfield) {
            }
            for (int i = 0; i < lastfield; ++i) {
                String value = (String)this.fields.get(this.Fields[i]);
                desc = value != null && value.length() > 0 ? (String)desc + (String)this.fields.get(this.Fields[i]) + ":" : (String)desc + this.Padding[i] + ":";
            }
        }
        desc = this.fields.containsKey(this.Fields[lastfield]) ? (String)desc + (String)this.fields.get(this.Fields[lastfield]) : (String)desc + ".";
        return desc;
    }

    int getStartNum() {
        int start = 0;
        resCode val = this.getStartCode();
        if (val != null && val.val != null) {
            return val.val;
        }
        return start;
    }

    resCode getStartCode() {
        if (this.isModellerFieldset() && this.fields.containsKey(this.Fields[2] + "num")) {
            return (resCode)this.fields.get(this.Fields[2] + "num");
        }
        return null;
    }

    resCode getEndCode() {
        if (this.isModellerFieldset() && this.fields.containsKey(this.Fields[4] + "num")) {
            return (resCode)this.fields.get(this.Fields[4] + "num");
        }
        return null;
    }

    int getEndNum() {
        int end = 0;
        resCode val = this.getEndCode();
        if (val != null && val.val != null) {
            return val.val;
        }
        return end;
    }

    boolean updateSequenceI(SequenceI newSeq) {
        if (this.isModellerFieldset()) {
            resCode rc = this.getStartCode();
            if (rc != null && rc.val != null) {
                newSeq.setStart(this.getStartNum());
            } else {
                newSeq.setStart(1);
            }
            rc = this.getEndCode();
            if (rc != null && rc.val != null) {
                newSeq.setEnd(this.getEndNum());
            } else {
                newSeq.setEnd(newSeq.getStart() + newSeq.getLength());
            }
            return true;
        }
        return false;
    }

    class resCode {
        Integer val;
        String field;

        resCode(String f, Integer v) {
            this.val = v;
            this.field = f;
        }

        resCode(int v) {
            this.val = v;
            this.field = this.val.toString();
        }
    }
}

