/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.AlignViewportI;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.IProgressIndicatorHandler;
import jalview.gui.ImageExporter;
import jalview.gui.JalviewColourChooser;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.ProgressBar;
import jalview.gui.RotatableCanvas;
import jalview.io.exceptions.ImageOutputException;
import jalview.jbgui.GPCAPanel;
import jalview.math.RotatableMatrix;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.PCAModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class PCAPanel
extends GPCAPanel
implements Runnable,
IProgressIndicator {
    private static final int MIN_WIDTH = 470;
    private static final int MIN_HEIGHT = 250;
    private RotatableCanvas rc;
    AlignmentPanel ap;
    AlignmentViewport av;
    private PCAModel pcaModel;
    private int top = 0;
    private IProgressIndicator progressBar;
    private boolean working;
    String newPcaTitle = null;

    public PCAPanel(AlignmentPanel alignPanel, String modelName, SimilarityParamsI params) {
        this.setFrameIcon(null);
        this.av = alignPanel.av;
        this.ap = alignPanel;
        boolean nucleotide = this.av.getAlignment().isNucleotide();
        this.progressBar = new ProgressBar(this.statusPanel, this.statusBar);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                PCAPanel.this.close_actionPerformed();
            }
        });
        boolean selected = this.av.getSelectionGroup() != null && this.av.getSelectionGroup().getSize() > 0;
        AlignmentView seqstrings = this.av.getAlignmentView(selected);
        SequenceI[] seqs = !selected ? this.av.getAlignment().getSequencesArray() : this.av.getSelectionGroup().getSequencesInOrder(this.av.getAlignment());
        ScoreModelI scoreModel = ScoreModels.getInstance().getScoreModel(modelName, this.ap);
        this.setPcaModel(new PCAModel(seqstrings, seqs, nucleotide, scoreModel, params));
        this.newPcaTitle = alignPanel.alignFrame.formCalculationTitle(MessageManager.formatMessage("label.calc_title", "PCA", this.getPcaModel().getScoreModelName()), selected, this.ap.alignFrame.getTitle());
        PaintRefresher.Register(this, this.av.getSequenceSetId());
        this.setRotatableCanvas(new RotatableCanvas(alignPanel));
        if (params.getSecondaryStructureSource() != null) {
            JLabel subtitleLabel = new JLabel(" Secondary Structure Provider : " + params.getSecondaryStructureSource(), 2);
            this.getContentPane().add((Component)subtitleLabel, "North");
        }
        this.getContentPane().add((Component)this.getRotatableCanvas(), "Center");
        this.addKeyListener(this.getRotatableCanvas());
        this.validate();
    }

    protected void close_actionPerformed() {
        this.setPcaModel(null);
        if (this.rc != null) {
            this.rc.sequencePoints = null;
            this.rc.setAxisEndPoints(null);
            this.rc = null;
        }
    }

    @Override
    protected void bgcolour_actionPerformed() {
        String ttl = MessageManager.getString("label.select_background_colour");
        JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

            @Override
            public void colourSelected(Color c) {
                PCAPanel.this.rc.setBgColour(c);
                PCAPanel.this.rc.repaint();
            }
        };
        JalviewColourChooser.showColourChooser(this, ttl, this.rc.getBgColour(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.working = true;
        long progId = System.currentTimeMillis();
        JInternalFrame progress = this;
        String message = MessageManager.getString("label.pca_recalculating");
        if (this.getParent() == null) {
            progress = this.ap.alignFrame;
            message = MessageManager.getString("label.pca_calculating");
        }
        progress.setProgressBar(message, progId);
        try {
            this.getPcaModel().calculate();
            this.xCombobox.setSelectedIndex(0);
            this.yCombobox.setSelectedIndex(1);
            this.zCombobox.setSelectedIndex(2);
            this.getPcaModel().updateRc(this.getRotatableCanvas());
            this.setTop(this.getPcaModel().getTop());
        }
        catch (OutOfMemoryError er) {
            new OOMWarning("calculating PCA", er);
            this.working = false;
            return;
        }
        finally {
            progress.setProgressBar("", progId);
        }
        this.repaint();
        if (this.getParent() == null) {
            Desktop.addInternalFrame(this, this.newPcaTitle, 475, 450);
            this.setMinimumSize(new Dimension(470, 250));
        }
        this.working = false;
    }

    @Override
    protected void doDimensionChange() {
        if (this.getTop() == 0) {
            return;
        }
        int dim1 = this.getTop() - this.xCombobox.getSelectedIndex();
        int dim2 = this.getTop() - this.yCombobox.getSelectedIndex();
        int dim3 = this.getTop() - this.zCombobox.getSelectedIndex();
        this.getPcaModel().updateRcView(dim1, dim2, dim3);
        this.getRotatableCanvas().resetView();
    }

    public void setSelectedDimensionIndex(int index, RotatableMatrix.Axis axis) {
        switch (axis) {
            case X: {
                this.xCombobox.setSelectedIndex(index);
                break;
            }
            case Y: {
                this.yCombobox.setSelectedIndex(index);
                break;
            }
            case Z: {
                this.zCombobox.setSelectedIndex(index);
                break;
            }
        }
    }

    @Override
    protected void outputValues_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPcaModel().getDetails());
            Desktop.addInternalFrame(cap, MessageManager.getString("label.pca_details"), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("opening PCA details", oom);
            cap.dispose();
        }
    }

    @Override
    protected void showLabels_actionPerformed() {
        this.getRotatableCanvas().showLabels(this.showLabels.getState());
    }

    @Override
    protected void print_actionPerformed() {
        PCAPrinter printer = new PCAPrinter();
        printer.start();
    }

    @Override
    public void originalSeqData_actionPerformed() {
        if (this.getPcaModel().getInputData() == null) {
            Console.info("Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] alAndColsel = this.getPcaModel().getInputData().getAlignmentAndHiddenColumns(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            AlignmentI dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignmentI alignmentI = dataset = this.av != null && this.av.getAlignment() != null ? this.av.getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame((AlignmentI)al, (HiddenColumns)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, MessageManager.formatMessage("label.original_data_for_params", new String[]{this.title}), 700, 500);
        }
    }

    @Override
    public void makePCAImage(ImageMaker.TYPE type) {
        int width = this.getRotatableCanvas().getWidth();
        int height = this.getRotatableCanvas().getHeight();
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                RotatableCanvas canvas = PCAPanel.this.getRotatableCanvas();
                canvas.drawBackground(g);
                canvas.drawScene(g);
                if (canvas.drawAxes) {
                    canvas.drawAxes(g);
                }
            }
        };
        String pca = MessageManager.getString("label.pca");
        ImageExporter exporter = new ImageExporter(writer, null, type, pca);
        try {
            exporter.doExport(null, this, width, height, pca);
        }
        catch (ImageOutputException ioex) {
            Console.error("Unexpected error whilst writing " + type.toString(), ioex);
        }
    }

    @Override
    protected void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        if (aps.length == 1 && this.getRotatableCanvas().av == aps[0].av) {
            this.associateViewsMenu.setVisible(false);
            return;
        }
        this.associateViewsMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateViewsMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final AlignmentPanel panel : aps) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(panel.av.getViewName(), panel.av == this.getRotatableCanvas().av);
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PCAPanel.this.selectAssociatedView(panel);
                }
            });
            this.associateViewsMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem("All Views");
        buttonGroup.add(itemf);
        itemf.setSelected(this.getRotatableCanvas().isApplyToAllViews());
        itemf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PCAPanel.this.getRotatableCanvas().setApplyToAllViews(itemf.isSelected());
            }
        });
        this.associateViewsMenu.add(itemf);
    }

    @Override
    protected void outputPoints_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPcaModel().getPointsasCsv(false, this.xCombobox.getSelectedIndex(), this.yCombobox.getSelectedIndex(), this.zCombobox.getSelectedIndex()));
            Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.points_for_params", new String[]{this.getTitle()}), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("exporting PCA points", oom);
            cap.dispose();
        }
    }

    @Override
    protected void outputProjPoints_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.setText(this.getPcaModel().getPointsasCsv(true, this.xCombobox.getSelectedIndex(), this.yCombobox.getSelectedIndex(), this.zCombobox.getSelectedIndex()));
            Desktop.addInternalFrame(cap, MessageManager.formatMessage("label.transformed_points_for_params", new String[]{this.getTitle()}), 500, 500);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("exporting transformed PCA points", oom);
            cap.dispose();
        }
    }

    @Override
    public void setProgressBar(String message, long id) {
        this.progressBar.setProgressBar(message, id);
    }

    @Override
    public void registerHandler(long id, IProgressIndicatorHandler handler) {
        this.progressBar.registerHandler(id, handler);
    }

    @Override
    public boolean operationInProgress() {
        return this.progressBar.operationInProgress();
    }

    @Override
    protected void resetButton_actionPerformed() {
        int t = this.getTop();
        this.setTop(0);
        this.xCombobox.setSelectedIndex(0);
        this.yCombobox.setSelectedIndex(1);
        this.setTop(t);
        this.zCombobox.setSelectedIndex(2);
    }

    public boolean isWorking() {
        return this.working;
    }

    public int getSelectedDimensionIndex(RotatableMatrix.Axis axis) {
        switch (axis) {
            case X: {
                return this.xCombobox.getSelectedIndex();
            }
            case Y: {
                return this.yCombobox.getSelectedIndex();
            }
        }
        return this.zCombobox.getSelectedIndex();
    }

    public void setShowLabels(boolean show) {
        this.showLabels.setSelected(show);
    }

    public void setInputData(AlignmentView data) {
        this.getPcaModel().setInputData(data);
        this.originalSeqData.setVisible(data != null);
    }

    public AlignViewportI getAlignViewport() {
        return this.av;
    }

    public PCAModel getPcaModel() {
        return this.pcaModel;
    }

    public void setPcaModel(PCAModel pcaModel) {
        this.pcaModel = pcaModel;
    }

    public RotatableCanvas getRotatableCanvas() {
        return this.rc;
    }

    public void setRotatableCanvas(RotatableCanvas rc) {
        this.rc = rc;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void selectAssociatedView(AlignmentPanel panel) {
        this.getRotatableCanvas().setApplyToAllViews(false);
        this.ap = panel;
        this.av = panel.av;
        this.getRotatableCanvas().av = panel.av;
        this.getRotatableCanvas().ap = panel;
        PaintRefresher.Register(this, panel.av.getSequenceSetId());
    }

    @Override
    public JProgressBar getProgressBar(long id) {
        return this.progressBar.getProgressBar(id);
    }

    @Override
    public String getMessage(long id) {
        return this.progressBar.getMessage(id);
    }

    @Override
    public void setProgressBarMessage(long id, String message) {
        this.progressBar.setProgressBarMessage(id, message);
    }

    class PCAPrinter
    extends Thread
    implements Printable {
        PCAPrinter() {
        }

        @Override
        public void run() {
            PageFormat pf;
            PrinterJob printJob = PrinterJob.getPrinterJob();
            PageFormat defaultPage = printJob.defaultPage();
            if (defaultPage == (pf = printJob.pageDialog(defaultPage))) {
                return;
            }
            printJob.setPrintable(this, pf);
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (Exception PrintException) {
                    PrintException.printStackTrace();
                }
            }
        }

        @Override
        public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
            pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
            PCAPanel.this.getRotatableCanvas().drawBackground(pg);
            PCAPanel.this.getRotatableCanvas().drawScene(pg);
            if (PCAPanel.this.getRotatableCanvas().drawAxes) {
                PCAPanel.this.getRotatableCanvas().drawAxes(pg);
            }
            if (pi == 0) {
                return 0;
            }
            return 1;
        }
    }
}

