/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.ComboBoxTooltipRenderer;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.TitledBorder;

public final class JvSwingUtils {
    public static String wrapTooltip(boolean enclose, String ttext) {
        Objects.requireNonNull(ttext, "Tootip text to format must not be null!");
        ttext = ttext.trim();
        boolean maxLengthExceeded = false;
        if (ttext.contains("<br>")) {
            String[] htmllines;
            for (String line : htmllines = ttext.split("<br>")) {
                boolean bl = maxLengthExceeded = line.length() > 60;
                if (!maxLengthExceeded) {
                    continue;
                }
                break;
            }
        } else {
            boolean bl = maxLengthExceeded = ttext.length() > 60;
        }
        if (!maxLengthExceeded) {
            return enclose ? "<html>" + ttext + "</html>" : ttext;
        }
        return (enclose ? "<html>" : "") + "<style> div.ttip {width:350px;white-space:pre-wrap;padding:2px;overflow-wrap:break-word;}</style><div class=\"ttip\">" + ttext + " </div>" + (enclose ? "</html>" : "");
    }

    public static JButton makeButton(String label, String tooltip, ActionListener action) {
        JButton button = new JButton();
        button.setText(label);
        button.setFont(new Font("Verdana", 0, 10));
        button.setForeground(Color.black);
        button.setHorizontalAlignment(0);
        button.setToolTipText(tooltip);
        button.addActionListener(action);
        return button;
    }

    public static JMenu findOrCreateMenu(JMenu menu, String submenu) {
        JMenu submenuinstance = null;
        int iSize = menu.getMenuComponentCount();
        for (int i = 0; i < iSize; ++i) {
            if (!(menu.getMenuComponent(i) instanceof JMenu) || !((JMenu)menu.getMenuComponent(i)).getText().equals(submenu)) continue;
            submenuinstance = (JMenu)menu.getMenuComponent(i);
        }
        if (submenuinstance == null) {
            submenuinstance = new JMenu(submenu);
            menu.add(submenuinstance);
        }
        return submenuinstance;
    }

    public static JPanel addtoLayout(JPanel panel, String tooltip, JComponent label, JComponent valBox) {
        JPanel laypanel = new JPanel(new GridLayout(1, 2));
        JPanel labPanel = new JPanel(new BorderLayout());
        JPanel valPanel = new JPanel();
        labPanel.setBounds(new Rectangle(7, 7, 158, 23));
        valPanel.setBounds(new Rectangle(172, 7, 270, 23));
        labPanel.add((Component)label, "West");
        valPanel.add(valBox);
        laypanel.add(labPanel);
        laypanel.add(valPanel);
        valPanel.setToolTipText(tooltip);
        labPanel.setToolTipText(tooltip);
        valBox.setToolTipText(tooltip);
        panel.add(laypanel);
        panel.validate();
        return laypanel;
    }

    public static void mgAddtoLayout(JPanel cpanel, String tooltip, JLabel jLabel, JComponent name) {
        JvSwingUtils.mgAddtoLayout(cpanel, tooltip, jLabel, name, null);
    }

    public static void mgAddtoLayout(JPanel cpanel, String tooltip, JLabel jLabel, JComponent name, String params) {
        cpanel.add(jLabel);
        if (params == null) {
            cpanel.add(name);
        } else {
            cpanel.add((Component)name, params);
        }
        name.setToolTipText(tooltip);
        jLabel.setToolTipText(tooltip);
    }

    public static Font getLabelFont() {
        return JvSwingUtils.getLabelFont(false, false);
    }

    public static Font getLabelFont(boolean bold, boolean italic) {
        return new Font("Verdana", !bold && !italic ? 0 : (bold ? 1 : 0) + (italic ? 2 : 0), 11);
    }

    public static Font getTextAreaFont() {
        return JvSwingUtils.getLabelFont(false, false);
    }

    public static void cleanMenu(JMenu webService) {
        int i = 0;
        while (i < webService.getItemCount()) {
            JMenuItem item = webService.getItem(i);
            if (item instanceof JMenu && ((JMenu)item).getItemCount() == 0) {
                webService.remove(i);
                continue;
            }
            ++i;
        }
    }

    public static float getScrollBarProportion(JScrollBar scroll) {
        int possibleRange = scroll.getMaximum() - scroll.getMinimum() - scroll.getModel().getExtent();
        float valueInRange = (float)scroll.getValue() - (float)scroll.getModel().getExtent() / 2.0f;
        float proportion = valueInRange / (float)possibleRange;
        return proportion;
    }

    public static int getScrollValueForProportion(JScrollBar scrollbar, float proportion) {
        float fraction = proportion * (float)(scrollbar.getMaximum() - scrollbar.getMinimum() - scrollbar.getModel().getExtent()) + (float)scrollbar.getModel().getExtent() / 2.0f;
        return Math.min(Math.round(fraction), scrollbar.getMaximum());
    }

    public static void jvInitComponent(AbstractButton comp, String i18nString) {
        JvSwingUtils.setColorAndFont(comp);
        if (i18nString != null && !i18nString.isEmpty()) {
            comp.setText(MessageManager.getString(i18nString));
        }
    }

    public static void jvInitComponent(JComponent comp) {
        JvSwingUtils.setColorAndFont(comp);
    }

    private static void setColorAndFont(JComponent comp) {
        comp.setBackground(Color.white);
        comp.setFont(JvSwingUtils.getLabelFont());
    }

    public static JComboBox<Object> buildComboWithTooltips(List<Object> entries, final List<String> tooltips) {
        final JComboBox<Object> combo = new JComboBox<Object>();
        ComboBoxTooltipRenderer renderer = new ComboBoxTooltipRenderer();
        combo.setRenderer(renderer);
        for (Object attName : entries) {
            combo.addItem(attName);
        }
        renderer.setTooltips(tooltips);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                int j = combo.getSelectedIndex();
                if (j > -1) {
                    combo.setToolTipText((String)tooltips.get(j));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                combo.setToolTipText(null);
            }
        };
        for (Component c : combo.getComponents()) {
            c.addMouseListener(mouseListener);
        }
        return combo;
    }

    public static TitledBorder createTitledBorder(JComponent comp, String title, boolean italic) {
        Font font = comp.getFont();
        if (italic) {
            font = new Font(font.getName(), 2, font.getSize());
        }
        TitledBorder border = BorderFactory.createTitledBorder("");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, title, 4, 0, font);
        comp.setBorder(titledBorder);
        return titledBorder;
    }
}

