/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AnnotationSorter;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AnnotationLabels;
import jalview.gui.AnnotationPanel;
import jalview.gui.CalculationChooser;
import jalview.gui.FeatureRenderer;
import jalview.gui.IdCanvas;
import jalview.gui.IdPanel;
import jalview.gui.IdwidthAdjuster;
import jalview.gui.ImageExporter;
import jalview.gui.OOMWarning;
import jalview.gui.OverviewPanel;
import jalview.gui.PaintRefresher;
import jalview.gui.ScalePanel;
import jalview.gui.SeqCanvas;
import jalview.gui.SeqPanel;
import jalview.gui.SplitFrame;
import jalview.io.HTMLOutput;
import jalview.io.exceptions.ImageOutputException;
import jalview.jbgui.GAlignmentPanel;
import jalview.math.AlignmentDimension;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.imagemaker.BitmapImageSizing;
import jalview.viewmodel.ViewportListenerI;
import jalview.viewmodel.ViewportRanges;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.SwingUtilities;

public class AlignmentPanel
extends GAlignmentPanel
implements AdjustmentListener,
Printable,
AlignmentViewPanel,
ViewportListenerI {
    private static final int ID_WIDTH_PADDING = 4;
    public AlignViewport av;
    OverviewPanel overviewPanel;
    private SeqPanel seqPanel;
    private IdPanel idPanel;
    IdwidthAdjuster idwidthAdjuster;
    public AlignFrame alignFrame;
    private ScalePanel scalePanel;
    private AnnotationPanel annotationPanel;
    private AnnotationLabels alabels;
    private int hextent = 0;
    private int vextent = 0;
    private boolean scrollComplementaryPanel = true;
    private PropertyChangeListener propertyChangeListener;
    private CalculationChooser calculationDialog;

    public AlignmentPanel(AlignFrame af, final AlignViewport av) {
        this.alignFrame = af;
        this.av = av;
        this.setSeqPanel(new SeqPanel(av, this));
        this.setIdPanel(new IdPanel(av, this));
        this.setScalePanel(new ScalePanel(av, this));
        this.idPanelHolder.add((Component)this.getIdPanel(), "Center");
        this.idwidthAdjuster = new IdwidthAdjuster(this);
        this.idSpaceFillerPanel1.add((Component)this.idwidthAdjuster, "Center");
        this.setAnnotationPanel(new AnnotationPanel(this));
        this.setAlabels(new AnnotationLabels(this));
        this.annotationScroller.setViewportView(this.getAnnotationPanel());
        this.annotationSpaceFillerHolder.add((Component)this.getAlabels(), "Center");
        this.scalePanelHolder.add((Component)this.getScalePanel(), "Center");
        this.seqPanelHolder.add((Component)this.getSeqPanel(), "Center");
        this.setScrollValues(0, 0);
        this.hscroll.addAdjustmentListener(this);
        this.vscroll.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ViewportRanges ranges = av.getRanges();
                if (av.getWrapAlignment()) {
                    int widthInRes = AlignmentPanel.this.getSeqPanel().seqCanvas.getWrappedCanvasWidth(AlignmentPanel.this.getSeqPanel().seqCanvas.getWidth());
                    ranges.setViewportWidth(widthInRes);
                } else {
                    int widthInRes = AlignmentPanel.this.getSeqPanel().seqCanvas.getWidth() / av.getCharWidth();
                    int heightInSeq = AlignmentPanel.this.getSeqPanel().seqCanvas.getHeight() / av.getCharHeight();
                    ranges.setViewportWidth(widthInRes);
                    ranges.setViewportHeight(heightInSeq);
                }
            }
        });
        final AlignmentPanel ap = this;
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    PaintRefresher.Refresh(ap, av.getSequenceSetId(), true, true);
                    AlignmentPanel.this.alignmentChanged();
                }
            }
        };
        av.addPropertyChangeListener(this.propertyChangeListener);
        av.getRanges().addPropertyChangeListener(this);
        this.fontChanged();
        this.adjustAnnotationHeight();
        this.updateLayout();
    }

    @Override
    public AlignViewportI getAlignViewport() {
        return this.av;
    }

    public void alignmentChanged() {
        this.av.alignmentChanged(this);
        if (this.getCalculationDialog() != null) {
            this.getCalculationDialog().validateCalcTypes();
        }
        this.alignFrame.updateEditMenuBar();
        this.paintAlignment(true, true);
    }

    public void fontChanged() {
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.av.validCharWidth = fm.charWidth('M') <= this.av.getCharWidth();
        this.scalePanelHolder.setPreferredSize(new Dimension(10, this.av.getCharHeight() + fm.getDescent()));
        this.idSpaceFillerPanel1.setPreferredSize(new Dimension(10, this.av.getCharHeight() + fm.getDescent()));
        this.idwidthAdjuster.invalidate();
        this.scalePanelHolder.invalidate();
        this.getSeqPanel().seqCanvas.img = null;
        this.getAnnotationPanel().adjustPanelHeight();
        Dimension d = this.calculateIdWidth();
        this.getIdPanel().getIdCanvas().setPreferredSize(d);
        this.hscrollFillerPanel.setPreferredSize(d);
        this.repaint();
    }

    public Dimension calculateIdWidth() {
        int oldWidth = this.av.getIdWidth();
        Dimension r = null;
        if (this.av.getIdWidth() < 0) {
            r = this.calculateDefaultAlignmentIdWidth();
            this.av.setIdWidth(r.width);
        } else {
            r = new Dimension();
            r.width = this.av.getIdWidth();
            r.height = 0;
        }
        if (r.width != oldWidth) {
            this.idPanelHolder.setPreferredSize(r);
            this.validate();
        }
        return r;
    }

    public Dimension calculateDefaultAlignmentIdWidth() {
        return this.calculateIdWidth(-1, false, false);
    }

    public int getLegacyIdWidth() {
        int afwidth = this.alignFrame != null ? this.alignFrame.getWidth() : 300;
        int idWidth = Math.min(afwidth - 200, 2 * afwidth / 3);
        int maxwidth = Math.max(20, idWidth);
        Dimension w = this.calculateIdWidthOrLegacy(true, maxwidth, false, false);
        return w.width;
    }

    protected Dimension calculateIdWidth(int maxwidth) {
        return this.calculateIdWidth(maxwidth, true, false);
    }

    public Dimension calculateIdWidth(int maxwidth, boolean includeAnnotations, boolean visibleOnly) {
        return this.calculateIdWidthOrLegacy(false, maxwidth, includeAnnotations, visibleOnly);
    }

    private Dimension calculateIdWidthOrLegacy(boolean legacy, int maxwidth, boolean includeAnnotations, boolean visibleOnly) {
        int stringWidth;
        int i;
        Container c = new Container();
        FontMetrics fm = c.getFontMetrics(new Font(this.av.font.getName(), 2, this.av.font.getSize()));
        AlignmentI al = this.av.getAlignment();
        int idWidth = 0;
        for (i = 0; i < al.getHeight() && al.getSequenceAt(i) != null; ++i) {
            SequenceI s = al.getSequenceAt(i);
            String id = s.getDisplayId(this.av.getShowJVSuffix());
            stringWidth = fm.stringWidth(id);
            idWidth = Math.max(idWidth, stringWidth);
        }
        if (includeAnnotations && al.getAlignmentAnnotation() != null) {
            if (legacy) {
                fm = c.getFontMetrics(this.getAlabels().getFont());
            }
            if (!legacy || Jalview.isHeadlessMode()) {
                AnnotationLabels aal = this.getAlabels();
                int stringWidth2 = aal.drawLabels(null, false, idWidth, false, false, fm, !visibleOnly);
                idWidth = Math.max(idWidth, stringWidth2);
            } else {
                for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                    AlignmentAnnotation aa = al.getAlignmentAnnotation()[i];
                    if (visibleOnly && !aa.isForDisplay()) continue;
                    String label = aa.label;
                    stringWidth = fm.stringWidth(label);
                    idWidth = Math.max(idWidth, stringWidth);
                }
            }
        }
        int w = maxwidth < 0 ? idWidth : Math.min(maxwidth, idWidth);
        return new Dimension(w += 4, 12);
    }

    public void highlightSearchResults(SearchResultsI results) {
        boolean scrolled = this.scrollToPosition(results, 0, false);
        boolean fastPaint = !scrolled || !this.av.getWrapAlignment();
        this.getSeqPanel().seqCanvas.highlightSearchResults(results, fastPaint);
    }

    public boolean scrollToPosition(SearchResultsI searchResults) {
        return this.scrollToPosition(searchResults, 0, false);
    }

    protected boolean scrollToPosition(SearchResultsI results, int verticalOffset, boolean centre) {
        HiddenColumns hidden;
        ViewportRanges ranges = this.av.getRanges();
        if (results == null || results.isEmpty() || this.av == null || this.av.getAlignment() == null) {
            return false;
        }
        int seqIndex = this.av.getAlignment().findIndex(results);
        if (seqIndex == -1) {
            return false;
        }
        SequenceI seq = this.av.getAlignment().getSequenceAt(seqIndex);
        int[] r = results.getResults(seq, 0, this.av.getAlignment().getWidth());
        if (r == null) {
            return false;
        }
        int start = r[0];
        int end = r[1];
        if (centre) {
            int offset = (ranges.getEndRes() - ranges.getStartRes() + 1) / 2 - 1;
            start = Math.max(start - offset, 0);
            end = end + offset - 1;
        }
        if (start < 0) {
            return false;
        }
        if (end == seq.getEnd()) {
            return false;
        }
        if (this.av.hasHiddenColumns() && (start = (hidden = this.av.getAlignment().getHiddenColumns()).absoluteToVisibleColumn(start)) == (end = hidden.absoluteToVisibleColumn(end)) && !hidden.isVisible(r[0])) {
            return false;
        }
        seqIndex = Math.max(0, seqIndex - verticalOffset);
        boolean scrollNeeded = true;
        if (!this.av.getWrapAlignment()) {
            int startv = ranges.getStartRes();
            if (startv >= start) {
                this.setScrollValues(start, seqIndex);
            } else {
                int endv = ranges.getEndRes();
                if (endv <= end) {
                    this.setScrollValues(startv + end - endv, seqIndex);
                } else {
                    int starts = ranges.getStartSeq();
                    if (starts > seqIndex) {
                        this.setScrollValues(ranges.getStartRes(), seqIndex);
                    } else {
                        int ends = ranges.getEndSeq();
                        if (ends <= seqIndex) {
                            this.setScrollValues(ranges.getStartRes(), starts + seqIndex - ends + 1);
                        }
                    }
                }
            }
            scrollNeeded = false;
        } else {
            scrollNeeded = ranges.scrollToWrappedVisible(start);
        }
        this.paintAlignment(false, false);
        return scrollNeeded;
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    public void setOverviewPanel(OverviewPanel op) {
        this.overviewPanel = op;
    }

    public void setAnnotationVisible(boolean b) {
        if (!this.av.getWrapAlignment()) {
            this.annotationSpaceFillerHolder.setVisible(b);
            this.annotationScroller.setVisible(b);
        }
        this.repaint();
    }

    @Override
    public void adjustAnnotationHeight() {
        if (this.alignFrame.getHeight() == 0) {
            Console.error("adjustAnnotationHeight called with zero height alignment window");
        }
        this.validateAnnotationDimensions(true);
        this.addNotify();
        this.paintAlignment(true, this.av.needToUpdateStructureViews());
    }

    protected void validateAnnotationDimensions(boolean adjustPanelHeight) {
        AnnotationPanel ap = this.getAnnotationPanel();
        int annotationHeight = ap.adjustPanelHeight();
        annotationHeight = ap.adjustForAlignFrame(adjustPanelHeight, annotationHeight);
        this.hscroll.addNotify();
        Dimension e = this.idPanel.getSize();
        int idWidth = e.width;
        boolean manuallyAdjusted = this.getIdPanel().getIdCanvas().isManuallyAdjusted();
        this.annotationScroller.setPreferredSize(new Dimension(manuallyAdjusted ? idWidth : this.annotationScroller.getWidth(), annotationHeight));
        this.alabels.setPreferredSize(new Dimension(idWidth, annotationHeight));
        this.annotationSpaceFillerHolder.setPreferredSize(new Dimension(manuallyAdjusted ? idWidth : this.annotationSpaceFillerHolder.getWidth(), annotationHeight));
        this.annotationScroller.validate();
        this.annotationScroller.addNotify();
        ap.validate();
    }

    public void updateLayout() {
        this.fontChanged();
        this.setAnnotationVisible(this.av.isShowAnnotation());
        boolean wrap = this.av.getWrapAlignment();
        ViewportRanges ranges = this.av.getRanges();
        ranges.setStartSeq(0);
        this.hscroll.setVisible(!wrap);
        this.idwidthAdjuster.setVisible(true);
        if (wrap) {
            this.annotationScroller.setVisible(false);
            this.annotationSpaceFillerHolder.setVisible(false);
        } else if (this.av.isShowAnnotation()) {
            this.annotationScroller.setVisible(true);
            this.annotationSpaceFillerHolder.setVisible(true);
            this.validateAnnotationDimensions(false);
        }
        int canvasWidth = this.getSeqPanel().seqCanvas.getWidth();
        if (canvasWidth > 0) {
            if (wrap) {
                int widthInRes = this.getSeqPanel().seqCanvas.getWrappedCanvasWidth(canvasWidth);
                ranges.setViewportWidth(widthInRes);
            } else {
                int widthInRes = canvasWidth / this.av.getCharWidth();
                int heightInSeq = this.getSeqPanel().seqCanvas.getHeight() / this.av.getCharHeight();
                ranges.setViewportWidth(widthInRes);
                ranges.setViewportHeight(heightInSeq);
            }
        }
        this.repaint();
    }

    public void setScrollValues(int xpos, int ypos) {
        int x = xpos;
        int y = ypos;
        if (this.av == null || this.av.getAlignment() == null) {
            return;
        }
        if (this.av.getWrapAlignment()) {
            this.setScrollingForWrappedPanel(x);
        } else {
            int width = this.av.getAlignment().getVisibleWidth();
            int height = this.av.getAlignment().getHeight();
            this.hextent = this.getSeqPanel().seqCanvas.getWidth() / this.av.getCharWidth();
            this.vextent = this.getSeqPanel().seqCanvas.getHeight() / this.av.getCharHeight();
            if (this.hextent > width) {
                this.hextent = width;
            }
            if (this.vextent > height) {
                this.vextent = height;
            }
            if (this.hextent + x > width) {
                x = width - this.hextent;
            }
            if (this.vextent + y > height) {
                y = height - this.vextent;
            }
            if (y < 0) {
                y = 0;
            }
            if (x < 0) {
                x = 0;
            }
            this.hscroll.setValues(x, this.hextent, 0, width);
            this.vscroll.setValues(y, this.vextent, 0, height);
        }
    }

    boolean isScrolledFullyRight() {
        if (this.hscroll == null) {
            return true;
        }
        BoundedRangeModel model = this.hscroll.getModel();
        return model.getExtent() + model.getValue() >= model.getMaximum();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (this.av.getWrapAlignment()) {
            this.adjustScrollingWrapped(evt);
            return;
        }
        ViewportRanges ranges = this.av.getRanges();
        if (evt.getSource() == this.hscroll) {
            int oldX = ranges.getStartRes();
            int oldwidth = ranges.getViewportWidth();
            int x = this.hscroll.getValue();
            int width = this.getSeqPanel().seqCanvas.getWidth() / this.av.getCharWidth();
            if (x == oldX && width == oldwidth) {
                return;
            }
            ranges.setViewportStartAndWidth(x, width);
        } else if (evt.getSource() == this.vscroll) {
            int oldY = ranges.getStartSeq();
            int oldheight = ranges.getViewportHeight();
            int y = this.vscroll.getValue();
            int height = this.getSeqPanel().seqCanvas.getHeight() / this.av.getCharHeight();
            if (y == oldY && height == oldheight) {
                return;
            }
            ranges.setViewportStartAndHeight(y, height);
        }
        this.repaint();
    }

    protected void adjustScrollingWrapped(AdjustmentEvent evt) {
        if (evt.getSource() == this.hscroll) {
            return;
        }
        final ViewportRanges ranges = this.av.getRanges();
        if (evt.getSource() == this.vscroll) {
            int newY = this.vscroll.getValue();
            int oldX = ranges.getStartRes();
            int oldY = ranges.getWrappedScrollPosition(oldX);
            if (oldY == newY) {
                return;
            }
            if (newY > -1) {
                int rowSize = ranges.getViewportWidth();
                int newX = newY > oldY ? oldX + rowSize : oldX - rowSize;
                ranges.setViewportStartAndWidth(Math.max(0, newX), rowSize);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Console.warn("Unexpected path through code: Wrapped jar file opened with wrap alignment set in preferences");
                    ranges.setStartRes(0);
                    ranges.setStartSeq(0);
                }
            });
        }
        this.repaint();
    }

    @Override
    public void paintAlignment(boolean updateOverview, boolean updateStructures) {
        AnnotationSorter sorter = new AnnotationSorter(this.getAlignment(), this.av.isShowAutocalculatedAbove());
        sorter.sort(this.getAlignment().getAlignmentAnnotation(), this.av.getSortAnnotationsBy());
        this.repaint();
        if (updateStructures) {
            this.av.getStructureSelectionManager().sequenceColoursChanged(this);
        }
        if (updateOverview && this.overviewPanel != null) {
            this.overviewPanel.updateOverviewImage();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        SeqCanvas sc;
        this.invalidate();
        Dimension d = this.getIdPanel().getIdCanvas().getPreferredSize();
        int idWidth = d.width;
        if (this.av.getWrapAlignment() && (sc = this.getSeqPanel().seqCanvas) != null && sc.getWidth() < sc.getMinimumWrappedCanvasWidth()) {
            this.av.setIdWidth(idWidth -= sc.getMinimumWrappedCanvasWidth() - sc.getWidth());
            this.av.getAlignPanel().getIdPanel().getIdCanvas().setManuallyAdjusted(true);
            this.validateAnnotationDimensions(false);
        }
        this.idPanelHolder.setPreferredSize(new Dimension(idWidth, d.height));
        this.hscrollFillerPanel.setPreferredSize(new Dimension(idWidth, 12));
        this.validate();
        ViewportRanges ranges = this.av.getRanges();
        this.setScrollValues(ranges.getStartRes(), ranges.getStartSeq());
        super.paintComponent(g);
    }

    private void setScrollingForWrappedPanel(int topLeftColumn) {
        ViewportRanges ranges = this.av.getRanges();
        int scrollPosition = ranges.getWrappedScrollPosition(topLeftColumn);
        int maxScroll = ranges.getWrappedMaxScroll(topLeftColumn);
        this.vscroll.setUnitIncrement(1);
        this.vscroll.setValues(scrollPosition, 1, 0, maxScroll + 1);
    }

    @Override
    public int print(Graphics pg, PageFormat pf, int pi) throws PrinterException {
        pg.translate((int)pf.getImageableX(), (int)pf.getImageableY());
        int pwidth = (int)pf.getImageableWidth();
        int pheight = (int)pf.getImageableHeight();
        if (this.av.getWrapAlignment()) {
            return this.printWrappedAlignment(pwidth, pheight, pi, pg);
        }
        return this.printUnwrapped(pwidth, pheight, pi, pg, pg);
    }

    public int printUnwrapped(int pageWidth, int pageHeight, int pageIndex, Graphics idGraphics, Graphics alignmentGraphics) throws PrinterException {
        int idWidth = this.getVisibleIdWidth(false);
        int alignmentGraphicsOffset = idGraphics != alignmentGraphics ? 0 : idWidth;
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        int charHeight = this.av.getCharHeight();
        int scaleHeight = charHeight + fm.getDescent();
        idGraphics.setColor(Color.white);
        idGraphics.fillRect(0, 0, pageWidth, pageHeight);
        idGraphics.setFont(this.av.getFont());
        int totalRes = (pageWidth - idWidth) / this.av.getCharWidth();
        int totalSeq = (pageHeight - scaleHeight) / charHeight - 1;
        int alignmentWidth = this.av.getAlignment().getVisibleWidth();
        int pagesWide = alignmentWidth / totalRes + 1;
        int startRes = pageIndex % pagesWide * totalRes;
        int endRes = Math.min(startRes + totalRes - 1, alignmentWidth - 1);
        int startSeq = pageIndex / pagesWide * totalSeq;
        int alignmentHeight = this.av.getAlignment().getHeight();
        int endSeq = Math.min(startSeq + totalSeq, alignmentHeight);
        int pagesHigh = (alignmentHeight / totalSeq + 1) * pageHeight;
        if (this.av.isShowAnnotation()) {
            pagesHigh += this.getAnnotationPanel().adjustPanelHeight() + 3;
        }
        if (pageIndex >= pagesWide * (pagesHigh /= pageHeight)) {
            return 1;
        }
        int alignmentDrawnHeight = (endSeq - startSeq) * charHeight + 3;
        alignmentGraphics.setColor(Color.white);
        alignmentGraphics.fillRect(0, 0, pageWidth, pageHeight + scaleHeight);
        alignmentGraphics.translate(alignmentGraphicsOffset, 0);
        this.getScalePanel().drawScale(alignmentGraphics, startRes, endRes, pageWidth - idWidth, scaleHeight);
        alignmentGraphics.translate(-alignmentGraphicsOffset, 0);
        idGraphics.translate(0, scaleHeight);
        IdCanvas idCanvas = this.getIdPanel().getIdCanvas();
        List<SequenceI> selection = this.av.getSelectionGroup() == null ? null : this.av.getSelectionGroup().getSequences(null);
        idCanvas.drawIds((Graphics2D)idGraphics, this.av, startSeq, endSeq - 1, selection, false, idWidth);
        idGraphics.setFont(this.av.getFont());
        idGraphics.translate(0, -scaleHeight);
        alignmentGraphics.translate(alignmentGraphicsOffset, scaleHeight);
        this.getSeqPanel().seqCanvas.drawPanelForPrinting(alignmentGraphics, startRes, endRes, startSeq, endSeq - 1);
        alignmentGraphics.translate(-alignmentGraphicsOffset, 0);
        if (this.av.isShowAnnotation() && endSeq == alignmentHeight) {
            int offset = this.getAlabels().getScrollOffset();
            idGraphics.translate(0, -offset);
            idGraphics.translate(0, alignmentDrawnHeight);
            this.getAlabels().drawComponentNotGUI(idGraphics, idWidth);
            idGraphics.translate(0, -alignmentDrawnHeight);
            alignmentGraphics.translate(alignmentGraphicsOffset, alignmentDrawnHeight);
            this.updateLayout();
            this.getAnnotationPanel().renderer.drawComponent(this.getAnnotationPanel(), this.av, alignmentGraphics, -1, startRes, endRes + 1);
        }
        return 0;
    }

    public int printWrappedAlignment(int pageWidth, int pageHeight, int pageNumber, Graphics g) throws PrinterException {
        this.getSeqPanel().seqCanvas.calculateWrappedGeometry(this.getWidth(), this.getHeight());
        int annotationHeight = 0;
        if (this.av.isShowAnnotation()) {
            annotationHeight = this.getAnnotationPanel().adjustPanelHeight();
        }
        int hgap = this.av.getCharHeight();
        if (this.av.getScaleAboveWrapped()) {
            hgap += this.av.getCharHeight();
        }
        int cHeight = this.av.getAlignment().getHeight() * this.av.getCharHeight() + hgap + annotationHeight;
        int idWidth = this.getVisibleIdWidth(false);
        int maxwidth = this.av.getAlignment().getVisibleWidth();
        int resWidth = this.getSeqPanel().seqCanvas.getWrappedCanvasWidth(pageWidth - idWidth);
        this.av.getRanges().setViewportStartAndWidth(0, resWidth);
        int totalHeight = cHeight * ((maxwidth + resWidth - 1) / resWidth + 1);
        g.setColor(Color.white);
        g.fillRect(0, 0, pageWidth, pageHeight);
        g.setFont(this.av.getFont());
        g.setColor(Color.black);
        g.translate(0, -pageNumber * pageHeight);
        g.setClip(0, pageNumber * pageHeight, pageWidth, pageHeight);
        IdCanvas idCanvas = this.getIdPanel().getIdCanvas();
        idCanvas.drawIdsWrappedNoGUI((Graphics2D)g, this.av, 0, totalHeight);
        g.translate(idWidth, 0);
        this.getSeqPanel().seqCanvas.drawWrappedPanelForPrinting(g, pageWidth - idWidth, totalHeight, 0);
        if (pageNumber * pageHeight < totalHeight) {
            return 0;
        }
        return 1;
    }

    public int getVisibleIdWidth() {
        return this.getVisibleIdWidth(true);
    }

    protected int getVisibleIdWidth(boolean onscreen) {
        Integer idwidth;
        if (!onscreen && Cache.getDefault("FIGURE_AUTOIDWIDTH", false)) {
            return this.calculateIdWidth((int)-1, (boolean)true, (boolean)true).width;
        }
        Integer n = idwidth = onscreen ? null : Cache.getIntegerProperty("FIGURE_FIXEDIDWIDTH");
        if (idwidth != null) {
            return idwidth + 4;
        }
        int w = this.calculateIdWidth((int)-1, (boolean)true, (boolean)true).width;
        return w > 0 ? w : this.calculateIdWidth().width;
    }

    void makeAlignmentImage(ImageMaker.TYPE type, File file, String renderer) throws ImageOutputException {
        this.makeAlignmentImage(type, file, renderer, BitmapImageSizing.defaultBitmapImageSizing());
    }

    void makeAlignmentImage(ImageMaker.TYPE type, File file, String renderer, BitmapImageSizing userBis) throws ImageOutputException {
        int borderBottomOffset = 5;
        final AlignmentDimension aDimension = this.getAlignmentDimension();
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics graphics) throws Exception {
                if (AlignmentPanel.this.av.getWrapAlignment()) {
                    AlignmentPanel.this.printWrappedAlignment(aDimension.getWidth(), aDimension.getHeight() + 5, 0, graphics);
                } else {
                    AlignmentPanel.this.printUnwrapped(aDimension.getWidth(), aDimension.getHeight(), 0, graphics, graphics);
                }
            }
        };
        String fileTitle = this.alignFrame.getTitle();
        ImageExporter exporter = new ImageExporter(writer, this.alignFrame, type, fileTitle);
        int imageWidth = aDimension.getWidth();
        int imageHeight = aDimension.getHeight() + 5;
        String of = MessageManager.getString("label.alignment");
        exporter.doExport(file, this, imageWidth, imageHeight, of, renderer, userBis);
    }

    public AlignmentDimension getAlignmentDimension() {
        int maxwidth = this.av.getAlignment().getVisibleWidth();
        int height = (this.av.getAlignment().getHeight() + 1) * this.av.getCharHeight() + this.getScalePanel().getHeight();
        int width = this.getVisibleIdWidth(false) + maxwidth * this.av.getCharWidth();
        if (this.av.getWrapAlignment()) {
            height = this.getWrappedHeight();
            width = Jalview.isHeadlessMode() ? this.alignFrame.getWidth() - this.vscroll.getPreferredSize().width - this.alignFrame.getInsets().left - this.alignFrame.getInsets().right - this.getVisibleIdWidth() + this.getVisibleIdWidth(false) : this.getSeqPanel().getWidth() + this.getVisibleIdWidth(false);
        } else if (this.av.isShowAnnotation()) {
            height += this.getAnnotationPanel().adjustPanelHeight() + 3;
        }
        return new AlignmentDimension(width, height);
    }

    public void makePNGImageMap(File imgMapFile, String imageName) throws ImageOutputException {
        int idWidth = this.getVisibleIdWidth(false);
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        int scaleHeight = this.av.getCharHeight() + fm.getDescent();
        if (imgMapFile != null) {
            try {
                int sSize = this.av.getAlignment().getHeight();
                int alwidth = this.av.getAlignment().getWidth();
                PrintWriter out = new PrintWriter(new FileWriter(imgMapFile));
                out.println(HTMLOutput.getImageMapHTML());
                out.println("<img src=\"" + imageName + "\" border=\"0\" usemap=\"#Map\" ><map name=\"Map\">");
                for (int s = 0; s < sSize; ++s) {
                    int sy = s * this.av.getCharHeight() + scaleHeight;
                    SequenceI seq = this.av.getAlignment().getSequenceAt(s);
                    SequenceGroup[] groups = this.av.getAlignment().findAllGroups(seq);
                    for (int column = 0; column < alwidth; ++column) {
                        StringBuilder text = new StringBuilder(512);
                        String triplet = null;
                        triplet = this.av.getAlignment().isNucleotide() ? ResidueProperties.nucleotideName.get("" + seq.getCharAt(column)) : ResidueProperties.aa2Triplet.get("" + seq.getCharAt(column));
                        if (triplet == null) continue;
                        int seqPos = seq.findPosition(column);
                        int gSize = groups.length;
                        for (int g = 0; g < gSize; ++g) {
                            if (text.length() < 1) {
                                text.append("<area shape=\"rect\" coords=\"").append(idWidth + column * this.av.getCharWidth()).append(",").append(sy).append(",").append(idWidth + (column + 1) * this.av.getCharWidth()).append(",").append(this.av.getCharHeight() + sy).append("\"").append(" onMouseOver=\"toolTip('").append(seqPos).append(" ").append(triplet);
                            }
                            if (groups[g].getStartRes() >= column || groups[g].getEndRes() <= column) continue;
                            text.append("<br><em>").append(groups[g].getName()).append("</em>");
                        }
                        if (text.length() < 1) {
                            text.append("<area shape=\"rect\" coords=\"").append(idWidth + column * this.av.getCharWidth()).append(",").append(sy).append(",").append(idWidth + (column + 1) * this.av.getCharWidth()).append(",").append(this.av.getCharHeight() + sy).append("\"").append(" onMouseOver=\"toolTip('").append(seqPos).append(" ").append(triplet);
                        }
                        if (Comparison.isGap(seq.getCharAt(column))) continue;
                        List<SequenceFeature> features = seq.findFeatures(column, column, new String[0]);
                        for (SequenceFeature sf : features) {
                            String status;
                            if (sf.isContactFeature()) {
                                text.append("<br>").append(sf.getType()).append(" ").append(sf.getBegin()).append(":").append(sf.getEnd());
                            } else {
                                text.append("<br>");
                                text.append(sf.getType());
                                String description = sf.getDescription();
                                if (description != null && !sf.getType().equals(description)) {
                                    description = description.replace("\"", "&quot;");
                                    text.append(" ").append(description);
                                }
                            }
                            if ((status = sf.getStatus()) == null || "".equals(status)) continue;
                            text.append(" (").append(status).append(")");
                        }
                        if (text.length() <= 1) continue;
                        text.append("')\"; onMouseOut=\"toolTip()\";  href=\"#\">");
                        out.println(text.toString());
                    }
                }
                out.println("</map></body></html>");
                out.close();
            }
            catch (Exception ex) {
                throw new ImageOutputException("couldn't write ImageMap due to unexpected error", ex);
            }
        }
    }

    int getWrappedHeight() {
        int seqPanelWidth = this.getSeqPanel().seqCanvas.getWidth();
        if (Jalview.isHeadlessMode()) {
            seqPanelWidth = this.alignFrame.getWidth() - this.getVisibleIdWidth() - this.vscroll.getPreferredSize().width - this.alignFrame.getInsets().left - this.alignFrame.getInsets().right;
        }
        int chunkWidth = this.getSeqPanel().seqCanvas.getWrappedCanvasWidth(seqPanelWidth);
        int hgap = this.av.getCharHeight();
        if (this.av.getScaleAboveWrapped()) {
            hgap += this.av.getCharHeight();
        }
        int annotationHeight = 0;
        if (this.av.isShowAnnotation()) {
            hgap += 3;
            annotationHeight = this.getAnnotationPanel().adjustPanelHeight();
        }
        int cHeight = this.av.getAlignment().getHeight() * this.av.getCharHeight() + hgap + annotationHeight;
        int maxwidth = this.av.getAlignment().getWidth();
        if (this.av.hasHiddenColumns()) {
            maxwidth = this.av.getAlignment().getHiddenColumns().absoluteToVisibleColumn(maxwidth) - 1;
        }
        int height = (maxwidth / chunkWidth + 1) * cHeight;
        return height;
    }

    public void closePanel() {
        PaintRefresher.RemoveComponent(this.getSeqPanel().seqCanvas);
        PaintRefresher.RemoveComponent(this.getIdPanel().getIdCanvas());
        PaintRefresher.RemoveComponent(this);
        this.closeChildFrames();
        if (this.annotationPanel != null) {
            this.annotationPanel.dispose();
            this.annotationPanel = null;
        }
        if (this.av != null) {
            this.av.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
            StructureSelectionManager ssm = this.av.getStructureSelectionManager();
            ssm.removeStructureViewerListener(this.getSeqPanel(), null);
            ssm.removeSelectionListener(this.getSeqPanel());
            ssm.removeCommandListener(this.av);
            ssm.removeStructureViewerListener(this.getSeqPanel(), null);
            ssm.removeSelectionListener(this.getSeqPanel());
            this.av.dispose();
            this.av = null;
        } else if (Console.isDebugEnabled()) {
            Console.warn("Closing alignment panel which is already closed.");
        }
    }

    protected void closeChildFrames() {
        if (this.overviewPanel != null) {
            this.overviewPanel.dispose();
            this.overviewPanel = null;
        }
        if (this.calculationDialog != null) {
            this.calculationDialog.closeFrame();
            this.calculationDialog = null;
        }
    }

    public void updateAnnotation() {
        this.updateAnnotation(false, false);
    }

    public void updateAnnotation(boolean applyGlobalSettings) {
        this.updateAnnotation(applyGlobalSettings, false);
    }

    public void updateAnnotation(boolean applyGlobalSettings, boolean preserveNewGroupSettings) {
        this.av.updateSecondaryStructureConsensus(this);
        this.av.updateGroupAnnotationSettings(applyGlobalSettings, preserveNewGroupSettings);
        this.adjustAnnotationHeight();
    }

    @Override
    public AlignmentI getAlignment() {
        return this.av == null ? null : this.av.getAlignment();
    }

    @Override
    public String getViewName() {
        return this.av.getViewName();
    }

    public void setSelected(boolean b) {
        try {
            if (this.alignFrame.getSplitViewContainer() != null) {
                ((SplitFrame)this.alignFrame.getSplitViewContainer()).setSelected(b);
            }
            this.alignFrame.setSelected(b);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (b) {
            this.setAlignFrameView();
        }
    }

    public void setAlignFrameView() {
        this.alignFrame.setDisplayedView(this);
    }

    @Override
    public StructureSelectionManager getStructureSelectionManager() {
        return this.av.getStructureSelectionManager();
    }

    @Override
    public void raiseOOMWarning(String string, OutOfMemoryError error) {
        new OOMWarning(string, error, this);
    }

    @Override
    public jalview.api.FeatureRenderer cloneFeatureRenderer() {
        return new FeatureRenderer(this);
    }

    @Override
    public jalview.api.FeatureRenderer getFeatureRenderer() {
        return this.seqPanel.seqCanvas.getFeatureRenderer();
    }

    public void updateFeatureRenderer(jalview.renderer.seqfeatures.FeatureRenderer fr) {
        fr.transferSettings(this.getSeqPanel().seqCanvas.getFeatureRenderer());
    }

    public void updateFeatureRendererFrom(jalview.api.FeatureRenderer fr) {
        if (this.getSeqPanel().seqCanvas.getFeatureRenderer() != null) {
            this.getSeqPanel().seqCanvas.getFeatureRenderer().transferSettings(fr);
        }
    }

    public ScalePanel getScalePanel() {
        return this.scalePanel;
    }

    public void setScalePanel(ScalePanel scalePanel) {
        this.scalePanel = scalePanel;
    }

    public SeqPanel getSeqPanel() {
        return this.seqPanel;
    }

    public void setSeqPanel(SeqPanel seqPanel) {
        this.seqPanel = seqPanel;
    }

    public AnnotationPanel getAnnotationPanel() {
        return this.annotationPanel;
    }

    public void setAnnotationPanel(AnnotationPanel annotationPanel) {
        this.annotationPanel = annotationPanel;
    }

    public AnnotationLabels getAlabels() {
        return this.alabels;
    }

    public void setAlabels(AnnotationLabels alabels) {
        this.alabels = alabels;
    }

    public IdPanel getIdPanel() {
        return this.idPanel;
    }

    public void setIdPanel(IdPanel idPanel) {
        this.idPanel = idPanel;
    }

    protected void scrollToCentre(SearchResultsI sr, int verticalOffset) {
        this.scrollToPosition(sr, verticalOffset, true);
    }

    protected void setToScrollComplementPanel(boolean b) {
        this.scrollComplementaryPanel = b;
    }

    protected boolean isSetToScrollComplementPanel() {
        return this.scrollComplementaryPanel;
    }

    protected void refresh(boolean adjustHeight) {
        this.validateAnnotationDimensions(adjustHeight);
        this.addNotify();
        if (adjustHeight) {
            this.paintAlignment(true, false);
        } else {
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ViewportRanges ranges = this.av.getRanges();
        int x = ranges.getStartRes();
        int y = ranges.getStartSeq();
        this.setScrollValues(x, y);
        if (this.isSetToScrollComplementPanel()) {
            this.setToScrollComplementPanel(false);
            this.av.scrollComplementaryAlignment();
            this.setToScrollComplementPanel(true);
        }
    }

    public void setCalculationDialog(CalculationChooser calculationChooser) {
        this.calculationDialog = calculationChooser;
    }

    public CalculationChooser getCalculationDialog() {
        return this.calculationDialog;
    }

    public String setOverviewTitle(AlignFrame alignFrame) {
        if (this.overviewPanel == null) {
            return null;
        }
        Object overviewTitle = MessageManager.formatMessage("label.overview_params", alignFrame.getTitle());
        String viewName = this.getViewName();
        if (viewName != null) {
            overviewTitle = (String)overviewTitle + " " + viewName;
        }
        this.overviewPanel.setTitle((String)overviewTitle);
        return overviewTitle;
    }

    public void closeOverviewPanel() {
        if (this.overviewPanel != null) {
            this.overviewPanel.close();
            this.overviewPanel = null;
        }
    }
}

