/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.threedbeacons;

import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.fts.core.GFTSPanel;
import jalview.fts.service.threedbeacons.TDBeaconsFTSRestClient;
import jalview.gui.SequenceFetcher;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.util.MessageManager;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;

public class TDBeaconsFTSPanel
extends GFTSPanel {
    private static String defaultFTSFrameTitle = MessageManager.getString("label.pdb_sequence_fetcher");
    private static Map<String, Integer> tempUserPrefs = new HashMap<String, Integer>();
    private static final String THREEDB_FTS_CACHE_KEY = "CACHE.THREEDB_FTS";
    private static final String THREEDB_AUTOSEARCH = "FTS.THREEDB.AUTOSEARCH";
    private static HttpURLConnection connection;

    public TDBeaconsFTSPanel(SequenceFetcher fetcher) {
        super((SequenceFetcher)null);
        this.pageLimit = TDBeaconsFTSRestClient.getInstance().getDefaultResponsePageSize();
        this.seqFetcher = fetcher;
        this.progressIndicator = fetcher == null ? null : fetcher.getProgressIndicator();
    }

    @Override
    public void searchAction(boolean isFreshSearch) {
        this.mainFrame.requestFocusInWindow();
        if (isFreshSearch) {
            this.offSet = 0;
        }
        new Thread(){

            @Override
            public void run() {
                TDBeaconsFTSPanel.this.reset();
                boolean allowEmptySequence = false;
                if (TDBeaconsFTSPanel.this.getTypedText().length() > 0) {
                    String result;
                    FTSRestResponse resultList;
                    TDBeaconsFTSPanel.this.setSearchInProgress(true);
                    long startTime = System.currentTimeMillis();
                    String searchTarget = ((FTSDataColumnI)TDBeaconsFTSPanel.this.cmb_searchTarget.getSelectedItem()).getCode();
                    TDBeaconsFTSPanel.this.wantedFields = TDBeaconsFTSRestClient.getInstance().getAllDefaultDisplayedFTSDataColumns();
                    String searchTerm = TDBeaconsFTSPanel.this.getTypedText();
                    FTSRestRequest request = new FTSRestRequest();
                    request.setAllowEmptySeq(allowEmptySequence);
                    request.setResponseSize(100);
                    request.setSearchTerm(searchTerm + ".json");
                    request.setOffSet(TDBeaconsFTSPanel.this.offSet);
                    request.setWantedFields(TDBeaconsFTSPanel.this.wantedFields);
                    FTSRestClientI tdbRestClient = TDBeaconsFTSRestClient.getInstance();
                    try {
                        resultList = tdbRestClient.executeRequest(request);
                    }
                    catch (Exception e) {
                        TDBeaconsFTSPanel.this.setErrorMessage(e.getMessage());
                        TDBeaconsFTSPanel.this.checkForErrors();
                        TDBeaconsFTSPanel.this.setSearchInProgress(false);
                        return;
                    }
                    if (resultList.getSearchSummary() != null && resultList.getSearchSummary().size() > 0) {
                        TDBeaconsFTSPanel.this.getResultTable().setModel(FTSRestResponse.getTableModel(request, resultList.getSearchSummary()));
                        FTSRestResponse.configureTableColumn(TDBeaconsFTSPanel.this.getResultTable(), TDBeaconsFTSPanel.this.wantedFields, tempUserPrefs);
                        TDBeaconsFTSPanel.this.getResultTable().setVisible(true);
                    }
                    long endTime = System.currentTimeMillis();
                    TDBeaconsFTSPanel.this.totalResultSetCount = resultList.getNumberOfItemsFound();
                    TDBeaconsFTSPanel.this.resultSetCount = resultList.getSearchSummary() == null ? 0 : resultList.getSearchSummary().size();
                    String string = result = TDBeaconsFTSPanel.this.resultSetCount > 0 ? MessageManager.getString("label.results") : MessageManager.getString("label.result");
                    if (TDBeaconsFTSPanel.this.isPaginationEnabled() && TDBeaconsFTSPanel.this.resultSetCount > 0) {
                        String f1 = totalNumberformatter.format((Object)(TDBeaconsFTSPanel.this.offSet + 1));
                        String f2 = totalNumberformatter.format((Object)(TDBeaconsFTSPanel.this.offSet + TDBeaconsFTSPanel.this.resultSetCount));
                        String f3 = totalNumberformatter.format((Object)TDBeaconsFTSPanel.this.totalResultSetCount);
                        TDBeaconsFTSPanel.this.updateSearchFrameTitle(defaultFTSFrameTitle + " - " + result + " " + f1 + " to " + f2 + " of " + f3 + "  (" + (endTime - startTime) + " milli secs)");
                    } else {
                        TDBeaconsFTSPanel.this.updateSearchFrameTitle(defaultFTSFrameTitle + " - " + TDBeaconsFTSPanel.this.resultSetCount + " " + result + " (" + (endTime - startTime) + " milli secs)");
                    }
                    TDBeaconsFTSPanel.this.setSearchInProgress(false);
                    TDBeaconsFTSPanel.this.refreshPaginatorState();
                    TDBeaconsFTSPanel.this.updateSummaryTableSelections();
                }
                TDBeaconsFTSPanel.this.txt_search.updateCache();
            }
        }.start();
    }

    @Override
    public void okAction() {
        this.disableActionButtons();
        StringBuilder selectedIds = new StringBuilder();
        final HashSet<String> selectedIdsSet = new HashSet<String>();
        int primaryKeyColIndex = 0;
        try {
            primaryKeyColIndex = this.getFTSRestClient().getPrimaryKeyColumIndex(this.wantedFields, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] selectedRows = this.getResultTable().getSelectedRows();
        final String searchTerm = this.getTypedText();
        for (int summaryRow : selectedRows) {
            String idStr = this.getResultTable().getValueAt(summaryRow, primaryKeyColIndex).toString();
            selectedIdsSet.add(idStr);
        }
        Object object = this.paginatorCart.iterator();
        while (object.hasNext()) {
            String idStr = (String)object.next();
            selectedIdsSet.add(idStr);
        }
        for (String selectedId : selectedIdsSet) {
            selectedIds.append(selectedId).append(";");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlignmentI allSeqs = null;
                FormatAdapter fl = new FormatAdapter();
                for (String tdbURL : selectedIdsSet) {
                    try {
                        AlignmentI tdbAl = fl.readFile(tdbURL, DataSourceType.URL, (FileFormatI)FileFormat.MMCif);
                        if (tdbAl == null) continue;
                        if (allSeqs != null) {
                            allSeqs.append(tdbAl);
                            continue;
                        }
                        allSeqs = tdbAl;
                    }
                    catch (Exception x) {
                        Console.warn("Couldn't retrieve 3d-beacons model for uniprot id" + searchTerm + " : " + tdbURL, x);
                    }
                }
                TDBeaconsFTSPanel.this.seqFetcher.parseResult(allSeqs, "3D-Beacons models for " + searchTerm, FileFormat.MMCif, null);
            }
        });
        this.delayAndEnableActionButtons();
    }

    @Override
    public FTSRestClientI getFTSRestClient() {
        return TDBeaconsFTSRestClient.getInstance();
    }

    @Override
    public String getFTSFrameTitle() {
        return defaultFTSFrameTitle;
    }

    @Override
    public boolean isPaginationEnabled() {
        return true;
    }

    @Override
    public Map<String, Integer> getTempUserPrefs() {
        return tempUserPrefs;
    }

    @Override
    public String getCacheKey() {
        return THREEDB_FTS_CACHE_KEY;
    }

    @Override
    public String getAutosearchPreference() {
        return THREEDB_AUTOSEARCH;
    }

    @Override
    protected void showHelp() {
        Console.outPrintln("No help implemented yet.");
    }

    public static String decodeSearchTerm(String enteredText) {
        return enteredText;
    }

    @Override
    public String getDbName() {
        return "3D-Beacons";
    }
}

