/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.android;

import jalview.ext.android.ContainerHelpers;

public class SparseShortArray
implements Cloneable {
    private short[] mKeys;
    private short[] mValues;
    private int mSize;

    public SparseShortArray() {
        this(10);
    }

    public SparseShortArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = new short[0];
            this.mValues = new short[0];
        } else {
            initialCapacity = SparseShortArray.idealShortArraySize(initialCapacity);
            this.mKeys = new short[initialCapacity];
            this.mValues = new short[initialCapacity];
        }
        this.mSize = 0;
    }

    public SparseShortArray clone() {
        SparseShortArray clone = null;
        try {
            clone = (SparseShortArray)super.clone();
            clone.mKeys = (short[])this.mKeys.clone();
            clone.mValues = (short[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public int get(int key) {
        return this.get(key, 0);
    }

    public int get(int key, int valueIfKeyNotFound) {
        SparseShortArray.checkOverflow(key);
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, (short)key);
        if (i < 0) {
            return valueIfKeyNotFound;
        }
        return this.mValues[i];
    }

    public void delete(int key) {
        SparseShortArray.checkOverflow(key);
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, (short)key);
        if (i >= 0) {
            this.removeAt(i);
        }
    }

    public void removeAt(int index) {
        System.arraycopy(this.mKeys, index + 1, this.mKeys, index, this.mSize - (index + 1));
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - (index + 1));
        --this.mSize;
    }

    public void put(int key, int value) {
        SparseShortArray.checkOverflow(key);
        SparseShortArray.checkOverflow(value);
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, (short)key);
        if (i >= 0) {
            this.mValues[i] = (short)value;
        } else {
            i ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                int n = SparseShortArray.idealShortArraySize(this.mSize + 1);
                short[] nkeys = new short[n];
                short[] nvalues = new short[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = (short)key;
            this.mValues[i] = (short)value;
            ++this.mSize;
        }
    }

    public int size() {
        return this.mSize;
    }

    public short keyAt(int index) {
        return this.mKeys[index];
    }

    public short valueAt(int index) {
        return this.mValues[index];
    }

    public int indexOfKey(int key) {
        SparseShortArray.checkOverflow(key);
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, (short)key);
    }

    public int indexOfValue(int value) {
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void append(int key, int value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        int pos = this.mSize;
        if (pos >= this.mKeys.length) {
            int n = SparseShortArray.idealShortArraySize(pos + 1);
            short[] nkeys = new short[n];
            short[] nvalues = new short[n];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        SparseShortArray.checkOverflow(key);
        SparseShortArray.checkOverflow(value);
        this.mKeys[pos] = (short)key;
        this.mValues[pos] = (short)value;
        this.mSize = pos + 1;
    }

    public static void checkOverflow(int value) {
        if (value > Short.MAX_VALUE || value < Short.MIN_VALUE) {
            throw new ArithmeticException(String.valueOf(value));
        }
    }

    public static int idealShortArraySize(int need) {
        return SparseShortArray.idealByteArraySize(need * 2) / 2;
    }

    public static int idealByteArraySize(int need) {
        for (int i = 4; i < 32; ++i) {
            if (need > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return need;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            short key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            short value = this.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public int add(int key, int toAdd) {
        int newValue = toAdd;
        SparseShortArray.checkOverflow(key);
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, (short)key);
        if (i >= 0) {
            SparseShortArray.checkOverflow(toAdd + this.mValues[i]);
            int n = i;
            this.mValues[n] = (short)(this.mValues[n] + (short)toAdd);
            newValue = this.mValues[i];
        } else {
            SparseShortArray.checkOverflow(toAdd);
            i ^= 0xFFFFFFFF;
            if (this.mSize >= this.mKeys.length) {
                int n = SparseShortArray.idealShortArraySize(this.mSize + 1);
                short[] nkeys = new short[n];
                short[] nvalues = new short[n];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i != 0) {
                System.arraycopy(this.mKeys, i, this.mKeys, i + 1, this.mSize - i);
                System.arraycopy(this.mValues, i, this.mValues, i + 1, this.mSize - i);
            }
            this.mKeys[i] = (short)key;
            this.mValues[i] = (short)toAdd;
            ++this.mSize;
        }
        return newValue;
    }
}

