/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FeatureAttributes {
    private static FeatureAttributes instance = new FeatureAttributes();
    private Map<String, Map<String[], AttributeData>> attributes;
    private Comparator<String[]> comparator = new Comparator<String[]>(){

        @Override
        public int compare(String[] o1, String[] o2) {
            for (int i = 0; i < o1.length || i < o2.length; ++i) {
                if (o2.length <= i) {
                    return o1.length <= i ? 0 : 1;
                }
                if (o1.length <= i) {
                    return -1;
                }
                int comp = String.CASE_INSENSITIVE_ORDER.compare(o1[i], o2[i]);
                if (comp == 0) continue;
                return comp;
            }
            return 0;
        }
    };

    public static FeatureAttributes getInstance() {
        return instance;
    }

    private FeatureAttributes() {
        this.attributes = new HashMap<String, Map<String[], AttributeData>>();
    }

    public List<String[]> getAttributes(String featureType) {
        if (!this.attributes.containsKey(featureType)) {
            return Collections.emptyList();
        }
        return new ArrayList<String[]>(this.attributes.get(featureType).keySet());
    }

    public boolean hasAttributes(String featureType) {
        return this.attributes.containsKey(featureType) && !this.attributes.get(featureType).isEmpty();
    }

    public void addAttribute(String featureType, String description, Object value, String ... attName) {
        AttributeData attData;
        if (featureType == null || attName == null) {
            return;
        }
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String[] attNames = new String[attName.length + 1];
                System.arraycopy(attName, 0, attNames, 0, attName.length);
                attNames[attName.length] = entry.getKey().toString();
                this.addAttribute(featureType, description, entry.getValue(), attNames);
            }
            return;
        }
        String valueAsString = value.toString();
        Map<String[], AttributeData> atts = this.attributes.get(featureType);
        if (atts == null) {
            atts = new TreeMap<String[], AttributeData>(this.comparator);
            this.attributes.put(featureType, atts);
        }
        if ((attData = atts.get(attName)) == null) {
            attData = new AttributeData();
            atts.put(attName, attData);
        }
        attData.addInstance(description, valueAsString);
    }

    public String getDescription(String featureType, String ... attName) {
        AttributeData attData;
        String desc = null;
        Map<String[], AttributeData> atts = this.attributes.get(featureType);
        if (atts != null && (attData = atts.get(attName)) != null) {
            desc = attData.getDescription();
        }
        return desc;
    }

    public float[] getMinMax(String featureType, String ... attName) {
        AttributeData attData;
        Map<String[], AttributeData> atts = this.attributes.get(featureType);
        if (atts != null && (attData = atts.get(attName)) != null && attData.hasValue) {
            return new float[]{attData.min, attData.max};
        }
        return null;
    }

    public void addDescription(String featureType, String description, String ... attName) {
        AttributeData attData;
        if (featureType == null || attName == null) {
            return;
        }
        Map<String[], AttributeData> atts = this.attributes.get(featureType);
        if (atts == null) {
            atts = new TreeMap<String[], AttributeData>(this.comparator);
            this.attributes.put(featureType, atts);
        }
        if ((attData = atts.get(attName)) == null) {
            attData = new AttributeData();
            atts.put(attName, attData);
        }
        attData.addDescription(description);
    }

    public Datatype getDatatype(String featureType, String ... attName) {
        AttributeData attData;
        Map<String[], AttributeData> atts = this.attributes.get(featureType);
        if (atts != null && (attData = atts.get(attName)) != null) {
            return attData.getType();
        }
        return null;
    }

    public void clear() {
        this.attributes.clear();
    }

    public void clear(String featureType) {
        Map<String[], AttributeData> map = this.attributes.get(featureType);
        if (map != null) {
            map.clear();
        }
    }

    private class AttributeData {
        List<String> description;
        float min = 0.0f;
        float max = 0.0f;
        boolean hasValue = false;
        Datatype type;

        private AttributeData() {
        }

        void addInstance(String desc, String value) {
            this.addDescription(desc);
            if (value != null) {
                value = value.trim();
                if (this.type == null || this.type == Datatype.Number) {
                    try {
                        float f = Float.valueOf(value).floatValue();
                        this.min = this.hasValue ? Math.min(this.min, f) : f;
                        this.max = this.hasValue ? Math.max(this.max, f) : f;
                        this.hasValue = true;
                        this.type = this.type == null || this.type == Datatype.Number ? Datatype.Number : Datatype.Mixed;
                    }
                    catch (NumberFormatException e) {
                        this.type = this.type == null || this.type == Datatype.Character ? Datatype.Character : Datatype.Mixed;
                        this.min = 0.0f;
                        this.max = 0.0f;
                        this.hasValue = false;
                    }
                }
            }
        }

        public String getDescription() {
            if (this.description != null && this.description.size() == 1) {
                return this.description.get(0);
            }
            return null;
        }

        public Datatype getType() {
            return this.type;
        }

        public void addDescription(String desc) {
            if (desc != null) {
                if (this.description == null) {
                    this.description = new ArrayList<String>();
                }
                if (!this.description.contains(desc)) {
                    this.description.add(desc);
                }
            }
        }
    }

    public static enum Datatype {
        Character,
        Number,
        Mixed;

    }
}

