/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

public final class AlignedCodon {
    public final int pos1;
    public final int pos2;
    public final int pos3;
    public final int peptideCol;
    public final String product;

    public AlignedCodon(int i, int j, int k) {
        this(i, j, k, null, 0);
    }

    public AlignedCodon(int i, int j, int k, String prod, int prodCol) {
        this.pos1 = i;
        this.pos2 = j;
        this.pos3 = k;
        this.product = prod;
        this.peptideCol = prodCol;
    }

    public int getBaseColumn(int base) {
        if (base < 1 || base > 3) {
            throw new IllegalArgumentException(Integer.toString(base));
        }
        return base == 1 ? this.pos1 : (base == 2 ? this.pos2 : this.pos3);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return true;
        }
        if (!(o instanceof AlignedCodon)) {
            return false;
        }
        AlignedCodon ac = (AlignedCodon)o;
        return this.pos1 == ac.pos1 && this.pos2 == ac.pos2 && this.pos3 == ac.pos3;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.pos1).append(", ").append(this.pos2).append(", ").append(this.pos3).append("]");
        return sb.toString();
    }
}

