/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin.argparser;

import jalview.bin.Console;
import jalview.bin.argparser.ArgParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SubVals {
    public static int NOTSET = -1;
    private int index = NOTSET;
    private Map<String, String> subValMap;
    private static char SEPARATOR = (char)44;
    private static char EQUALS = (char)61;
    private String content = null;

    protected SubVals(SubVals sv, String c) {
        this(sv, c, true);
    }

    protected SubVals(SubVals sv, String c, boolean merge) {
        SubVals subvals;
        if (merge) {
            SubVals vsv = new SubVals(c);
            if (sv != null && sv.getSubValMap() != null) {
                for (String key : sv.getSubValMap().keySet()) {
                    vsv.put(key, sv.get(key));
                }
            }
            if (sv != null && sv.getIndex() > 0) {
                vsv.index = sv.getIndex();
            }
            subvals = vsv;
        } else {
            subvals = sv;
        }
        if (subvals == null) {
            this.subValMap = new HashMap<String, String>();
        } else {
            this.subValMap = subvals == null ? new HashMap() : subvals.getSubValMap();
            this.index = subvals.getIndex();
        }
        this.content = c;
    }

    protected SubVals(String item) {
        if (this.subValMap == null) {
            this.subValMap = new HashMap<String, String>();
        }
        this.parseVals(item);
    }

    public void parseVals(String item) {
        if (item == null) {
            return;
        }
        if (item.indexOf(91) == 0 && item.indexOf(93) > 1) {
            int openBracket = 0;
            int closeBracket = item.indexOf(93);
            String subvalsString = item.substring(openBracket + 1, closeBracket);
            this.content = item.substring(closeBracket + 1);
            boolean setIndex = false;
            for (String subvalString : subvalsString.split(Character.toString(SEPARATOR))) {
                int equals = subvalString.indexOf(EQUALS);
                if (equals > -1) {
                    this.put(subvalString.substring(0, equals), subvalString.substring(equals + 1));
                    continue;
                }
                try {
                    this.index = Integer.parseInt(subvalString);
                    setIndex = true;
                }
                catch (NumberFormatException e) {
                    this.put(subvalString, "true");
                }
            }
            if (!setIndex) {
                this.index = NOTSET;
            } else {
                Console.debug("SubVals from '" + subvalsString + "' has index " + this.index + " set");
            }
        } else {
            this.content = item;
        }
    }

    protected void put(String key, String val) {
        this.subValMap.put(key, val);
    }

    public boolean notSet() {
        return this.index == NOTSET && (this.subValMap == null || this.subValMap.size() == 0);
    }

    public String getWithSubstitutions(ArgParser ap, String id, String key) {
        return ap.makeSubstitutions(this.subValMap.get(key), id);
    }

    public String get(String key) {
        return this.subValMap.get(key);
    }

    public boolean has(String key) {
        return this.subValMap.containsKey(key);
    }

    public int getIndex() {
        return this.index;
    }

    public String getContent() {
        return this.content;
    }

    protected Map<String, String> getSubValMap() {
        return this.subValMap;
    }

    public String toString() {
        if (this.subValMap == null && this.getIndex() == NOTSET) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> entries = new ArrayList<String>();
        this.subValMap.entrySet().stream().forEachOrdered(m -> entries.add(((String)m.getValue()).equals("true") ? (String)m.getKey() : (String)m.getKey() + EQUALS + (String)m.getValue()));
        if (this.getIndex() != NOTSET) {
            entries.add(Integer.toString(this.getIndex()));
        }
        sb.append('[');
        sb.append(String.join((CharSequence)Character.toString(SEPARATOR), entries));
        sb.append(']');
        return sb.toString();
    }
}

