/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.bin.Jalview;
import jalview.bin.argparser.Arg;
import jalview.bin.argparser.ArgParser;
import jalview.bin.argparser.ArgValue;
import jalview.bin.argparser.ArgValuesMap;
import jalview.bin.argparser.StructuresFile;
import jalview.bin.argparser.SubVals;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.Desktop;
import jalview.gui.StructureChooser;
import jalview.gui.StructureViewer;
import jalview.io.AppletFormatAdapter;
import jalview.io.BioJsHTMLOutput;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatException;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileLoader;
import jalview.io.HtmlSvgOutput;
import jalview.io.IdentifyFile;
import jalview.io.NewickFile;
import jalview.io.exceptions.ImageOutputException;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureSelectionManager;
import jalview.util.ColorUtils;
import jalview.util.FileUtils;
import jalview.util.HttpUtils;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.util.StringUtils;
import jalview.util.imagemaker.BitmapImageSizing;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;

public class Commands {
    Desktop desktop;
    private boolean headless;
    private ArgParser argParser;
    private Map<String, AlignFrame> afMap;
    private Map<String, StructureViewer> svMap = new HashMap<String, StructureViewer>();
    private boolean commandArgsProvided = false;
    private boolean argsWereParsed = false;
    private List<String> errors = new ArrayList<String>();
    private static final String PREVIOUSSTRUCTUREVIEWER = "previous";

    public Commands(ArgParser argparser, boolean headless) {
        this(Desktop.instance, argparser, headless);
    }

    public Commands(Desktop d, ArgParser argparser, boolean h) {
        this.argParser = argparser;
        this.headless = h;
        this.desktop = d;
        this.afMap = new HashMap<String, AlignFrame>();
    }

    protected boolean processArgs() {
        String errorsRaised;
        if (this.argParser == null) {
            return true;
        }
        boolean theseArgsWereParsed = false;
        if (this.argParser != null && this.argParser.getLinkedIds() != null) {
            for (String id : this.argParser.getLinkedIds()) {
                ArgValuesMap avm = this.argParser.getLinkedArgs(id);
                theseArgsWereParsed = true;
                boolean processLinkedOkay = this.processLinked(id);
                theseArgsWereParsed &= processLinkedOkay;
                this.processGroovyScript(id);
                AlignFrame af = this.afMap.get(id);
                while (af != null && af.getViewport().isCalcInProgress()) {
                    try {
                        Thread.sleep(25L);
                    }
                    catch (Exception exception) {}
                }
                theseArgsWereParsed &= this.processImages(id);
                if (processLinkedOkay) {
                    theseArgsWereParsed &= this.processOutput(id);
                }
                if (!avm.getBoolean(Arg.CLOSE) || (af = this.afMap.get(id)) == null) continue;
                af.closeMenuItem_actionPerformed(true);
            }
        }
        if ((errorsRaised = this.errorsToString()).trim().length() > 0) {
            Console.warn("The following errors and warnings occurred whilst processing files:\n" + errorsRaised);
        }
        if (this.argParser.getBoolean(Arg.QUIT)) {
            Jalview.exit("Exiting due to " + Arg.QUIT.argString() + " argument.", Jalview.ExitCode.OK);
            return true;
        }
        this.argsWereParsed = theseArgsWereParsed;
        return this.argsWereParsed;
    }

    public boolean commandArgsProvided() {
        return this.commandArgsProvided;
    }

    public boolean argsWereParsed() {
        return this.argsWereParsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processLinked(String id) {
        boolean theseArgsWereParsed = false;
        ArgValuesMap avm = this.argParser.getLinkedArgs(id);
        if (avm == null) {
            return true;
        }
        Boolean isError = false;
        boolean wrap = false;
        boolean showSSAnnotations = false;
        boolean showAnnotations = false;
        boolean hideTFrows = false;
        AlignFrame af = null;
        if (avm.containsArg(Arg.APPEND) || avm.containsArg(Arg.OPEN)) {
            this.commandArgsProvided = true;
            final long progress = System.currentTimeMillis();
            boolean first = true;
            boolean progressBarSet = false;
            ArrayList<ArgValue> openAvList = new ArrayList<ArgValue>();
            openAvList.addAll(avm.getArgValueList(Arg.OPEN));
            openAvList.addAll(avm.getArgValueList(Arg.APPEND));
            Collections.sort(openAvList);
            for (ArgValue av : openAvList) {
                Arg a = av.getArg();
                SubVals sv = av.getSubVals();
                String openFile0 = av.getValue();
                String openFile = HttpUtils.equivalentJalviewUrl(openFile0);
                if (openFile == null) continue;
                theseArgsWereParsed = true;
                if (first) {
                    first = false;
                    if (!this.headless && this.desktop != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Commands.this.desktop.setProgressBar(MessageManager.getString("status.processing_commandline_args"), progress);
                            }
                        });
                        progressBarSet = true;
                    }
                }
                if (!(Platform.isJS() || HttpUtils.isPlausibleUri(openFile) || new File(openFile).exists())) {
                    this.addError("Can't find file '" + openFile + "'");
                    isError = true;
                    continue;
                }
                DataSourceType protocol = AppletFormatAdapter.checkProtocol(openFile);
                FileFormatI format = null;
                try {
                    format = new IdentifyFile().identify(openFile, protocol);
                }
                catch (FileNotFoundException e0) {
                    this.addError((protocol == DataSourceType.URL ? "File at URL" : "File") + " '" + openFile + "' not found");
                    isError = true;
                    continue;
                }
                catch (FileFormatException e1) {
                    this.addError("Unknown file format for '" + openFile + "'");
                    isError = true;
                    continue;
                }
                af = this.afMap.get(id);
                if (af == null || "true".equals(av.getSubVal("new")) || a == Arg.OPEN || format == FileFormat.Jalview) {
                    String treefile;
                    String title;
                    if (a == Arg.OPEN) {
                        Jalview.testoutput(this.argParser, Arg.OPEN, "examples/uniref50.fa", openFile);
                    }
                    Console.debug("Opening '" + openFile + "' in new alignment frame");
                    FileLoader fileLoader = new FileLoader(!this.headless);
                    boolean xception = false;
                    try {
                        af = fileLoader.LoadFileWaitTillLoaded(openFile, protocol, format);
                        if (!openFile.equals(openFile0)) {
                            af.setTitle(openFile0);
                        }
                    }
                    catch (Throwable thr) {
                        xception = true;
                        this.addError("Couldn't open '" + openFile + "' as " + format + " " + thr.getLocalizedMessage() + " (Enable debug for full stack trace)");
                        isError = true;
                        Console.debug("Exception when opening '" + openFile + "'", thr);
                    }
                    finally {
                        if (af == null && !xception) {
                            this.addInfo("Ignoring '" + openFile + "' - no alignment data found.");
                            continue;
                        }
                    }
                    String colour = null;
                    if (avm.containsArg(Arg.COLOUR) || format != FileFormat.Jalview) {
                        colour = avm.getFromSubValArgOrPref(av, Arg.COLOUR, sv, null, "DEFAULT_COLOUR_PROT", null);
                    }
                    if (colour != null) {
                        this.colourAlignFrame(af, colour);
                    }
                    if ((title = avm.getFromSubValArgOrPref(av, Arg.TITLE, sv, null, null, null)) != null) {
                        af.setTitle(title);
                        Jalview.testoutput(this.argParser, Arg.TITLE, "test title", title);
                    }
                    List<String> featuresfiles = avm.getValuesFromSubValOrArgs(this.argParser, Arg.FEATURES, sv);
                    for (String string : featuresfiles) {
                        if (string == null) continue;
                        af.parseFeaturesFile(string, AppletFormatAdapter.checkProtocol(string));
                        Jalview.testoutput(this.argParser, Arg.FEATURES, "examples/testdata/plantfdx.features", string);
                    }
                    List<String> annotationsfiles = avm.getValuesFromSubValOrArgs(this.argParser, Arg.ANNOTATIONS, sv);
                    for (String annotationsfile : annotationsfiles) {
                        if (annotationsfile == null) continue;
                        af.loadJalviewDataFile(annotationsfile, null, null, null);
                        Jalview.testoutput(this.argParser, Arg.ANNOTATIONS, "examples/testdata/plantfdx.annotations", annotationsfile);
                    }
                    boolean bl = avm.getBoolFromSubValOrArg(Arg.SORTBYTREE, sv);
                    if (bl) {
                        af.getViewport().setSortByTree(true);
                        Jalview.testoutput(this.argParser, Arg.SORTBYTREE);
                    }
                    if ((treefile = avm.getValueFromSubValOrArg(av, Arg.TREE, sv)) != null) {
                        try {
                            NewickFile nf = new NewickFile(treefile, AppletFormatAdapter.checkProtocol(treefile));
                            af.getViewport().setCurrentTree(af.showNewickTree(nf, treefile).getTree());
                            Jalview.testoutput(this.argParser, Arg.TREE, "examples/testdata/uniref50_test_tree", treefile);
                        }
                        catch (IOException e) {
                            this.addError("Couldn't add tree " + treefile, e);
                            isError = true;
                        }
                    }
                    showSSAnnotations = avm.getFromSubValArgOrPref(Arg.SHOWSSANNOTATIONS, av.getSubVals(), null, "STRUCT_FROM_PDB", true);
                    showAnnotations = avm.getFromSubValArgOrPref(Arg.SHOWANNOTATIONS, av.getSubVals(), null, "SHOW_ANNOTATIONS", true);
                    hideTFrows = avm.getBoolean(Arg.NOTEMPFAC);
                    wrap = avm.getFromSubValArgOrPref(Arg.WRAP, sv, null, "WRAP_ALIGNMENT", false);
                    this.afMap.put(id, af);
                    if (format.isStructureFile()) {
                        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
                        SequenceI seq = af.alignPanel.getAlignment().getSequenceAt(0);
                        ssm.computeMapping(false, new SequenceI[]{seq}, null, openFile, DataSourceType.FILE, null, null, null, false);
                    }
                } else {
                    Console.debug("Opening '" + openFile + "' in existing alignment frame");
                    DataSourceType dst = HttpUtils.startsWithHttpOrHttps(openFile) ? DataSourceType.URL : DataSourceType.FILE;
                    FileLoader fileLoader = new FileLoader(!this.headless);
                    fileLoader.LoadFile(af.getCurrentView(), openFile, dst, null, false);
                }
                Console.debug("Command " + Arg.APPEND + " executed successfully!");
            }
            if (first) {
                if (this.headless) {
                    Jalview.exit("Could not open any files in headless mode", Jalview.ExitCode.NO_FILES);
                } else {
                    Console.info("No more files to open");
                }
            }
            if (progressBarSet && this.desktop != null) {
                this.desktop.setProgressBar(null, progress);
            }
        }
        if (!avm.getBoolean(Arg.NOSTRUCTURE)) {
            if (af == null) {
                af = this.afMap.get(id);
            }
            if (avm.containsArg(Arg.STRUCTURESFILE)) {
                String defaultViewerId = "STRUCTURESFILE VIEWER ";
                int viewerIdCount = 0;
                for (ArgValue structuresFileAV : avm.getArgValueList(Arg.STRUCTURESFILE)) {
                    ++viewerIdCount;
                    String structuresFilename = structuresFileAV.getValue();
                    AlignmentI al = af.getViewport().getAlignment();
                    StructuresFile sf = new StructuresFile(al, structuresFilename);
                    if (sf.getViewerid() == null) {
                        sf.setViewerid(defaultViewerId + viewerIdCount);
                    }
                    StructureViewer thisStructureViewer = null;
                    if (this.svMap.containsKey(sf.getViewerid())) {
                        thisStructureViewer = this.svMap.get(sf.getViewerid());
                    }
                    if (thisStructureViewer == null) {
                        StructureChooser sc = new StructureChooser(sf.getSeqs(), null, af.alignPanel, false, true);
                        thisStructureViewer = sc.launchStructureViewer(null, sf.getPdbEntries(), af.alignPanel, sf.getSeqs(), sf.getViewerType(), sf.isSuperpose());
                        thisStructureViewer.showAllChains();
                        if (sf.getViewerid() == null) continue;
                        this.svMap.put(sf.getViewerid(), thisStructureViewer);
                        continue;
                    }
                    thisStructureViewer.viewStructures(sf.getPdbEntries(), sf.getSeqs(), af.alignPanel, sf.getViewerType(), sf.isSuperpose());
                    thisStructureViewer.showAllChains();
                }
            }
            if (avm.containsArg(Arg.STRUCTURE)) {
                this.commandArgsProvided = true;
                String ALLSTRUCTURESVIEWERID = avm.getValue(Arg.ALLSTRUCTURESVIEWERID);
                Boolean SUPERPOSE = null;
                if (avm.containsArg(Arg.SUPERPOSE)) {
                    SUPERPOSE = avm.getBoolean(Arg.SUPERPOSE);
                }
                StructureViewer structureViewer = null;
                for (ArgValue structureAv : avm.getArgValueList(Arg.STRUCTURE)) {
                    StructureImportSettings.TFType tft;
                    String viewerid;
                    this.argParser.setStructureFilename(null);
                    String val = structureAv.getValue();
                    SubVals subVals = structureAv.getSubVals();
                    SequenceI seq = this.getSpecifiedSequence(af, avm, structureAv);
                    if (seq == null) {
                        AlignmentI al = af.getCurrentView().getAlignment();
                        seq = al.getSequenceAt(0);
                    }
                    if (seq == null) {
                        this.addWarn("Could not find sequence for argument " + Arg.STRUCTURE.argString() + "=" + val);
                        continue;
                    }
                    String structureLocationRef = null;
                    DataSourceType structureLocationType = null;
                    if (subVals.getContent() != null && subVals.getContent().length() != 0) {
                        structureLocationRef = subVals.getContent();
                        structureLocationType = AppletFormatAdapter.checkProtocol(structureLocationRef);
                        if (DataSourceType.FILE.equals((Object)structureLocationType)) {
                            structureLocationRef = new File(structureLocationRef).getAbsolutePath();
                        }
                        if (Console.isDebugEnabled()) {
                            Console.debug("Using structure file (from argument) '" + structureLocationRef + "' (protocol is " + structureLocationType);
                        }
                    }
                    if (structureLocationRef == null) {
                        this.addWarn("No provided structure file with '" + val + "'");
                        continue;
                    }
                    if (structureLocationType == null) {
                        this.addWarn("Could not determine structure fetch protocol for '" + val + "'");
                        continue;
                    }
                    this.argParser.setStructureFilename(structureLocationRef);
                    AlignmentPanel ap = af.alignPanel;
                    if (this.headless) {
                        Cache.setProperty("STRUCTURE_DISPLAY", StructureViewer.ViewerType.JMOL.toString());
                    }
                    if ((viewerid = ALLSTRUCTURESVIEWERID) == null) {
                        viewerid = avm.getFromSubValArgOrPrefWithSubstitutions(this.argParser, Arg.VIEWERID, ArgValuesMap.Position.AFTER, structureAv, subVals, null, null, null);
                    }
                    String paeFilepath = avm.getFromSubValArgOrPrefWithSubstitutions(this.argParser, Arg.PAEMATRIX, ArgValuesMap.Position.AFTER, structureAv, subVals, null, null, null);
                    boolean ssFromStructure = avm.getFromSubValArgOrPref(Arg.SHOWSSANNOTATIONS, subVals, null, "STRUCT_FROM_PDB", true);
                    String tftString = avm.getFromSubValArgOrPrefWithSubstitutions(this.argParser, Arg.TEMPFAC, ArgValuesMap.Position.AFTER, structureAv, subVals, null, null, null);
                    boolean notempfac = avm.getFromSubValArgOrPref(Arg.NOTEMPFAC, subVals, null, "ADD_TEMPFACT_ANN", false, true);
                    StructureImportSettings.TFType tFType = tft = notempfac ? null : StructureImportSettings.TFType.DEFAULT;
                    if (tftString != null && !notempfac) {
                        try {
                            tft = StructureImportSettings.TFType.valueOf(tftString.toUpperCase(Locale.ROOT));
                            Console.debug("Obtained Temperature Factor type of '" + tft + "' for structure '" + structureLocationRef + "'");
                        }
                        catch (IllegalArgumentException e) {
                            StringBuilder sb = new StringBuilder().append("Cannot set ").append(Arg.TEMPFAC.argString()).append(" to '").append((Object)tft).append("', ignoring.  Valid values are: ");
                            Iterator iterator = Arrays.stream(StructureImportSettings.TFType.values()).iterator();
                            while (iterator.hasNext()) {
                                sb.append(((StructureImportSettings.TFType)((Object)iterator.next())).toString().toLowerCase(Locale.ROOT));
                                if (!iterator.hasNext()) continue;
                                sb.append(", ");
                            }
                            this.addWarn(sb.toString());
                        }
                    }
                    boolean superpose = SUPERPOSE != null ? SUPERPOSE.booleanValue() : avm.getBoolFromSubVal(Arg.SUPERPOSE, subVals, Cache.getDefault("AUTOSUPERIMPOSE", true));
                    String sViewerType = avm.getFromSubValArgOrPref(Arg.STRUCTUREVIEWER, ArgValuesMap.Position.AFTER, structureAv, subVals, null, null, "jmol");
                    StructureViewer.ViewerType viewerType = StructureViewer.ViewerType.getFromString(sViewerType);
                    StructureViewer thisStructureViewer = null;
                    if (sViewerType.equals(PREVIOUSSTRUCTUREVIEWER) && structureViewer != null) {
                        thisStructureViewer = structureViewer;
                    } else if (viewerid != null && this.svMap.containsKey(viewerid)) {
                        thisStructureViewer = this.svMap.get(viewerid);
                    }
                    if (thisStructureViewer == null) {
                        thisStructureViewer = StructureChooser.openStructureForASequence(null, null, ap, seq, false, structureLocationRef, structureLocationType, tft, paeFilepath, false, ssFromStructure, false, viewerType);
                        if (viewerid != null) {
                            this.svMap.put(viewerid, thisStructureViewer);
                        }
                    } else {
                        thisStructureViewer.viewStructures(structureLocationRef, structureLocationType, seq, ap, false, tft, paeFilepath, false, ssFromStructure, false, superpose);
                        thisStructureViewer.showAllChains();
                    }
                    if ((structureViewer = thisStructureViewer) == null) {
                        if (StringUtils.equalsIgnoreCase(sViewerType, "none")) continue;
                        this.addError("Failed to import and open structure view for file '" + structureLocationRef + "'.");
                        continue;
                    }
                    try {
                        long tries = 1000L;
                        while (structureViewer.isBusy() && tries > 0L) {
                            Thread.sleep(25L);
                            if (!structureViewer.isBusy()) continue;
                            --tries;
                            Console.debug("Waiting for viewer for " + structureLocationRef);
                        }
                        if (tries == 0L && structureViewer.isBusy()) {
                            this.addWarn("Gave up waiting for structure viewer to load file '" + structureLocationRef + "'. Something may have gone wrong.");
                        }
                    }
                    catch (Exception x) {
                        this.addError("Exception whilst waiting for structure viewer " + structureLocationRef, x);
                        isError = true;
                    }
                    Console.debug("Successfully opened viewer for " + structureLocationRef);
                    if (avm.containsArg(Arg.STRUCTUREIMAGE)) {
                        for (ArgValue structureImageArgValue : avm.getArgValueListFromSubValOrArg(structureAv, Arg.STRUCTUREIMAGE, subVals)) {
                            ImageMaker.TYPE imageType;
                            String structureImageFilename = this.argParser.makeSubstitutions(structureImageArgValue.getValue(), id, true);
                            if (structureViewer == null || structureImageFilename == null) continue;
                            SubVals structureImageSubVals = null;
                            structureImageSubVals = structureImageArgValue.getSubVals();
                            File structureImageFile = new File(structureImageFilename);
                            String width = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.WIDTH, structureImageSubVals);
                            String height = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.HEIGHT, structureImageSubVals);
                            String scale = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.SCALE, structureImageSubVals);
                            String renderer = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.TEXTRENDERER, structureImageSubVals);
                            String typeS = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.TYPE, structureImageSubVals);
                            if (typeS == null || typeS.length() == 0) {
                                typeS = FileUtils.getExtension(structureImageFile);
                            }
                            try {
                                imageType = Enum.valueOf(ImageMaker.TYPE.class, typeS.toUpperCase(Locale.ROOT));
                            }
                            catch (IllegalArgumentException e) {
                                this.addWarn("Do not know image format '" + typeS + "', using PNG");
                                imageType = ImageMaker.TYPE.PNG;
                            }
                            BitmapImageSizing userBis = ImageMaker.parseScaleWidthHeightStrings(scale, width, height);
                            if (viewerType != StructureViewer.ViewerType.JMOL) {
                                this.addWarn("Cannot export image for structure viewer " + viewerType.name() + " yet");
                                continue;
                            }
                            String imageColour = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.IMAGECOLOUR, structureImageSubVals);
                            ColourSchemeI originalColourScheme = this.getColourScheme(af);
                            this.colourAlignFrame(af, imageColour);
                            String bgcolourstring = avm.getValueFromSubValOrArg(structureImageArgValue, Arg.BGCOLOUR, structureImageSubVals);
                            Color bgcolour = null;
                            if (bgcolourstring != null && bgcolourstring.length() > 0 && (bgcolour = ColorUtils.parseColourString(bgcolourstring)) == null) {
                                Console.warn("Background colour string '" + bgcolourstring + "' not recognised -- using default");
                            }
                            JalviewStructureDisplayI sview = structureViewer.getJalviewStructureDisplay();
                            File sessionToRestore = null;
                            ArrayList<StructureCommandI> extraCommands = new ArrayList<StructureCommandI>();
                            if (extraCommands.size() > 0 || bgcolour != null) {
                                try {
                                    sessionToRestore = sview.saveSession();
                                }
                                catch (Throwable t) {
                                    Console.warn("Unable to save temporary session file before custom structure view export operation.");
                                }
                            }
                            if (bgcolour != null) {
                                sview.getBinding().setBackgroundColour(bgcolour);
                            }
                            sview.getBinding().executeCommands(extraCommands, false, "Executing Custom Commands");
                            boolean success = this.checksBeforeWritingToFile(avm, subVals, false, structureImageFilename, "structure image", isError);
                            if (!success) continue;
                            Console.debug("Rendering image to " + structureImageFile);
                            try {
                                AppJmol jmol = (AppJmol)sview;
                                jmol.makePDBImage(structureImageFile, imageType, renderer, userBis);
                                Console.info("Exported structure image to " + structureImageFile);
                                if (sessionToRestore == null) continue;
                                Console.debug("Restoring session from " + sessionToRestore);
                                sview.getBinding().restoreSession(sessionToRestore.getAbsolutePath());
                            }
                            catch (ImageOutputException ioexec) {
                                this.addError("Unexpected error when restoring structure viewer session after custom view operations.");
                                isError = true;
                            }
                            finally {
                                try {
                                    this.colourAlignFrame(af, originalColourScheme);
                                }
                                catch (Exception t) {
                                    this.addError("Unexpected error when restoring colourscheme to alignment after temporary change for export.", t);
                                }
                            }
                        }
                    }
                    this.argParser.setStructureFilename(null);
                }
            }
        }
        if (af == null) {
            af = this.afMap.get(id);
        }
        if (this.headless) {
            af.showOrHideAnnotations(showSSAnnotations, showAnnotations, hideTFrows);
        } else {
            try {
                AlignFrame _af = af;
                boolean _showSSAnnotations = showSSAnnotations;
                boolean _showAnnotations = showAnnotations;
                boolean _hideTFrows = hideTFrows;
                SwingUtilities.invokeAndWait(() -> _af.showOrHideAnnotations(_showSSAnnotations, _showAnnotations, _hideTFrows));
            }
            catch (Exception x) {
                Console.warn("Unexpected exception adjusting annotation row visibility.", x);
            }
        }
        if (wrap) {
            if (af == null) {
                af = this.afMap.get(id);
            }
            if (af != null) {
                af.setWrapFormat(wrap, true);
            }
        }
        return theseArgsWereParsed && isError == false;
    }

    protected void processGroovyScript(String id) {
        ArgValuesMap avm = this.argParser.getLinkedArgs(id);
        AlignFrame af = this.afMap.get(id);
        if (avm != null && !avm.containsArg(Arg.GROOVY)) {
            return;
        }
        if (af == null) {
            this.addWarn("Groovy script does not have an alignment window.  Proceeding with caution!");
        }
        if (avm.containsArg(Arg.GROOVY)) {
            for (ArgValue groovyAv : avm.getArgValueList(Arg.GROOVY)) {
                String groovyscript = groovyAv.getValue();
                if (groovyscript == null) continue;
                Console.info("Executing script " + groovyscript);
                Jalview.getInstance().executeGroovyScript(groovyscript, af);
            }
        }
    }

    protected boolean processImages(String id) {
        ArgValuesMap avm = this.argParser.getLinkedArgs(id);
        AlignFrame af = this.afMap.get(id);
        if (avm != null && !avm.containsArg(Arg.IMAGE)) {
            return true;
        }
        if (af == null) {
            this.addWarn("Do not have an alignment window to create image from (id=" + id + ").  Not proceeding.");
            return false;
        }
        Boolean isError = false;
        if (avm.containsArg(Arg.IMAGE)) {
            for (ArgValue imageAv : avm.getArgValueList(Arg.IMAGE)) {
                String val = imageAv.getValue();
                SubVals imageSubVals = imageAv.getSubVals();
                String fileName = imageSubVals.getContent();
                File file = new File(fileName);
                String name = af.getName();
                String renderer = avm.getValueFromSubValOrArg(imageAv, Arg.TEXTRENDERER, imageSubVals);
                if (renderer == null) {
                    renderer = "text";
                }
                String type = "png";
                String scale = avm.getValueFromSubValOrArg(imageAv, Arg.SCALE, imageSubVals);
                String width = avm.getValueFromSubValOrArg(imageAv, Arg.WIDTH, imageSubVals);
                String height = avm.getValueFromSubValOrArg(imageAv, Arg.HEIGHT, imageSubVals);
                BitmapImageSizing userBis = ImageMaker.parseScaleWidthHeightStrings(scale, width, height);
                type = avm.getValueFromSubValOrArg(imageAv, Arg.TYPE, imageSubVals);
                if (type == null && fileName != null) {
                    for (String ext : new String[]{"svg", "png", "html", "eps"}) {
                        if (!fileName.toLowerCase(Locale.ROOT).endsWith("." + ext)) continue;
                        type = ext;
                    }
                }
                Cache.setPropsAreReadOnly(true);
                Cache.setProperty("EXPORT_EMBBED_BIOJSON", "false");
                String imageColour = avm.getValueFromSubValOrArg(imageAv, Arg.IMAGECOLOUR, imageSubVals);
                ColourSchemeI originalColourScheme = this.getColourScheme(af);
                this.colourAlignFrame(af, imageColour);
                Console.info("Writing " + file);
                boolean success = this.checksBeforeWritingToFile(avm, imageSubVals, false, fileName, "image", isError);
                if (!success) continue;
                try {
                    switch (type) {
                        case "svg": {
                            Console.debug("Outputting type '" + type + "' to " + fileName);
                            af.createSVG(file, renderer);
                            break;
                        }
                        case "png": {
                            Console.debug("Outputting type '" + type + "' to " + fileName);
                            af.createPNG(file, null, userBis);
                            break;
                        }
                        case "html": {
                            Console.debug("Outputting type '" + type + "' to " + fileName);
                            HtmlSvgOutput htmlSVG = new HtmlSvgOutput(af.alignPanel);
                            htmlSVG.exportHTML(fileName, renderer);
                            break;
                        }
                        case "biojs": {
                            Console.debug("Outputting BioJS MSA Viwer HTML file: " + fileName);
                            try {
                                BioJsHTMLOutput.refreshVersionInfo(BioJsHTMLOutput.BJS_TEMPLATES_LOCAL_DIRECTORY);
                            }
                            catch (URISyntaxException e) {
                                e.printStackTrace();
                            }
                            BioJsHTMLOutput bjs = new BioJsHTMLOutput(af.alignPanel);
                            bjs.exportHTML(fileName);
                            break;
                        }
                        case "eps": {
                            Console.debug("Outputting EPS file: " + fileName);
                            af.createEPS(file, renderer);
                            break;
                        }
                        case "imagemap": {
                            Console.debug("Outputting ImageMap file: " + fileName);
                            af.createImageMap(file, name);
                            break;
                        }
                        default: {
                            this.addWarn(Arg.IMAGE.argString() + " type '" + type + "' not known. Ignoring");
                            break;
                        }
                    }
                }
                catch (Exception ioex) {
                    this.addError("Unexpected error during export to '" + fileName + "'", ioex);
                    isError = true;
                }
                this.colourAlignFrame(af, originalColourScheme);
            }
        }
        return isError == false;
    }

    protected boolean processOutput(String id) {
        ArgValuesMap avm = this.argParser.getLinkedArgs(id);
        AlignFrame af = this.afMap.get(id);
        if (avm != null && !avm.containsArg(Arg.OUTPUT)) {
            return true;
        }
        if (af == null) {
            this.addWarn("Do not have an alignment window (id=" + id + ").  Not proceeding.");
            return false;
        }
        Boolean isError = false;
        if (avm.containsArg(Arg.OUTPUT)) {
            for (ArgValue av : avm.getArgValueList(Arg.OUTPUT)) {
                boolean success;
                String val = av.getValue();
                SubVals subVals = av.getSubVals();
                String fileName = subVals.getContent();
                boolean stdout = "-".equals(fileName);
                File file = new File(fileName);
                String name = af.getName();
                String format = avm.getValueFromSubValOrArg(av, Arg.FORMAT, subVals);
                FileFormats ffs = FileFormats.getInstance();
                List<String> validFormats = ffs.getWritableFormats(false);
                FileFormatI ff = null;
                if (format == null && fileName != null) {
                    block1: for (String string : validFormats) {
                        String[] extensions;
                        FileFormatI tff = ffs.forName(string);
                        for (String ext : extensions = tff.getExtensions().split(",")) {
                            if (!fileName.toLowerCase(Locale.ROOT).endsWith("." + ext)) continue;
                            ff = tff;
                            format = ff.getName();
                            break block1;
                        }
                    }
                }
                if (ff == null && format != null) {
                    ff = ffs.forName(format);
                }
                if (ff == null) {
                    if (stdout) {
                        ff = FileFormat.Fasta;
                    } else {
                        StringBuilder validSB = new StringBuilder();
                        for (String f : validFormats) {
                            if (validSB.length() > 0) {
                                validSB.append(", ");
                            }
                            validSB.append(f);
                            FileFormatI tff = ffs.forName(f);
                            validSB.append(" (");
                            validSB.append(tff.getExtensions());
                            validSB.append(")");
                        }
                        this.addError("No valid format specified for " + Arg.OUTPUT.argString() + ". Valid formats are " + validSB.toString() + ".");
                        continue;
                    }
                }
                if (!(success = this.checksBeforeWritingToFile(avm, subVals, true, fileName, ff.getName(), isError))) continue;
                boolean bl = avm.getFromSubValArgOrPref(Arg.BACKUPS, subVals, null, Platform.isHeadless() ? null : "BACKUPFILES_ENABLED", !Platform.isHeadless());
                Console.info("Writing " + fileName);
                af.saveAlignment(fileName, ff, stdout, bl);
                if (af.isSaveAlignmentSuccessful()) {
                    Console.debug("Written alignment '" + name + "' in " + ff.getName() + " format to '" + file + "'");
                    continue;
                }
                this.addError("Error writing file '" + file + "' in " + ff.getName() + " format!");
                isError = true;
            }
        }
        return isError == false;
    }

    private SequenceI getSpecifiedSequence(AlignFrame af, ArgValuesMap avm, ArgValue av) {
        SubVals subVals = av.getSubVals();
        ArgValue idAv = avm.getClosestNextArgValueOfArg(av, Arg.SEQID, true);
        SequenceI seq = null;
        if (subVals == null && idAv == null) {
            return null;
        }
        if (af == null || af.getCurrentView() == null) {
            return null;
        }
        AlignmentI al = af.getCurrentView().getAlignment();
        if (al == null) {
            return null;
        }
        if (subVals != null) {
            if (subVals.has(Arg.SEQID.getName())) {
                seq = al.findName(subVals.get(Arg.SEQID.getName()));
            } else if (-1 < subVals.getIndex() && subVals.getIndex() < al.getSequences().size()) {
                seq = al.getSequenceAt(subVals.getIndex());
            }
        }
        if (seq == null && idAv != null) {
            seq = al.findName(idAv.getValue());
        }
        return seq;
    }

    public AlignFrame[] getAlignFrames() {
        AlignFrame[] afs = null;
        if (this.afMap != null) {
            afs = (AlignFrame[])this.afMap.values().toArray();
        }
        return afs;
    }

    private void colourAlignFrame(AlignFrame af, String colour) {
        if (colour != null && "" != colour) {
            ColourSchemeI cs = ColourSchemeProperty.getColourScheme(af.getViewport(), af.getViewport().getAlignment(), colour);
            if (cs == null && !StringUtils.equalsIgnoreCase(colour, "none")) {
                this.addWarn("Couldn't parse '" + colour + "' as a colourscheme.");
            } else {
                Jalview.testoutput(this.argParser, Arg.COLOUR, "zappo", colour);
                this.colourAlignFrame(af, cs);
            }
        }
    }

    private void colourAlignFrame(final AlignFrame af, final ColourSchemeI cs) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    af.changeColour(cs);
                }
            });
        }
        catch (Exception x) {
            Console.trace("Interrupted whilst waiting for colorAlignFrame action", x);
        }
    }

    private ColourSchemeI getColourScheme(AlignFrame af) {
        return af.getViewport().getGlobalColourScheme();
    }

    private void addInfo(String errorMessage) {
        Console.info(errorMessage);
        this.errors.add(errorMessage);
    }

    private void addWarn(String errorMessage) {
        Console.warn(errorMessage);
        this.errors.add(errorMessage);
    }

    private void addError(String errorMessage) {
        this.addError(errorMessage, null);
    }

    private void addError(String errorMessage, Exception e) {
        Console.error(errorMessage, e);
        this.errors.add(errorMessage);
    }

    private boolean checksBeforeWritingToFile(ArgValuesMap avm, SubVals subVal, boolean includeBackups, String filename, String adjective, Boolean isError) {
        File file = new File(filename);
        boolean overwrite = avm.getFromSubValArgOrPref(Arg.OVERWRITE, subVal, null, "OVERWRITE_OUTPUT", false);
        boolean stdout = false;
        boolean backups = false;
        if (includeBackups) {
            stdout = "-".equals(filename);
            backups = avm.getFromSubValArgOrPref(Arg.BACKUPS, subVal, null, Platform.isHeadless() ? null : "BACKUPFILES_ENABLED", !Platform.isHeadless());
        }
        if (file.exists() && !overwrite && !backups && !stdout) {
            this.addWarn("Won't overwrite file '" + filename + "' without " + Arg.OVERWRITE.argString() + (String)(includeBackups ? " or " + Arg.BACKUPS.argString() : "") + " set");
            return false;
        }
        boolean mkdirs = avm.getFromSubValArgOrPref(Arg.MKDIRS, subVal, null, "MKDIRS_OUTPUT", false);
        if (!FileUtils.checkParentDir(file, mkdirs)) {
            this.addError("Directory '" + FileUtils.getParentDir(file).getAbsolutePath() + "' does not exist for " + adjective + " file '" + filename + "'." + (String)(mkdirs ? "" : "  Try using " + Arg.MKDIRS.argString()));
            isError = true;
            return false;
        }
        return true;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public String errorsToString() {
        StringBuilder sb = new StringBuilder();
        for (String error : this.errors) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("- " + error);
        }
        return sb.toString();
    }
}

