/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.Connectivity;
import jalview.analysis.ccAnalysis;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.api.analysis.ScoreModelI;
import jalview.bin.Console;
import jalview.datamodel.Point;
import jalview.datamodel.SequenceI;
import jalview.gui.PairwiseAlignPanel;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.viewmodel.AlignmentViewport;
import java.io.PrintStream;

public class PaSiMap
implements Runnable {
    private final AlignmentViewport seqs;
    private final ScoreMatrix scoreMatrix;
    private final byte dim = (byte)8;
    private final int openCost = 100;
    private final int extendCost = 5;
    private final PairwiseAlignPanel alignment;
    private boolean cancelled = false;
    private MatrixI pairwiseScores;
    private MatrixI eigenMatrix;
    private volatile boolean canCancel;

    public PaSiMap(AlignmentViewport sequences, ScoreModelI sm, PairwiseAlignPanel pap) {
        this.seqs = sequences;
        this.scoreMatrix = sm != null && sm instanceof ScoreMatrix ? (ScoreMatrix)sm : null;
        this.alignment = pap;
    }

    public double getEigenvalue(int i) {
        return this.eigenMatrix.getD()[i];
    }

    public Point[] getComponents(int l, int n, int mm, float factor) {
        Point[] out = new Point[this.getHeight()];
        for (int i = 0; i < out.length; ++i) {
            float x = (float)this.component(i, l) * factor;
            float y = (float)this.component(i, n) * factor;
            float z = (float)this.component(i, mm) * factor;
            out[i] = new Point(x, y, z);
        }
        return out;
    }

    public double[] component(int n) {
        double[] out = new double[this.getWidth()];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.component(n, i);
        }
        return out;
    }

    double component(int row, int n) {
        return this.eigenMatrix.getValue(row, n);
    }

    public String getDetails() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("PaSiMap calculation using ").append(this.scoreMatrix.getName()).append(" sequence similarity matrix\n========\n\n");
        PrintStream ps = this.wrapOutputBuffer(sb);
        sb.append(" --- Pairwise correlation coefficients ---\n");
        this.pairwiseScores.print(ps, "%8.6f ");
        ps.println();
        sb.append(" --- Eigenvalues ---\n");
        this.eigenMatrix.printD(ps, "%15.4e");
        ps.println();
        sb.append(" --- Coordinates ---\n");
        this.eigenMatrix.print(ps, "%8.6f ");
        ps.println();
        return sb.toString();
    }

    @Override
    public void run() {
        this.canCancel = true;
        try {
            this.alignment.calculate(this.scoreMatrix);
            if (this.alignment.isCancelled()) {
                this.cancel();
                return;
            }
            float[][] scores = this.alignment.getAlignmentScores();
            SequenceI[] iseqs = this.alignment.getInputSequences();
            Connectivity.getConnectivity(iseqs, scores, (byte)8);
            this.canCancel = false;
            this.alignment.updateProgress("message_in_progress", "Creating the PaSiMap");
            this.pairwiseScores = new Matrix(scores);
            this.pairwiseScores.fillDiagonal();
            this.eigenMatrix = this.pairwiseScores.copy();
            ccAnalysis cc = new ccAnalysis(this.pairwiseScores, 8);
            this.eigenMatrix = cc.run().mirrorCol();
            this.alignment.updateProgress("finished_stop_progress", "Finished PaSiMap.");
        }
        catch (Exception q) {
            Console.error("Error computing PaSiMap:  " + q.getMessage());
            q.printStackTrace();
        }
    }

    public void cancel() {
        if (this.alignment != null) {
            this.alignment.cancel();
        }
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    protected PrintStream wrapOutputBuffer(final StringBuilder sb) {
        PrintStream ps = new PrintStream(System.out){

            @Override
            public void print(String x) {
                sb.append(x);
            }

            @Override
            public void println() {
                sb.append("\n");
            }
        };
        return ps;
    }

    public int getHeight() {
        return this.eigenMatrix.height();
    }

    public int getWidth() {
        return this.eigenMatrix.width();
    }

    public MatrixI getPairwiseScores() {
        return this.pairwiseScores;
    }

    public void setPairwiseScores(MatrixI m) {
        this.pairwiseScores = m;
    }

    public MatrixI getEigenmatrix() {
        return this.eigenMatrix;
    }

    public void setEigenmatrix(MatrixI m) {
        this.eigenMatrix = m;
    }

    public PairwiseAlignPanel getAlignments() {
        return this.alignment;
    }

    public String getAlignmentOutput() {
        return this.alignment.getAlignmentOutput();
    }

    public byte getDim() {
        return 8;
    }

    public boolean isCancellable() {
        return this.canCancel;
    }
}

