/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.Metadata;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MetadataHelper {
    static <T> List<Option<T>> getParametersList(Metadata<T> msaws) {
        assert (msaws != null);
        RunnerConfig<T> config = msaws.getRunnerOptions();
        if (config == null) {
            return Collections.emptyList();
        }
        return config.getArguments();
    }

    static <T> List<Option<T>> getParametersList(Metadata<T> msaws, String host) throws MalformedURLException {
        assert (msaws != null);
        RunnerConfig<T> config = msaws.getRunnerOptions();
        if (config == null) {
            return Collections.emptyList();
        }
        List<Option<T>> opts = config.getArguments();
        for (Option<T> o : opts) {
            o.setBasicURL(new URL(host + "/"));
        }
        return opts;
    }

    static <T> PresetManager<T> getPresetList(Metadata<T> msaws) {
        assert (msaws != null);
        PresetManager<T> presetman = msaws.getPresets();
        return presetman;
    }

    static <T> List<Limit<T>> getLimits(Metadata<T> msaws) {
        assert (msaws != null);
        LimitsManager<T> lmanger = msaws.getLimits();
        return lmanger != null ? lmanger.getLimits() : null;
    }

    static <T> Preset<T> getPreset(Metadata<T> msaws, String presetName) {
        assert (presetName != null);
        PresetManager<T> presets = MetadataHelper.getPresetList(msaws);
        if (presets == null) {
            System.out.println("No presets are supported by the service! Ignoring -r directive!");
            return null;
        }
        Preset<T> pre = presets.getPresetByName(presetName);
        if (pre == null) {
            System.out.println("Cannot find preset: " + presetName + " WARN: ignoring -r directive!");
        }
        return pre;
    }

    static <T> List<Option<T>> processParameters(List<String> params, RunnerConfig<T> options) {
        ArrayList<Option<T>> chosenOptions = new ArrayList<Option<T>>();
        for (String param : params) {
            String oname = null;
            oname = MetadataHelper.isParameter(param) ? MetadataHelper.getParamName(param) : param;
            Option<T> o = options.getArgumentByOptionName(oname);
            if (o == null) {
                System.out.println("WARN ignoring unsuppoted parameter: " + oname);
                continue;
            }
            if (MetadataHelper.isParameter(param)) {
                try {
                    o.setValue(MetadataHelper.getParamValue(param));
                }
                catch (WrongParameterException e) {
                    System.out.println("Problem setting value for the parameter: " + param);
                    e.printStackTrace();
                }
            }
            chosenOptions.add(o);
        }
        return chosenOptions;
    }

    static String getParamName(String fullName) {
        assert (MetadataHelper.isParameter(fullName));
        return fullName.substring(0, fullName.indexOf("="));
    }

    static String getParamValue(String fullName) {
        assert (MetadataHelper.isParameter(fullName));
        return fullName.substring(fullName.indexOf("=") + 1);
    }

    static boolean isParameter(String param) {
        return param.contains("=");
    }
}

