/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.JABAService;
import compbio.data.msa.Metadata;
import compbio.data.msa.MsaWS;
import compbio.data.msa.RegistryWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.AlignmentMetadata;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.util.FileUtil;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.client.Services;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class Jws2Client {
    private static final Logger log = Logger.getLogger(Jws2Client.class.getCanonicalName());

    public static boolean validURL(String urlstr) {
        try {
            if (urlstr == null || urlstr.trim().length() == 0) {
                return false;
            }
            new URL(urlstr);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    <T> Jws2Client(String[] cmd) throws IOException {
        Services service;
        String serviceName;
        boolean listServices;
        String hostname = CmdHelper.getHost(cmd);
        if (hostname == null) {
            System.err.println("Host name is not provided!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (!Jws2Client.validURL(hostname)) {
            System.err.println("Host name is not valid!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (listServices = CmdHelper.listServices(cmd)) {
            Jws2Client.listAllServices(hostname);
            System.exit(0);
        }
        if ((serviceName = CmdHelper.getServiceName(cmd)) == null) {
            System.err.println("Service name is no provided!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if ((service = Services.getService(serviceName)) == null) {
            String mess = "Service " + serviceName + " is no available! Valid values are: ";
            System.err.println(mess + Arrays.toString((Object[])Services.values()));
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (CmdHelper.testService(cmd)) {
            Jws2Client.testService(hostname, service, new PrintWriter(System.out, true));
            System.exit(0);
        }
        Metadata thews = (Metadata)((Object)Jws2Client.connect(hostname, service));
        Preset preset = null;
        if (null != CmdHelper.getPresetName(cmd)) {
            preset = MetadataHelper.getPreset(thews, CmdHelper.getPresetName(cmd));
        }
        List customOptions = null;
        if (null != IOHelper.getFile(cmd, "-f", true)) {
            List<String> prms = IOHelper.loadParameters(IOHelper.getFile(cmd, "-f", true));
            customOptions = MetadataHelper.processParameters(prms, thews.getRunnerOptions());
        }
        if (null != IOHelper.getFile(cmd, "-i", true)) {
            void var11_14;
            File infile = IOHelper.getFile(cmd, "-i", true);
            File outfile = IOHelper.getFile(cmd, "-o", false);
            Object var11_11 = null;
            if (outfile != null) {
                Writer writer = IOHelper.getWriter(outfile);
            } else {
                PrintWriter printWriter = new PrintWriter(System.out, true);
            }
            if (service.getServiceType() == SequenceAnnotation.class) {
                ScoreManager result = Jws2Client.analize(infile, (SequenceAnnotation)thews, preset, customOptions);
                IOHelper.writeOut((Writer)var11_14, result);
                var11_14.close();
            } else if (service.getServiceType() == MsaWS.class) {
                Alignment alignment = Jws2Client.align(infile, (MsaWS)thews, preset, customOptions);
                IOHelper.writeOut((Writer)var11_14, alignment);
                var11_14.close();
                AlignmentMetadata md = alignment.getMetadata();
                System.out.println("Output has been prepared with " + (Object)((Object)md.getProgram()));
            }
        }
        if (CmdHelper.listParameters(cmd)) {
            List opts = MetadataHelper.getParametersList(thews, hostname);
            for (Option option : opts) {
                System.out.println("##############################################################################\n" + option.toString());
            }
        }
        if (CmdHelper.listPresets(cmd)) {
            PresetManager psm = MetadataHelper.getPresetList(thews);
            if (null != psm) {
                System.out.print(psm);
            } else {
                System.out.println("No presets are defined for the Web service");
            }
        }
        if (CmdHelper.listLimits(cmd)) {
            List lims = MetadataHelper.getLimits(thews);
            for (Limit limit : lims) {
                System.out.println("##############################################################################\n" + limit.toString());
            }
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)thews)).close();
        log.fine("Disconnected successfully!");
    }

    public static JABAService connect(String host, Services service) throws WebServiceException, ConnectException {
        URL url = null;
        log.log(Level.FINE, "Attempting to connect with " + service.toString() + "...");
        System.out.println("Attempting to connect with " + service.toString() + "...");
        try {
            url = new URL(host + "/" + service.toString() + "?wsdl");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Service serv = null;
        try {
            serv = service.getService(url, service.getServiceNamespace());
        }
        catch (WebServiceException wse) {
            wse.printStackTrace();
        }
        if (serv == null) {
            throw new ConnectException("Could not connect to " + url + ". Is the server down?");
        }
        JABAService serviceIF = service.getInterface(serv);
        log.log(Level.INFO, "Connected successfully!");
        return serviceIF;
    }

    public static RegistryWS connectToRegistry(String host) throws WebServiceException, ConnectException {
        URL url = null;
        String service = "RegistryWS";
        log.log(Level.FINE, "Attempting to connect...");
        try {
            url = new URL(host + "/" + service + "?wsdl");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        QName qname = new QName("http://msa.data.compbio/01/12/2010/", service);
        Service serv = Service.create(url, (QName)qname);
        if (serv == null) {
            throw new ConnectException("Could not connect to " + url + ". Is the server down?");
        }
        QName portName = new QName(serv.getServiceName().getNamespaceURI(), service + "Port");
        RegistryWS serviceIF = (RegistryWS)serv.getPort(portName, RegistryWS.class);
        log.log(Level.INFO, "Connected to " + service + " successfully!");
        return serviceIF;
    }

    public static void testService(String hostname, Services service, PrintWriter writer) throws ConnectException, WebServiceException {
        RegistryWS registry = Jws2Client.connectToRegistry(hostname);
        if (registry != null) {
            String message = registry.testService(service);
            writer.println("Service " + (Object)((Object)service) + " testing results: ");
            writer.println(message);
            FileUtil.closeSilently((Closeable)((Object)registry));
        }
        writer.flush();
    }

    private static void listAllServices(String hostname) throws WebServiceException, IOException {
        RegistryWS registry = Jws2Client.connectToRegistry(hostname);
        Set<Object> func_services = Collections.emptySet();
        if (registry == null) {
            System.out.println("Failed to connect to the registry! ");
            return;
        }
        func_services = registry.getSupportedServices();
        FileUtil.closeSilently((Closeable)((Object)registry));
        if (!func_services.isEmpty()) {
            System.out.println("There are " + func_services.size() + " services at " + hostname + ":");
            String mess = "\n\rThe list:\n";
            System.out.println(mess + Services.toString(func_services));
        }
    }

    static <T> ScoreManager analize(List<FastaSequence> fastalist, SequenceAnnotation<T> wsproxy, Preset<T> preset, List<Option<T>> customOptions) {
        ScoreManager scores = null;
        try {
            String jobId = null;
            if (customOptions != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            jobId = customOptions != null ? wsproxy.customAnalize(fastalist, customOptions) : (preset != null ? wsproxy.presetAnalize(fastalist, preset) : wsproxy.analize(fastalist));
            System.out.println("\n\rcalling predictor.........");
            Thread.sleep(1000L);
            scores = wsproxy.getAnnotation(jobId);
        }
        catch (JobSubmissionException e) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            e.printStackTrace();
        }
        catch (ResultNotAvailableException e) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("Exception while waiting for results. Exception details are below:");
            e.printStackTrace();
        }
        catch (WrongParameterException e) {
            String mess = "Parsing the web method input parameters failed Exception details are below:";
            System.err.println(mess);
            e.printStackTrace();
        }
        return scores;
    }

    static <T> ScoreManager analize(File file, SequenceAnnotation<T> wsproxy, Preset<T> preset, List<Option<T>> customOptions) {
        List<FastaSequence> fastalist = null;
        try {
            fastalist = SequenceUtil.openInputStream(file.getAbsolutePath());
            assert (!fastalist.isEmpty()) : "Input is empty!";
        }
        catch (IOException e) {
            String mess = "Reading the input file failed. Check that the file contains a list of FASTA records!\n";
            System.err.println(mess + "Exception details are below:");
            e.printStackTrace();
        }
        catch (UnknownFileFormatException e) {
            String mess = "Reading the input file failed. Exception details are below:";
            System.err.println(mess);
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return Jws2Client.analize(fastalist, wsproxy, preset, customOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Alignment align(File file, MsaWS<T> msaws, Preset<T> preset, List<Option<T>> customOptions) {
        FileInputStream instream = null;
        Alignment alignment = null;
        try {
            instream = new FileInputStream(file);
            List<FastaSequence> fastalist = SequenceUtil.readFasta(instream);
            instream.close();
            String jobId = null;
            if (customOptions != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            jobId = customOptions != null ? msaws.customAlign(fastalist, customOptions) : (preset != null ? msaws.presetAlign(fastalist, preset) : msaws.align(fastalist));
            System.out.println("\ncalling program.........");
            Thread.sleep(1000L);
            alignment = msaws.getResult(jobId);
        }
        catch (IOException e) {
            System.err.println("Exception while reading the input file. Check that the input file is a FASTA file! Exception details are below:");
            e.printStackTrace();
        }
        catch (JobSubmissionException e) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            e.printStackTrace();
        }
        catch (ResultNotAvailableException e) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            e.printStackTrace();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException e) {
            e.printStackTrace();
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e) {}
            }
        }
        return alignment;
    }

    public static void main(String[] args) {
        if (args == null) {
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        if (args.length < 2) {
            System.err.println("Host (-h=<host>, e.g. -h=http://www.compbio.dundee.ac.uk/jabaws) and service (-s=<ServiceName>, e.g. -s=MafftWS) are required!");
            System.out.println("\r\nUsage: java -jar <JAR file name> -h=host_and_context <-s=serviceName> ACTION [OPTIONS] \r\n\r\n       -h=<host_context> - a full URL to the JABAWS web server including context path e.g. http://10.31.1.159:8080/ws\r\n       -s=<ServiceName>  - a name of servise (the full list can be obtain with the option -list)\r\n                           <serviceName> is required for all ACTIONS except -list\r\n\r\nACTIONS: \r\n        -i=<inputFile>  - defines an input file. For most services this is a FASTA file with initial sequences\r\n        -list           - lists all available web services\r\n        -test           - tests functioning of <ServiceName> \r\n        -parameters     - lists parameters supported by <ServiceName>\r\n        -presets        - lists presets supported by <ServiceName>\r\n        -limits         - lists limits of <ServiceName>\r\n\r\nN.B. If an input file is specified with -i other actions are ignored!\r\n\r\nOPTIONS (used with the -i action only):\r\n        -r=<presetName>  - name of the preset to use\r\n        -o=<outputFile>  - file with output results\r\n        -f=<paramFile>   - file with the list of parameters to use.\r\n\r\nPlease note that -r and -f options cannot be used together. \r\nAlignment/Prediction is done with either preset or a parameters from the file, but not both!\r\n\r\nEXAMPLES: \r\n<THECLIENT> is java -jar <JAR file name>\r\n\r\n1) List all available services on the host:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -list\r\n\r\n2) Test Clustal web service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ClustalWS -test \r\n\r\n3) Align sequence from file input.txt with Probcons. Record resulting alignment \r\n   into the output.txt:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=ProbconsWS -i=input.txt -o=output.txt\r\n\r\n4) Calculate disorder with Disembl take input from input.txt with output results\r\n    to be printed out to the standard output:\r\n    <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=DisemblWS -i=input.txt \r\n\r\n5) List all parameters available for AAconWS service:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -parameters\r\n\r\n6) Calculate conservation with AAConWS using LANDGRAF method, for Clustal alignment \r\n   from input.txt and report the scores to the standard output:\r\n   <THECLIENT> -h=http://www.compbio.dundee.ac.uk/jabaws -s=AAconWS -i=input.txt -f=prm.txt \r\n\r\n   Where the content of prm.txt file is -m=LANDGRAF\r\nN.B. The list of the supported parameters can be obtained as shown in the example 5.\r\n");
            System.exit(1);
        }
        try {
            new Jws2Client(args);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException in client! " + e.getMessage(), e.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            e.printStackTrace();
        }
    }
}

