/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.data.sequence.FastaSequence;
import compbio.util.SysPrefs;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Limit<T> {
    private String preset;
    private int seqNumber;
    private int seqLength;
    @XmlAttribute
    boolean isDefault;

    private Limit() {
    }

    public Limit(int seqNumber, int seqLength, String preset) {
        if (seqNumber <= 0) {
            throw new IllegalArgumentException("seqNumber - a maximum number of sequences to align must be greater than 0. Value given:" + seqNumber);
        }
        if (seqLength < 0) {
            throw new IllegalArgumentException("seqLength - an average sequence length must be greater than 0. Value given:" + seqLength);
        }
        this.seqNumber = seqNumber;
        this.seqLength = seqLength;
        this.preset = preset;
        this.isDefault = false;
    }

    public Limit(int seqNumber, int seqLength, String preset, boolean isDefault) {
        this(seqNumber, seqNumber, preset);
        this.isDefault = isDefault;
    }

    public String getPreset() {
        return this.preset;
    }

    public int getAvgSeqLength() {
        return this.seqLength;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.preset == null ? 0 : this.preset.hashCode());
        result = 31 * result + this.seqLength;
        result = 31 * result + this.seqNumber;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Limit other = (Limit)obj;
        if (this.preset == null ? other.preset != null : !this.preset.equals(other.preset)) {
            return false;
        }
        if (this.seqLength != other.seqLength) {
            return false;
        }
        return this.seqNumber == other.seqNumber;
    }

    public String toString() {
        String value = "";
        value = this.isDefault ? "Default Limits:" + SysPrefs.newlinechar : "Limits for Preset '" + this.preset + "'" + SysPrefs.newlinechar;
        value = value + "Maximum sequence number=" + this.seqNumber + SysPrefs.newlinechar;
        value = value + "Average sequence length=" + this.seqLength + SysPrefs.newlinechar;
        return value;
    }

    long numberOfLetters() {
        return this.seqNumber * this.seqLength;
    }

    public boolean isExceeded(List<FastaSequence> data) {
        if (data == null) {
            throw new NullPointerException("List of fasta sequences is expected!");
        }
        if (data.size() > this.seqNumber) {
            return true;
        }
        return this.seqLength != 0 && data.size() > 0 && (long)Limit.getAvgSequenceLength(data) * (long)data.size() > this.numberOfLetters();
    }

    public static int getAvgSequenceLength(List<FastaSequence> data) {
        long length = 0L;
        for (FastaSequence seq : data) {
            length += (long)seq.getLength();
        }
        return (int)(length / (long)data.size());
    }

    void validate() {
        if (this.seqNumber < 1) {
            throw new AssertionError((Object)("Maximum number of sequences must be defined and be positive! Set value is: " + this.seqNumber));
        }
        if (this.seqLength != 0 && this.seqLength < 1) {
            throw new AssertionError((Object)("Average sequence length must be positive! Set value is: " + this.seqLength));
        }
    }
}

