/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.FastaSequence;
import compbio.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Scanner;

public class FastaReader
implements Iterator<FastaSequence> {
    private final Scanner input;
    private final String DELIM = ">";

    public FastaReader(String inputFile) throws FileNotFoundException {
        this.input = new Scanner(new File(inputFile), "UTF8");
        this.input.useDelimiter(">");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (FastaReader.this.input != null) {
                    FastaReader.this.input.close();
                }
            }
        });
    }

    public FastaReader(InputStream inputStream) throws FileNotFoundException {
        this.input = new Scanner(inputStream);
        this.input.useDelimiter(">");
    }

    @Override
    public boolean hasNext() {
        return this.input.hasNext();
    }

    @Override
    public FastaSequence next() {
        String fastaHeader = this.input.next();
        while (fastaHeader.indexOf("\n") < 0 && this.input.hasNext()) {
            fastaHeader = fastaHeader.concat(">");
            fastaHeader = fastaHeader.concat(this.input.next());
        }
        return FastaReader.toFastaSequence(fastaHeader);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.input.close();
    }

    private static FastaSequence toFastaSequence(String singleFastaEntry) {
        assert (!Util.isEmpty(singleFastaEntry)) : "Empty String where FASTA sequence is expected!";
        int nlineidx = singleFastaEntry.indexOf("\n");
        if (nlineidx < 0) {
            throw new AssertionError((Object)("The FASTA sequence must contain the header information separated by the new line from the sequence. Given sequence does not appear to contain the header! Given data:\n " + singleFastaEntry));
        }
        String header = singleFastaEntry.substring(0, nlineidx);
        header = header.replaceAll("\r", "");
        String sequence = singleFastaEntry.substring(nlineidx);
        if (Util.isEmpty(sequence)) {
            throw new AssertionError((Object)("Empty sequences are not allowed! Please make sure the  data is in the FASTA format! Given data:\n " + singleFastaEntry));
        }
        return new FastaSequence(header, sequence);
    }
}

