/*
 * Decompiled with CFR 0.152.
 */
package intervalstore.impl;

import intervalstore.impl.IntervalStore;
import intervalstore.impl.NCList;
import intervalstore.impl.Range;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(enabled=false)
public class TimingTests {
    static final int RANDOM_SEED = 732;
    static final int REPEATS = 10;
    static final int WARMUPS = 3;
    static final boolean LOG_RAW_DATA = false;
    private Random rand;
    private StringBuilder averages;

    @BeforeClass
    public void setUp() {
        this.rand = new Random(732L);
        this.averages = new StringBuilder(2345);
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println(String.valueOf(System.getProperty("os.arch")) + " " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "\n");
        System.out.println("Test\tsize N\titeration\tms\tN/ms\tms stderr\trate stderr");
    }

    @AfterClass
    public void tearDown() {
        System.out.println(this.averages.toString());
    }

    public void testLoadTime_nclist_bulkLoad() {
        int j = 1;
        while (j <= 5) {
            int count = j * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                NCList<Range> ncl = new NCList<Range>(ranges);
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                Assert.assertTrue((boolean)ncl.isValid());
                ++i;
            }
            this.logResults("NCList bulk load", count, data);
            ++j;
        }
    }

    protected List<Range> generateIntervals(Integer count) {
        return this.generateIntervals(count, 50);
    }

    private List<Range> generateIntervals(Integer count, int maxLength) {
        int maxPos = 4 * count;
        ArrayList<Range> ranges = new ArrayList<Range>();
        int j = 0;
        while (j < count) {
            int from = 1 + this.rand.nextInt(maxPos);
            int to = from + this.rand.nextInt(maxLength);
            ranges.add(new Range(from, to));
            ++j;
        }
        return ranges;
    }

    public void testLoadTime_nclist_incremental() {
        int j = 1;
        while (j <= 5) {
            int count = j * 100 * 1000;
            this.loadNclist(count, false, "NCList incr");
            ++j;
        }
    }

    public void testLoadTime_naiveList_bulkLoad() {
        int[] counts;
        int[] nArray = counts = new int[]{100000, 500000};
        int n = counts.length;
        int n2 = 0;
        while (n2 < n) {
            int count = nArray[n2];
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                ArrayList<Range> simple = new ArrayList<Range>();
                List<Range> ranges = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                simple.addAll(ranges);
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                ++i;
            }
            this.logResults("Naive bulk load", count, data);
            ++n2;
        }
    }

    public void testLoadTime_naiveList_noDuplicates() {
        int j = 0;
        while (j <= 100) {
            int count = 1000 * (100 + j);
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                ArrayList<Range> simple = new ArrayList<Range>();
                List<Range> ranges = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                for (Range r : ranges) {
                    if (simple.contains(r)) continue;
                    simple.addAll(ranges);
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                ++i;
            }
            this.logResults("Naive no duplicates", count, data);
            j += 10;
        }
    }

    public void testLoadTime_nclist_incrementalNoDuplicates() {
        int j = 1;
        while (j <= 5) {
            int count = j * 100 * 1000;
            this.loadNclist(count, true, "NCList no duplicates");
            ++j;
        }
    }

    private void loadNclist(Integer count, boolean allowDuplicates, String testName) {
        double[] data = new double[10];
        int i = 0;
        while (i < 13) {
            NCList<Range> ncl = new NCList<Range>();
            List<Range> ranges = this.generateIntervals(count);
            long now = System.currentTimeMillis();
            for (Range r : ranges) {
                if (!allowDuplicates && ncl.contains(r)) continue;
                ncl.add(r);
            }
            long elapsed = System.currentTimeMillis() - now;
            if (i >= 3) {
                data[i - 3] = elapsed;
            }
            Assert.assertTrue((boolean)ncl.isValid());
            ++i;
        }
        this.logResults(testName, count, data);
    }

    public void testQueryTime_nclist() {
        int k = 1;
        while (k <= 10) {
            int count = k * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count, 1);
                NCList<Range> ncl = new NCList<Range>(ranges);
                List<Range> queries = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                for (Range q : queries) {
                    ncl.findOverlaps(q.getBegin(), q.getEnd());
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                Assert.assertTrue((boolean)ncl.isValid());
                ++i;
            }
            this.logResults("NCList query", count, data);
            ++k;
        }
    }

    private void logResults(String testName, int count, double[] data) {
        double[] rate = new double[data.length];
        double totRate = 0.0;
        int i = 0;
        while (i < data.length) {
            rate[i] = data[i] == 0.0 ? 0.0 : (double)count / data[i];
            totRate += rate[i];
            ++i;
        }
        double totRaw = 0.0;
        int i2 = 0;
        while (i2 < data.length) {
            totRaw += data[i2];
            ++i2;
        }
        double mean = totRaw / (double)data.length;
        double stderr = this.standardError(data, mean);
        double rateMean = totRate / (double)data.length;
        double rateStderr = this.standardError(rate, rateMean);
        String line = String.format("%s\t%d\t%d\t%.1f\t%.1f\t%.2f\t%.2f", testName, count, 0, mean, rateMean, stderr, rateStderr);
        System.out.println(line);
    }

    public void testQueryTime_naive() {
        int j = 2;
        while (j <= 6) {
            int count = j * 10 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count);
                List<Range> queries = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                for (Range q : queries) {
                    this.findOverlaps(ranges, q);
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                ++i;
            }
            this.logResults("Naive query", count, data);
            ++j;
        }
    }

    private List<Range> findOverlaps(List<Range> ranges, Range query) {
        ArrayList<Range> result = new ArrayList<Range>();
        for (Range r : ranges) {
            if (!r.overlapsInterval(query)) continue;
            result.add(r);
        }
        return result;
    }

    private void loadIntervalStore(Integer count, boolean allowDuplicates, String testName) {
        double[] data = new double[10];
        int i = 0;
        while (i < 13) {
            IntervalStore<Range> ncl = new IntervalStore<Range>();
            List<Range> ranges = this.generateIntervals(count);
            long now = System.currentTimeMillis();
            for (Range r : ranges) {
                if (!allowDuplicates && ncl.contains(r)) continue;
                ncl.add(r);
            }
            long elapsed = System.currentTimeMillis() - now;
            if (i >= 3) {
                data[i - 3] = elapsed;
            }
            Assert.assertTrue((boolean)ncl.isValid());
            ++i;
        }
        this.logResults(testName, count, data);
    }

    public void testLoadTime_intervalstore_bulkLoad() {
        int j = 1;
        while (j <= 5) {
            int count = j * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                new IntervalStore<Range>(ranges);
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                ++i;
            }
            this.logResults("IntervalStore bulk load", count, data);
            ++j;
        }
    }

    public void testLoadTime_intervalstore_incremental() {
        int j = 1;
        while (j <= 5) {
            int count = j * 100 * 1000;
            this.loadIntervalStore(count, false, "IntervalStore incr");
            ++j;
        }
    }

    public void testLoadTime_intervalstore_incrementalNoDuplicates() {
        int j = 1;
        while (j <= 5) {
            int count = j * 100 * 1000;
            this.loadIntervalStore(count, true, "IntervalStore no duplicates");
            ++j;
        }
    }

    public void testQueryTime_intervalstore() {
        int k = 1;
        while (k <= 10) {
            int count = k * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count, 1);
                IntervalStore<Range> ncl = new IntervalStore<Range>(ranges);
                List<Range> queries = this.generateIntervals(count);
                long now = System.currentTimeMillis();
                for (Range q : queries) {
                    ncl.findOverlaps(q.getBegin(), q.getEnd());
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                Assert.assertTrue((boolean)ncl.isValid());
                ++i;
            }
            this.logResults("IntervalStore query", count, data);
            ++k;
        }
    }

    public void testRemoveTime_intervalstore() {
        int deleteCount = 1000;
        int k = 2;
        while (k <= 30) {
            int count = k * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count);
                IntervalStore<Range> ncl = new IntervalStore<Range>(ranges);
                long now = System.currentTimeMillis();
                int j = 0;
                while (j < 1000) {
                    Range toDelete = ranges.get(this.rand.nextInt(count));
                    ncl.remove(toDelete);
                    ++j;
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                Assert.assertTrue((boolean)ncl.isValid());
                ++i;
            }
            this.logResults("IntervalStore remove", count, data);
            ++k;
        }
    }

    public void testRemoveTime_nclist() {
        int deleteCount = 1000;
        int k = 2;
        while (k <= 30) {
            int count = k * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count);
                NCList<Range> ncl = new NCList<Range>(ranges);
                long now = System.currentTimeMillis();
                int j = 0;
                while (j < 1000) {
                    Range toDelete = ranges.get(this.rand.nextInt(count));
                    ncl.remove(toDelete);
                    ++j;
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                Assert.assertTrue((boolean)ncl.isValid());
                ++i;
            }
            this.logResults("NCList remove", count, data);
            ++k;
        }
    }

    public void testRemove_ArrayList() {
        int deleteCount = 1000;
        int k = 2;
        while (k <= 20) {
            int count = k * 100 * 1000;
            double[] data = new double[10];
            int i = 0;
            while (i < 13) {
                List<Range> ranges = this.generateIntervals(count);
                int[] toDelete = new int[1000];
                int j = 0;
                while (j < 1000) {
                    toDelete[j] = this.rand.nextInt(count - 1000);
                    ++j;
                }
                long now = System.currentTimeMillis();
                int[] nArray = toDelete;
                int n = toDelete.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    ranges.remove(index);
                    ++n2;
                }
                long elapsed = System.currentTimeMillis() - now;
                if (i >= 3) {
                    data[i - 3] = elapsed;
                }
                ++i;
            }
            this.logResults("ArrayList remove", count, data);
            ++k;
        }
    }

    private double standardError(double[] data, double mean) {
        double sum = 0.0;
        int n = data.length;
        int i = 0;
        while (i < n) {
            double diff = data[i] - mean;
            sum += diff * diff;
            ++i;
        }
        double stdev = Math.sqrt(sum / (double)(n - 1));
        double stderr = stdev / Math.sqrt(n);
        return stderr;
    }
}

