/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.VARNAPoint;
import fr.orsay.lri.varna.utils.XMLUtils;
import java.awt.geom.Point2D;
import java.util.HashMap;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBaseNucleotide
extends ModeleBase {
    private static final long serialVersionUID = -5493938366569588113L;
    private String _c;
    private int _index;
    public static String XML_ELEMENT_NAME = "nt";
    public static String XML_VAR_CONTENT_NAME = "base";
    private static HashMap<Character, Character> _subscripts = new HashMap();
    private static HashMap<Character, Character> _superscripts = new HashMap();
    private static HashMap<String, Character> _commands = new HashMap();

    @Override
    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_INDEX_NAME, "CDATA", "" + this._index);
        attributesImpl.addAttribute("", "", XML_VAR_NUMBER_NAME, "CDATA", "" + this._realIndex);
        attributesImpl.addAttribute("", "", XML_VAR_CUSTOM_DRAWN_NAME, "CDATA", "" + this._colorie);
        attributesImpl.addAttribute("", "", XML_VAR_VALUE_NAME, "CDATA", "" + this._value);
        attributesImpl.addAttribute("", "", XML_VAR_LABEL_NAME, "CDATA", "" + this._label);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        attributesImpl.clear();
        transformerHandler.startElement("", "", XML_VAR_CONTENT_NAME, attributesImpl);
        XMLUtils.exportCDATAString(transformerHandler, this._c);
        transformerHandler.endElement("", "", XML_VAR_CONTENT_NAME);
        this._coords.toXML(transformerHandler, XML_VAR_POSITION_NAME);
        this._center.toXML(transformerHandler, XML_VAR_CENTER_NAME);
        if (this._colorie.booleanValue()) {
            this._styleBase.toXML(transformerHandler);
        }
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public ModeleBaseNucleotide(int n) {
        this(" ", n);
    }

    public ModeleBaseNucleotide(String string, int n) {
        this(string, new ModelBaseStyle(), n);
    }

    public ModeleBaseNucleotide(String string, int n, int n2) {
        this(string, new ModelBaseStyle(), n);
        this._realIndex = n2;
    }

    public ModeleBaseNucleotide(String string, ModelBaseStyle modelBaseStyle, int n) {
        this(new Point2D.Double(), new Point2D.Double(), true, string, modelBaseStyle, -1, n);
    }

    public ModeleBaseNucleotide(ModelBaseStyle modelBaseStyle, int n, int n2) {
        this("", modelBaseStyle, n);
        this._realIndex = n2;
    }

    public ModeleBaseNucleotide(Point2D.Double double_, int n) {
        this(new Point2D.Double(double_.getX(), double_.getY()), new Point2D.Double(), true, "", new ModelBaseStyle(), -1, n);
    }

    public ModeleBaseNucleotide(ModeleBaseNucleotide modeleBaseNucleotide, int n) {
        this(new Point2D.Double(modeleBaseNucleotide.getCoords().getX(), modeleBaseNucleotide.getCoords().getY()), new Point2D.Double(modeleBaseNucleotide.getCenter().getX(), modeleBaseNucleotide.getCenter().getY()), true, modeleBaseNucleotide.getBase(), modeleBaseNucleotide.getStyleBase(), modeleBaseNucleotide.getElementStructure(), n);
    }

    public ModeleBaseNucleotide(Point2D.Double double_, Point2D.Double double_2, boolean bl, String string, ModelBaseStyle modelBaseStyle, int n, int n2) {
        _subscripts.put(Character.valueOf('0'), Character.valueOf('\u2080'));
        _subscripts.put(Character.valueOf('1'), Character.valueOf('\u2081'));
        _subscripts.put(Character.valueOf('2'), Character.valueOf('\u2082'));
        _subscripts.put(Character.valueOf('3'), Character.valueOf('\u2083'));
        _subscripts.put(Character.valueOf('4'), Character.valueOf('\u2084'));
        _subscripts.put(Character.valueOf('5'), Character.valueOf('\u2085'));
        _subscripts.put(Character.valueOf('6'), Character.valueOf('\u2086'));
        _subscripts.put(Character.valueOf('7'), Character.valueOf('\u2087'));
        _subscripts.put(Character.valueOf('8'), Character.valueOf('\u2088'));
        _subscripts.put(Character.valueOf('9'), Character.valueOf('\u2089'));
        _subscripts.put(Character.valueOf('+'), Character.valueOf('\u208a'));
        _subscripts.put(Character.valueOf('-'), Character.valueOf('\u208b'));
        _subscripts.put(Character.valueOf('a'), Character.valueOf('\u2090'));
        _subscripts.put(Character.valueOf('e'), Character.valueOf('\u2091'));
        _subscripts.put(Character.valueOf('o'), Character.valueOf('\u2092'));
        _subscripts.put(Character.valueOf('i'), Character.valueOf('\u1d62'));
        _subscripts.put(Character.valueOf('r'), Character.valueOf('\u1d63'));
        _subscripts.put(Character.valueOf('u'), Character.valueOf('\u1d64'));
        _subscripts.put(Character.valueOf('v'), Character.valueOf('\u1d65'));
        _subscripts.put(Character.valueOf('x'), Character.valueOf('\u2093'));
        _superscripts.put(Character.valueOf('0'), Character.valueOf('\u2070'));
        _superscripts.put(Character.valueOf('1'), Character.valueOf('\u00b9'));
        _superscripts.put(Character.valueOf('2'), Character.valueOf('\u00b2'));
        _superscripts.put(Character.valueOf('3'), Character.valueOf('\u00b3'));
        _superscripts.put(Character.valueOf('4'), Character.valueOf('\u2074'));
        _superscripts.put(Character.valueOf('5'), Character.valueOf('\u2075'));
        _superscripts.put(Character.valueOf('6'), Character.valueOf('\u2076'));
        _superscripts.put(Character.valueOf('7'), Character.valueOf('\u2077'));
        _superscripts.put(Character.valueOf('8'), Character.valueOf('\u2078'));
        _superscripts.put(Character.valueOf('9'), Character.valueOf('\u2079'));
        _superscripts.put(Character.valueOf('+'), Character.valueOf('\u207a'));
        _superscripts.put(Character.valueOf('-'), Character.valueOf('\u207b'));
        _superscripts.put(Character.valueOf('i'), Character.valueOf('\u2071'));
        _superscripts.put(Character.valueOf('n'), Character.valueOf('\u207f'));
        _commands.put("alpha", Character.valueOf('\u03b1'));
        _commands.put("beta", Character.valueOf('\u03b2'));
        _commands.put("gamma", Character.valueOf('\u03b3'));
        _commands.put("delta", Character.valueOf('\u03b4'));
        _commands.put("epsilon", Character.valueOf('\u03b5'));
        _commands.put("zeta", Character.valueOf('\u03b6'));
        _commands.put("eta", Character.valueOf('\u03b7'));
        _commands.put("theta", Character.valueOf('\u03b8'));
        _commands.put("iota", Character.valueOf('\u03b9'));
        _commands.put("kappa", Character.valueOf('\u03ba'));
        _commands.put("lambda", Character.valueOf('\u03bb'));
        _commands.put("mu", Character.valueOf('\u03bc'));
        _commands.put("nu", Character.valueOf('\u03bd'));
        _commands.put("xi", Character.valueOf('\u03be'));
        _commands.put("omicron", Character.valueOf('\u03bf'));
        _commands.put("pi", Character.valueOf('\u03c1'));
        _commands.put("rho", Character.valueOf('\u03c2'));
        _commands.put("sigma", Character.valueOf('\u03c3'));
        _commands.put("tau", Character.valueOf('\u03c4'));
        _commands.put("upsilon", Character.valueOf('\u03c5'));
        _commands.put("phi", Character.valueOf('\u03c6'));
        _commands.put("chi", Character.valueOf('\u03c7'));
        _commands.put("psi", Character.valueOf('\u03c8'));
        _commands.put("omega", Character.valueOf('\u03c9'));
        _commands.put("Psi", Character.valueOf('\u03a8'));
        _commands.put("Phi", Character.valueOf('\u03a6'));
        _commands.put("Sigma", Character.valueOf('\u03a3'));
        _commands.put("Pi", Character.valueOf('\u03a0'));
        _commands.put("Theta", Character.valueOf('\u0398'));
        _commands.put("Omega", Character.valueOf('\u03a9'));
        _commands.put("Gamma", Character.valueOf('\u0393'));
        _commands.put("Delta", Character.valueOf('\u0394'));
        _commands.put("Lambda", Character.valueOf('\u039b'));
        this._colorie = bl;
        this._c = string;
        this._styleBase = modelBaseStyle;
        this._coords = new VARNAPoint(double_);
        this._center = new VARNAPoint(double_2);
        this._index = n2;
        this._realIndex = n2 + 1;
        this._value = 0.0;
    }

    @Override
    public ModelBaseStyle getStyleBase() {
        if (this._colorie.booleanValue()) {
            return this._styleBase;
        }
        return new ModelBaseStyle();
    }

    public String getBase() {
        return ModeleBaseNucleotide.decode(this._c);
    }

    public void setBase(String string) {
        this._c = string;
    }

    @Override
    public String getContent() {
        return this.getBase();
    }

    @Override
    public void setContent(String string) {
        this.setBase(string);
    }

    @Override
    public int getIndex() {
        return this._index;
    }

    public String toString() {
        return "" + this._realIndex + " (" + this._index + ") (x,y):" + this._coords + " C:" + this._center;
    }

    private static String decode(String string) {
        if (string.length() <= 1) {
            return string;
        }
        STATE_SPECIAL_CHARS_STATES sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.NORMAL;
        String string2 = "";
        String string3 = "";
        block21: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (sTATE_SPECIAL_CHARS_STATES) {
                case NORMAL: {
                    switch (c) {
                        case '_': {
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.SUBSCRIPT;
                            continue block21;
                        }
                        case '^': {
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT;
                            continue block21;
                        }
                        case '\\': {
                            string3 = "";
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.COMMAND;
                            continue block21;
                        }
                    }
                    string2 = string2 + c;
                    sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.NORMAL;
                    continue block21;
                }
                case SUBSCRIPT: 
                case SUPERSCRIPT: {
                    switch (c) {
                        case '_': {
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.SUBSCRIPT;
                            continue block21;
                        }
                        case '^': {
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT;
                            continue block21;
                        }
                        case '\\': {
                            string3 = "";
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.COMMAND;
                            continue block21;
                        }
                    }
                    string2 = sTATE_SPECIAL_CHARS_STATES == STATE_SPECIAL_CHARS_STATES.SUBSCRIPT && _subscripts.containsKey(Character.valueOf(c)) ? string2 + _subscripts.get(Character.valueOf(c)) : (sTATE_SPECIAL_CHARS_STATES == STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT && _superscripts.containsKey(Character.valueOf(c)) ? string2 + _superscripts.get(Character.valueOf(c)) : string2 + c);
                    sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.NORMAL;
                    continue block21;
                }
                case COMMAND: {
                    switch (c) {
                        case '_': {
                            string2 = _commands.containsKey(string3) ? string2 + _commands.get(string3) : string2 + string3;
                            string3 = "";
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.SUBSCRIPT;
                            continue block21;
                        }
                        case '^': {
                            string2 = _commands.containsKey(string3) ? string2 + _commands.get(string3) : string2 + string3;
                            string3 = "";
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.SUPERSCRIPT;
                            continue block21;
                        }
                        case '\\': {
                            string2 = _commands.containsKey(string3) ? string2 + _commands.get(string3) : string2 + string3;
                            string3 = "";
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.COMMAND;
                            continue block21;
                        }
                        case ' ': {
                            sTATE_SPECIAL_CHARS_STATES = STATE_SPECIAL_CHARS_STATES.NORMAL;
                            string2 = _commands.containsKey(string3) ? string2 + _commands.get(string3) : string2 + string3;
                            string3 = "";
                            continue block21;
                        }
                    }
                    string3 = string3 + c;
                }
            }
        }
        string2 = _commands.containsKey(string3) ? string2 + _commands.get(string3) : string2 + string3;
        return string2;
    }

    private static enum STATE_SPECIAL_CHARS_STATES {
        NORMAL,
        SUBSCRIPT,
        SUPERSCRIPT,
        COMMAND;

    }
}

