/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBPStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ModeleBP
implements Serializable,
Comparable<ModeleBP> {
    private static final long serialVersionUID = -1344722280822711931L;
    private ModeleBase _partner5;
    private Edge _edge5;
    private ModeleBase _partner3;
    private Edge _edge3;
    private Stericity _stericity;
    private ModeleBPStyle _style;
    public static String XML_ELEMENT_NAME = "bp";
    public static String XML_VAR_PARTNER5_NAME = "part5";
    public static String XML_VAR_EDGE5_NAME = "edge5";
    public static String XML_VAR_PARTNER3_NAME = "part3";
    public static String XML_VAR_EDGE3_NAME = "edge3";
    public static String XML_VAR_STERICITY_NAME = "orient";
    public static String XML_VAR_SEC_STR_NAME = "secstr";
    public static final String PARAM_COLOR = "color";
    public static final String PARAM_THICKNESS = "thickness";
    public static final String PARAM_EDGE5 = "edge5";
    public static final String PARAM_EDGE3 = "edge3";
    public static final String PARAM_STERICITY = "stericity";
    public static final String VALUE_WATSON_CRICK = "wc";
    public static final String VALUE_HOOGSTEEN = "h";
    public static final String VALUE_SUGAR = "s";
    public static final String VALUE_CIS = "cis";
    public static final String VALUE_TRANS = "trans";

    public void toXML(TransformerHandler transformerHandler, boolean bl) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("", "", XML_VAR_PARTNER5_NAME, "CDATA", "" + this._partner5.getIndex());
        attributesImpl.addAttribute("", "", XML_VAR_PARTNER3_NAME, "CDATA", "" + this._partner3.getIndex());
        attributesImpl.addAttribute("", "", XML_VAR_EDGE5_NAME, "CDATA", "" + (Object)((Object)this._edge5));
        attributesImpl.addAttribute("", "", XML_VAR_EDGE3_NAME, "CDATA", "" + (Object)((Object)this._edge3));
        attributesImpl.addAttribute("", "", XML_VAR_STERICITY_NAME, "CDATA", "" + (Object)((Object)this._stericity));
        attributesImpl.addAttribute("", "", XML_VAR_SEC_STR_NAME, "CDATA", "" + bl);
        transformerHandler.startElement("", "", XML_ELEMENT_NAME, attributesImpl);
        this._style.toXML(transformerHandler);
        transformerHandler.endElement("", "", XML_ELEMENT_NAME);
    }

    public void toXML(TransformerHandler transformerHandler) throws SAXException {
        this.toXML(transformerHandler, false);
    }

    public ModeleBP(ModeleBase modeleBase, ModeleBase modeleBase2) {
        this(modeleBase, modeleBase2, Edge.WC, Edge.WC, Stericity.CIS);
    }

    public ModeleBP(ModeleBase modeleBase, ModeleBase modeleBase2, Edge edge, Edge edge2, Stericity stericity) {
        this._partner5 = modeleBase;
        this._partner3 = modeleBase2;
        this._edge5 = edge;
        this._edge3 = edge2;
        this._stericity = stericity;
        this._style = new ModeleBPStyle();
    }

    public ModeleBP(String string) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        this._style = new ModeleBPStyle();
        this.assignParameters(string);
    }

    public void setStericity(Stericity stericity) {
        this._stericity = stericity;
    }

    public void setEdge5(Edge edge) {
        this._edge5 = edge;
    }

    public void setEdge3(Edge edge) {
        this._edge3 = edge;
    }

    public void setStyle(ModeleBPStyle modeleBPStyle) {
        this._style = modeleBPStyle;
    }

    public ModeleBPStyle getStyle() {
        return this._style;
    }

    public boolean isCanonicalGC() {
        String string = this._partner5.getContent();
        String string2 = this._partner3.getContent();
        if (string.length() >= 1 && string2.length() >= 1) {
            char c = string.toUpperCase().charAt(0);
            char c2 = string2.toUpperCase().charAt(0);
            if (c == 'G' && c2 == 'C' || c == 'C' && c2 == 'G') {
                return this.isCanonical() && this.getStericity() == Stericity.CIS;
            }
        }
        return false;
    }

    public boolean isCanonicalAU() {
        String string = this._partner5.getContent();
        String string2 = this._partner3.getContent();
        if (string.length() >= 1 && string2.length() >= 1) {
            char c = string.toUpperCase().charAt(0);
            char c2 = string2.toUpperCase().charAt(0);
            if (c == 'A' && c2 == 'U' || c == 'U' && c2 == 'A') {
                return this.isCanonical();
            }
        }
        return false;
    }

    public boolean isWobbleUG() {
        String string = this._partner5.getContent();
        String string2 = this._partner3.getContent();
        if (string.length() >= 1 && string2.length() >= 1) {
            char c = string.toUpperCase().charAt(0);
            char c2 = string2.toUpperCase().charAt(0);
            if (c == 'G' && c2 == 'U' || c == 'U' && c2 == 'G') {
                return this.isCanonical();
            }
        }
        return false;
    }

    public boolean isCanonical() {
        return this._edge5 == Edge.WC && this._edge3 == Edge.WC && this._stericity == Stericity.CIS;
    }

    public Stericity getStericity() {
        return this._stericity;
    }

    public boolean isCIS() {
        return this._stericity == Stericity.CIS;
    }

    public boolean isTRANS() {
        return this._stericity == Stericity.TRANS;
    }

    public Edge getEdgePartner5() {
        return this._edge5;
    }

    public Edge getEdgePartner3() {
        return this._edge3;
    }

    public ModeleBase getPartner(ModeleBase modeleBase) {
        if (modeleBase == this._partner3) {
            return this._partner5;
        }
        return this._partner3;
    }

    public ModeleBase getPartner5() {
        return this._partner5;
    }

    public ModeleBase getPartner3() {
        return this._partner3;
    }

    public int getIndex5() {
        return this._partner5.getIndex();
    }

    public int getIndex3() {
        return this._partner3.getIndex();
    }

    public void setPartner5(ModeleBase modeleBase) {
        this._partner5 = modeleBase;
    }

    public void setPartner3(ModeleBase modeleBase) {
        this._partner3 = modeleBase;
    }

    public void assignParameters(String string) throws ExceptionModeleStyleBaseSyntaxError, ExceptionParameterError {
        int n;
        if (string.equals("")) {
            return;
        }
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String[] stringArray2 = stringArray[n].split("=");
            if (stringArray2.length != 2) {
                throw new ExceptionModeleStyleBaseSyntaxError("Bad parameter: '" + stringArray2[0] + "' ...");
            }
            arrayList.add(stringArray2[0].replace(" ", ""));
            arrayList2.add(stringArray2[1].replace(" ", ""));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            String string2;
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_COLOR)) {
                try {
                    this._style.setCustomColor(ModelBaseStyle.getSafeColor((String)arrayList2.get(n)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad inner color Syntax:" + (String)arrayList2.get(n));
                }
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_THICKNESS)) {
                try {
                    this._style.setThickness(Double.parseDouble((String)arrayList2.get(n)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ExceptionParameterError(numberFormatException.getMessage(), "Bad value for bp thickness:" + (String)arrayList2.get(n));
                }
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_EDGE5)) {
                string2 = (String)arrayList2.get(n);
                if (string2.toLowerCase().equals(VALUE_WATSON_CRICK)) {
                    this.setEdge5(Edge.WC);
                    continue;
                }
                if (string2.toLowerCase().equals(VALUE_HOOGSTEEN)) {
                    this.setEdge5(Edge.HOOGSTEEN);
                    continue;
                }
                if (string2.toLowerCase().equals(VALUE_SUGAR)) {
                    this.setEdge5(Edge.SUGAR);
                    continue;
                }
                throw new ExceptionParameterError("Bad value for edge:" + (String)arrayList2.get(n));
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_EDGE3)) {
                string2 = (String)arrayList2.get(n);
                if (string2.toLowerCase().equals(VALUE_WATSON_CRICK)) {
                    this.setEdge3(Edge.WC);
                    continue;
                }
                if (string2.toLowerCase().equals(VALUE_HOOGSTEEN)) {
                    this.setEdge3(Edge.HOOGSTEEN);
                    continue;
                }
                if (string2.toLowerCase().equals(VALUE_SUGAR)) {
                    this.setEdge3(Edge.SUGAR);
                    continue;
                }
                throw new ExceptionParameterError("Bad value for edge:" + (String)arrayList2.get(n));
            }
            if (((String)arrayList.get(n)).toLowerCase().equals(PARAM_STERICITY)) {
                string2 = (String)arrayList2.get(n);
                if (string2.toLowerCase().equals(VALUE_CIS)) {
                    this.setStericity(Stericity.CIS);
                    continue;
                }
                if (string2.toLowerCase().equals(VALUE_TRANS)) {
                    this.setStericity(Stericity.TRANS);
                    continue;
                }
                throw new ExceptionParameterError("Bad value for stericity:" + (String)arrayList2.get(n));
            }
            throw new ExceptionModeleStyleBaseSyntaxError("Unknown parameter:" + (String)arrayList.get(n));
        }
    }

    public String toString() {
        String string = "";
        string = string + "(" + this._partner5.getIndex() + "," + this._partner3.getIndex() + ")";
        return string;
    }

    @Override
    public int compareTo(ModeleBP modeleBP) {
        if (this.getIndex5() != modeleBP.getIndex5()) {
            return this.getIndex5() - modeleBP.getIndex5();
        }
        return this.getIndex3() - modeleBP.getIndex3();
    }

    public static enum Stericity {
        CIS,
        TRANS;

    }

    public static enum Edge {
        WC,
        SUGAR,
        HOOGSTEEN;

    }
}

