/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.factories;

import fr.orsay.lri.varna.exceptions.ExceptionExportFailed;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionPermissionDenied;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.factories.RNAAlignment;
import fr.orsay.lri.varna.factories.StockholmIO;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBackboneElement;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.utils.RNAMLParser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class RNAFactory {
    public static ArrayList<RNA> loadSecStrRNAML(Reader reader) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setXIncludeAware(false);
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            RNAMLParser rNAMLParser = new RNAMLParser();
            sAXParser.parse(new InputSource(reader), (DefaultHandler)rNAMLParser);
            for (RNAMLParser.RNATmp rNATmp : rNAMLParser.getMolecules()) {
                RNA rNA = new RNA();
                ArrayList<String> arrayList2 = rNATmp.getSequence();
                int[] nArray = new int[arrayList2.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = -1;
                }
                rNA.setRNA(arrayList2, nArray);
                Vector<RNAMLParser.BPTemp> vector = rNATmp.getStructure();
                ArrayList<ModeleBP> arrayList3 = new ArrayList<ModeleBP>();
                for (int i = 0; i < vector.size(); ++i) {
                    RNAMLParser.BPTemp bPTemp = vector.get(i);
                    int n = bPTemp.pos5;
                    int n2 = bPTemp.pos3;
                    ModeleBase modeleBase = rNA.getBaseAt(n);
                    ModeleBase modeleBase2 = rNA.getBaseAt(n2);
                    ModeleBP modeleBP = bPTemp.createBPStyle(modeleBase, modeleBase2);
                    arrayList3.add(modeleBP);
                }
                rNA.applyBPs(arrayList3);
                arrayList.add(rNA);
            }
        }
        catch (IOException iOException) {
            throw new ExceptionLoadingFailed("Couldn't load file due to I/O or security policy issues.", "");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static int[] parseSecStr(String string) throws ExceptionUnmatchedClosingParentheses {
        Hashtable hashtable = new Hashtable();
        int[] nArray = new int[string.length()];
        int n = 0;
        try {
            block10: for (n = 0; n < string.length(); ++n) {
                nArray[n] = -1;
                char c = string.charAt(n);
                char c2 = Character.toUpperCase(c);
                if (!hashtable.containsKey(Character.valueOf(c2))) {
                    hashtable.put(Character.valueOf(c2), new Stack());
                }
                switch (c) {
                    case '(': 
                    case '<': 
                    case '[': 
                    case '{': {
                        ((Stack)hashtable.get(Character.valueOf(c))).push(n);
                        continue block10;
                    }
                    case '>': {
                        int n2;
                        nArray[n] = n2 = ((Integer)((Stack)hashtable.get(Character.valueOf('<'))).pop()).intValue();
                        nArray[n2] = n;
                        continue block10;
                    }
                    case '}': {
                        int n2;
                        nArray[n] = n2 = ((Integer)((Stack)hashtable.get(Character.valueOf('{'))).pop()).intValue();
                        nArray[n2] = n;
                        continue block10;
                    }
                    case ')': {
                        int n2;
                        nArray[n] = n2 = ((Integer)((Stack)hashtable.get(Character.valueOf('('))).pop()).intValue();
                        nArray[n2] = n;
                        continue block10;
                    }
                    case ']': {
                        int n2;
                        nArray[n] = n2 = ((Integer)((Stack)hashtable.get(Character.valueOf('['))).pop()).intValue();
                        nArray[n2] = n;
                        continue block10;
                    }
                    case '.': {
                        continue block10;
                    }
                    default: {
                        int n2;
                        if (Character.isLetter(c) && Character.isUpperCase(c)) {
                            ((Stack)hashtable.get(Character.valueOf(c))).push(n);
                            continue block10;
                        }
                        if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue block10;
                        nArray[n] = n2 = ((Integer)((Stack)hashtable.get(Character.valueOf(Character.toUpperCase(c)))).pop()).intValue();
                        nArray[n2] = n;
                    }
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new ExceptionUnmatchedClosingParentheses(n);
        }
        return nArray;
    }

    public static ArrayList<RNA> loadSecStrDBN(Reader reader) throws ExceptionLoadingFailed, ExceptionPermissionDenied, ExceptionUnmatchedClosingParentheses, ExceptionFileFormatOrSyntax {
        boolean bl = false;
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        RNA rNA = new RNA();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            String string2 = "";
            String string3 = "";
            String string4 = "";
            while (string != null && string4.equals("")) {
                if (!(string = string.trim()).startsWith(">")) {
                    if (string3.equals("")) {
                        string3 = string;
                    } else {
                        string4 = string;
                    }
                } else {
                    string2 = string.substring(1).trim();
                }
                string = bufferedReader.readLine();
            }
            if (string4.length() != 0) {
                rNA.setRNA(string3, string4);
                rNA.setName(string2);
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw new ExceptionLoadingFailed(iOException.getMessage(), "");
        }
        if (bl) {
            arrayList.add(rNA);
        }
        return arrayList;
    }

    public static ArrayList<RNA> loadSecStr(Reader reader) throws ExceptionFileFormatOrSyntax {
        return RNAFactory.loadSecStr(new BufferedReader(reader), RNAFileType.FILE_TYPE_UNKNOWN);
    }

    public static ArrayList<RNA> loadSecStr(BufferedReader bufferedReader, RNAFileType rNAFileType) throws ExceptionFileFormatOrSyntax {
        switch (rNAFileType) {
            case FILE_TYPE_DBN: {
                try {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStrDBN(bufferedReader);
                    if (arrayList.size() != 0) {
                        return arrayList;
                    }
                }
                catch (Exception exception) {}
                break;
            }
            case FILE_TYPE_CT: {
                try {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStrCT(bufferedReader);
                    if (arrayList.size() != 0) {
                        return arrayList;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case FILE_TYPE_BPSEQ: {
                try {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStrBPSEQ(bufferedReader);
                    if (arrayList.size() != 0) {
                        return arrayList;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case FILE_TYPE_TCOFFEE: {
                try {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStrTCoffee(bufferedReader);
                    if (arrayList.size() != 0) {
                        return arrayList;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case FILE_TYPE_STOCKHOLM: {
                try {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStrStockholm(bufferedReader);
                    if (arrayList.size() != 0) {
                        return arrayList;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case FILE_TYPE_RNAML: {
                try {
                    ArrayList<RNA> arrayList = RNAFactory.loadSecStrRNAML(bufferedReader);
                    if (arrayList.size() != 0) {
                        return arrayList;
                    }
                }
                catch (Exception exception) {}
                break;
            }
            case FILE_TYPE_UNKNOWN: {
                try {
                    bufferedReader.mark(1000000);
                    RNAFileType[] rNAFileTypeArray = RNAFileType.values();
                    for (int i = 0; i < rNAFileTypeArray.length; ++i) {
                        bufferedReader.reset();
                        RNAFileType rNAFileType2 = rNAFileTypeArray[i];
                        if (rNAFileType2 == RNAFileType.FILE_TYPE_UNKNOWN) continue;
                        try {
                            ArrayList<RNA> arrayList = RNAFactory.loadSecStr(bufferedReader, rNAFileType2);
                            if (arrayList.size() == 0) continue;
                            return arrayList;
                        }
                        catch (Exception exception) {
                            System.err.println(exception.toString());
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        throw new ExceptionFileFormatOrSyntax("Couldn't parse this file as " + (Object)((Object)rNAFileType) + ".");
    }

    public static RNAFileType guessFileTypeFromExtension(String string) {
        if (string.toLowerCase().endsWith("ml")) {
            return RNAFileType.FILE_TYPE_RNAML;
        }
        if (string.toLowerCase().endsWith("dbn") || string.toLowerCase().endsWith("faa")) {
            return RNAFileType.FILE_TYPE_DBN;
        }
        if (string.toLowerCase().endsWith("ct")) {
            return RNAFileType.FILE_TYPE_CT;
        }
        if (string.toLowerCase().endsWith("bpseq")) {
            return RNAFileType.FILE_TYPE_BPSEQ;
        }
        if (string.toLowerCase().endsWith("rfold")) {
            return RNAFileType.FILE_TYPE_TCOFFEE;
        }
        if (string.toLowerCase().endsWith("stockholm") || string.toLowerCase().endsWith("stk")) {
            return RNAFileType.FILE_TYPE_STOCKHOLM;
        }
        return RNAFileType.FILE_TYPE_UNKNOWN;
    }

    public static ArrayList<RNA> loadSecStr(String string) throws ExceptionExportFailed, ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax, ExceptionUnmatchedClosingParentheses, FileNotFoundException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(string);
            RNAFileType rNAFileType = RNAFactory.guessFileTypeFromExtension(string);
            return RNAFactory.loadSecStr(new BufferedReader(fileReader), rNAFileType);
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            exceptionFileFormatOrSyntax.setPath(string);
            throw exceptionFileFormatOrSyntax;
        }
    }

    public static ArrayList<RNA> loadSecStrStockholm(BufferedReader bufferedReader) throws IOException, ExceptionUnmatchedClosingParentheses {
        RNAAlignment rNAAlignment = StockholmIO.readAlignement(bufferedReader);
        return rNAAlignment.getRNAs();
    }

    public static ArrayList<RNA> loadSecStrBPSEQ(Reader reader) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        boolean bl = false;
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        RNA rNA = new RNA();
        try {
            Object object;
            String[] stringArray;
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            String[] stringArray2 = new ArrayList();
            Hashtable hashtable = new Hashtable();
            int n = -1;
            boolean bl2 = true;
            String string2 = "";
            String string3 = "";
            String string4 = "Filename:";
            String string5 = "Organism:";
            String string6 = "Accession Number:";
            while (string != null) {
                String string7;
                int n2;
                string = string.trim();
                stringArray = string.split("\\s+");
                object = new ArrayList();
                Hashtable hashtable2 = new Hashtable();
                if (!(stringArray.length < 3 || stringArray[0].contains("#") || string.startsWith("Organism:") || string.startsWith("Citation") || string.startsWith("Filename:") || string.startsWith("Accession Number:"))) {
                    String string8 = stringArray[1];
                    stringArray2.add(string8);
                    int n3 = Integer.parseInt(stringArray[0]);
                    ((ArrayList)object).add(n3);
                    if (n < 0) {
                        n = n3;
                    }
                    if (stringArray2.size() < n3 - n + 1) {
                        if (bl2) {
                            bl2 = false;
                        }
                        while (stringArray2.size() < n3 - n + 1) {
                            stringArray2.add("X");
                        }
                    }
                    for (n2 = 2; n2 < stringArray.length; ++n2) {
                        int n4 = Integer.parseInt(stringArray[n2]);
                        if (n4 == 0 && n2 == stringArray.length - 1) continue;
                        if (!hashtable.containsKey(n3)) {
                            hashtable.put(n3, new Vector());
                        }
                        ((Vector)hashtable.get(n3)).add(n4);
                    }
                } else if (stringArray[0].startsWith("#")) {
                    n2 = string.indexOf("#");
                    string7 = string.substring(n2 + 1);
                    string2 = string2 + string7.trim() + " ";
                } else if (stringArray[0].startsWith(string4)) {
                    n2 = string.indexOf(string4);
                    string7 = string.substring(n2 + string4.length());
                    string2 = string2 + string7.trim();
                } else if (stringArray[0].startsWith(string5)) {
                    n2 = string.indexOf(string5);
                    string7 = string.substring(n2 + string5.length());
                    if (string2.length() != 0) {
                        string2 = "/" + string2;
                    }
                    string2 = string7.trim() + string2;
                } else if (string.contains(string6)) {
                    n2 = string.indexOf(string6);
                    string7 = string.substring(n2 + string6.length());
                    string3 = string7.trim();
                }
                string = bufferedReader.readLine();
            }
            if (hashtable.size() != 0) {
                stringArray = stringArray2;
                object = new int[stringArray.size()];
                for (int i = 0; i < stringArray.size(); ++i) {
                    object[i] = -1;
                }
                rNA.setRNA((List<String>)stringArray, (int[])object, n);
                ArrayList<ModeleBP> arrayList2 = new ArrayList<ModeleBP>();
                Iterator iterator = hashtable.keySet().iterator();
                while (iterator.hasNext()) {
                    int n5 = (Integer)iterator.next();
                    Iterator iterator2 = ((Vector)hashtable.get(n5)).iterator();
                    while (iterator2.hasNext()) {
                        int n6 = (Integer)iterator2.next();
                        if (n5 > n6) continue;
                        ModeleBase modeleBase = rNA.getBaseAt(n5 - n);
                        ModeleBase modeleBase2 = rNA.getBaseAt(n6 - n);
                        ModeleBP modeleBP = new ModeleBP(modeleBase, modeleBase2);
                        arrayList2.add(modeleBP);
                    }
                }
                rNA.applyBPs(arrayList2);
                rNA.setName(string2);
                rNA.setID(string3);
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            throw new ExceptionLoadingFailed(exception.getMessage(), "");
        }
        if (bl) {
            arrayList.add(rNA);
        }
        return arrayList;
    }

    public static ArrayList<RNA> loadSecStrTCoffee(Reader reader) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        boolean bl = false;
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            int n = -1;
            int n2 = -1;
            RNA rNA = null;
            while (string != null) {
                if (!string.startsWith("!")) {
                    int n3;
                    String[] stringArray = string.split("\\s+");
                    if (string.startsWith("#")) {
                        n2 = Integer.parseInt(stringArray[0].substring(1));
                        if (n2 == (n3 = Integer.parseInt(stringArray[1]))) {
                            rNA = new RNA();
                            rNA.setName((String)arrayList3.get(n2 - 1));
                            rNA.setSequence((String)arrayList2.get(n2 - 1));
                            arrayList.add(rNA);
                        } else {
                            rNA = null;
                        }
                    } else if (rNA == null) {
                        if (n < 0) {
                            n = Integer.parseInt(stringArray[0]);
                        } else {
                            String string2 = stringArray[0];
                            String string3 = stringArray[2];
                            arrayList2.add(string3);
                            arrayList3.add(string2);
                        }
                    } else if (stringArray.length == 3) {
                        n3 = Integer.parseInt(stringArray[0]) - 1;
                        int n4 = Integer.parseInt(stringArray[1]) - 1;
                        rNA.addBP(n3, n4);
                    }
                }
                string = bufferedReader.readLine();
            }
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!bl) {
            throw new ExceptionLoadingFailed("Parse Error", "");
        }
        return arrayList;
    }

    public static ArrayList<RNA> loadSecStrCT(Reader reader) throws ExceptionPermissionDenied, ExceptionLoadingFailed, ExceptionFileFormatOrSyntax {
        boolean bl = false;
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        RNA rNA = new RNA();
        try {
            int n;
            int n2;
            Object[] objectArray;
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            Vector<Integer> vector = new Vector<Integer>();
            Vector<Integer> vector2 = new Vector<Integer>();
            boolean bl2 = true;
            int n3 = -1;
            String string2 = "";
            while (string != null) {
                String[] stringArray;
                block19: {
                    objectArray = (string = string.trim()).split("\\s+");
                    if (objectArray.length >= 6) {
                        try {
                            int n4 = Integer.parseInt(objectArray[0]);
                            int n5 = Integer.parseInt(objectArray[4]);
                            if (n3 == -1) {
                                n3 = n4;
                            }
                            n4 -= n3;
                            n5 = n5 != 0 ? (n5 -= n3) : -1;
                            String string3 = objectArray[1];
                            String string4 = objectArray[5];
                            n2 = Integer.parseInt(objectArray[2]);
                            n = Integer.parseInt(objectArray[3]);
                            if (n2 == 0 && !arrayList2.isEmpty()) {
                                vector2.add(vector.size() - 1);
                            }
                            if (n4 != arrayList2.size()) {
                                if (bl2) {
                                    bl2 = false;
                                }
                                while (n4 > arrayList2.size()) {
                                    arrayList2.add("X");
                                    vector.add(-1);
                                    arrayList3.add("");
                                }
                            }
                            arrayList2.add(string3);
                            vector.add(n5);
                            arrayList3.add(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (vector.size() == 0) break block19;
                            numberFormatException.printStackTrace();
                        }
                    }
                }
                if ((string.contains("ENERGY = ") || string.contains("dG = ")) && (stringArray = string.split("\\s+")).length >= 4) {
                    String string5 = stringArray[3];
                    for (int i = 4; i < stringArray.length; ++i) {
                        string2 = string2 + stringArray[i] + " ";
                    }
                    string2 = string2 + "(E=" + string5 + " kcal/mol)";
                }
                string = bufferedReader.readLine();
            }
            if (vector.size() != 0) {
                objectArray = new int[vector.size()];
                for (n2 = 0; n2 < vector.size(); ++n2) {
                    objectArray[n2] = (String)((Object)((Integer)vector.elementAt(n2)));
                }
                rNA.setRNA(arrayList2, (int[])objectArray, n3);
                rNA.setName(string2);
                for (n2 = 0; n2 < rNA.getSize(); ++n2) {
                    rNA.getBaseAt(n2).setLabel((String)arrayList3.get(n2));
                }
                Iterator iterator = vector2.iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    rNA.getBackbone().addElement(new ModeleBackboneElement(n, ModeleBackboneElement.BackboneType.DISCONTINUOUS_TYPE));
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new ExceptionLoadingFailed(iOException.getMessage(), "");
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new ExceptionFileFormatOrSyntax(numberFormatException.getMessage(), "");
        }
        if (bl) {
            arrayList.add(rNA);
        }
        return arrayList;
    }

    public static enum RNAFileType {
        FILE_TYPE_STOCKHOLM,
        FILE_TYPE_TCOFFEE,
        FILE_TYPE_BPSEQ,
        FILE_TYPE_CT,
        FILE_TYPE_DBN,
        FILE_TYPE_RNAML,
        FILE_TYPE_UNKNOWN;

    }
}

