/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications.templateEditor;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.applications.templateEditor.Helix;
import fr.orsay.lri.varna.exceptions.ExceptionEdgeEndpointAlreadyConnected;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class GraphicalTemplateElement {
    public boolean _debug = false;
    protected HashMap<RelativePosition, Color> _mainColors = new HashMap();
    public Color _dominantColor = new Color(0.5f, 0.5f, 0.5f, 0.9f);
    static final Color BACKBONE_COLOR = Color.gray;
    static final Color CONTROL_COLOR = Color.decode("#D0D0FF");
    static final Font NUMBER_FONT = new Font("Arial", 1, 18);
    static final Color NUMBER_COLOR = Color.gray;
    static final Color BASE_PAIR_COLOR = Color.blue;
    static final Color BASE_COLOR = Color.gray;
    static final Color BASE_FILL_COLOR = Color.white;
    static final Color BASE_FILL_3_COLOR = Color.red;
    static final Color BASE_FILL_5_COLOR = Color.green;
    static final Color MAGNET_COLOR = CONTROL_COLOR;
    private HashMap<RelativePosition, Couple<RelativePosition, GraphicalTemplateElement>> _attachedElements = new HashMap();
    protected Stroke _boldStroke = new BasicStroke(2.5f, 1, 1, 3.0f);
    protected Stroke _solidStroke = new BasicStroke(1.5f, 1, 1, 3.0f);
    private float[] dash = new float[]{5.0f, 5.0f};
    protected Stroke _dashedStroke = new BasicStroke(1.5f, 1, 1, 3.0f, this.dash, 0.0f);

    public void setDominantColor(Color color) {
        this._dominantColor = color;
    }

    public Color getDominantColor() {
        return this._dominantColor;
    }

    public abstract RelativePosition getRelativePosition(double var1, double var3);

    public abstract void draw(Graphics2D var1, boolean var2);

    public abstract Polygon getBoundingPolygon();

    public abstract void translate(double var1, double var3);

    public abstract RelativePosition getClosestEdge(double var1, double var3);

    public abstract ArrayList<RelativePosition> getConnectedEdges();

    public abstract RNATemplate.RNATemplateElement getTemplateElement();

    public void setMainColor(RelativePosition relativePosition, Color color) {
        this._mainColors.put(relativePosition, color);
    }

    public abstract Shape getArea();

    public void attach(GraphicalTemplateElement graphicalTemplateElement, RelativePosition relativePosition, RelativePosition relativePosition2) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
        this._attachedElements.put(relativePosition, new Couple<RelativePosition, GraphicalTemplateElement>(relativePosition2, graphicalTemplateElement));
    }

    public void graphicalAttach(GraphicalTemplateElement graphicalTemplateElement, RelativePosition relativePosition, RelativePosition relativePosition2) {
        this._attachedElements.put(relativePosition, new Couple<RelativePosition, GraphicalTemplateElement>(relativePosition2, graphicalTemplateElement));
    }

    public void detach(RelativePosition relativePosition) {
        if (this._attachedElements.containsKey((Object)relativePosition)) {
            Couple<RelativePosition, GraphicalTemplateElement> couple = this._attachedElements.get((Object)relativePosition);
            this._attachedElements.remove((Object)relativePosition);
            ((GraphicalTemplateElement)couple.second).detach((RelativePosition)((Object)couple.first));
        }
    }

    public Couple<RelativePosition, GraphicalTemplateElement> getAttachedElement(RelativePosition relativePosition) {
        if (this._attachedElements.containsKey((Object)relativePosition)) {
            return this._attachedElements.get((Object)relativePosition);
        }
        return null;
    }

    public boolean hasAttachedElement(RelativePosition relativePosition) {
        return this._attachedElements.containsKey((Object)relativePosition);
    }

    public abstract RNATemplate.RNATemplateElement.EdgeEndPoint getEndPoint(RelativePosition var1);

    public abstract boolean isIn(RelativePosition var1);

    public void draw(Graphics2D graphics2D) {
        this.draw(graphics2D, false);
    }

    private Dimension getStringDimension(Graphics2D graphics2D, String string) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        return new Dimension((int)rectangle2D.getWidth(), fontMetrics.getAscent() - fontMetrics.getDescent());
    }

    public void drawStringCentered(Graphics2D graphics2D, String string, double d, double d2) {
        Dimension dimension = this.getStringDimension(graphics2D, string);
        d -= (double)dimension.width / 2.0;
        d2 += (double)dimension.height / 2.0;
        if (this._debug) {
            graphics2D.drawRect((int)d, (int)d2 - dimension.height, dimension.width, dimension.height);
        }
        graphics2D.drawString(string, (int)Math.round(d), (int)Math.round(d2));
    }

    public abstract RelativePosition getConnectedEdge(RelativePosition var1);

    public abstract Point2D.Double getEdgePosition(RelativePosition var1);

    public abstract void setEdgePosition(RelativePosition var1, Point2D.Double var2);

    public abstract RelativePosition relativePositionFromEdgeEndPointPosition(RNATemplate.EdgeEndPointPosition var1);

    public static boolean canConnect(GraphicalTemplateElement graphicalTemplateElement, RelativePosition relativePosition, GraphicalTemplateElement graphicalTemplateElement2, RelativePosition relativePosition2) {
        return !graphicalTemplateElement.hasAttachedElement(relativePosition) && !graphicalTemplateElement2.hasAttachedElement(relativePosition2) && graphicalTemplateElement.isIn(relativePosition) != graphicalTemplateElement2.isIn(relativePosition2);
    }

    protected void drawMove(Graphics2D graphics2D, Point2D.Double double_) {
        graphics2D.setStroke(this._solidStroke);
        graphics2D.setColor(CONTROL_COLOR);
        graphics2D.fillOval((int)(double_.x - 13.0), (int)(double_.y - 13.0), 26, 26);
        graphics2D.setColor(BACKBONE_COLOR);
        graphics2D.drawOval((int)(double_.x - 13.0), (int)(double_.y - 13.0), 26, 26);
        double d = 11.0;
        double d2 = 3.0;
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x + d, double_.y), d2);
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x - d, double_.y), d2);
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x, double_.y + d), d2);
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x, double_.y - d), d2);
    }

    protected void drawEditStart(Graphics2D graphics2D, Helix helix, double d, double d2, double d3, double d4) {
        Point2D.Double double_ = helix.getCenterEditStart();
        this.drawEdit(graphics2D, double_, d, d2, d3, d4);
    }

    protected void drawEditEnd(Graphics2D graphics2D, Helix helix, double d, double d2, double d3, double d4) {
        Point2D.Double double_ = helix.getCenterEditEnd();
        this.drawEdit(graphics2D, double_, d, d2, d3, d4);
    }

    protected void drawEdit(Graphics2D graphics2D, Point2D.Double double_, double d, double d2, double d3, double d4) {
        graphics2D.setColor(CONTROL_COLOR);
        graphics2D.fillOval((int)(double_.x - 10.0), (int)(double_.y - 10.0), 20, 20);
        graphics2D.setColor(BACKBONE_COLOR);
        graphics2D.drawOval((int)(double_.x - 10.0), (int)(double_.y - 10.0), 20, 20);
        double d5 = 8.0;
        double d6 = 3.0;
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x + d3 * d5, double_.y + d4 * d5), d6);
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x - d3 * d5, double_.y - d4 * d5), d6);
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x + d * d5, double_.y + d2 * d5), d6);
        this.drawArrow(graphics2D, double_, new Point2D.Double(double_.x - d * d5, double_.y - d2 * d5), d6);
    }

    protected void drawArrow(Graphics2D graphics2D, Point2D.Double double_, Point2D.Double double_2, double d) {
        double d2;
        graphics2D.setStroke(this._solidStroke);
        graphics2D.drawLine((int)double_.x, (int)double_.y, (int)double_2.x, (int)double_2.y);
        double d3 = (double_.x - double_2.x) / double_.distance(double_2);
        double d4 = d2 = (double_.y - double_2.y) / double_.distance(double_2);
        double d5 = -d3;
        graphics2D.drawLine((int)double_2.x, (int)double_2.y, (int)(double_2.x - d * (-d3 + d4)), (int)(double_2.y - d * (-d2 + d5)));
        graphics2D.drawLine((int)double_2.x, (int)double_2.y, (int)(double_2.x - d * (-d3 - d4)), (int)(double_2.y - d * (-d2 - d5)));
    }

    protected void drawAnchor(Graphics2D graphics2D, Point2D.Double double_) {
        this.drawAnchor(graphics2D, double_, CONTROL_COLOR);
    }

    protected void drawAnchor5(Graphics2D graphics2D, Point2D.Double double_) {
        this.drawAnchor(graphics2D, double_, BASE_FILL_5_COLOR);
    }

    protected void drawAnchor3(Graphics2D graphics2D, Point2D.Double double_) {
        this.drawAnchor(graphics2D, double_, BASE_FILL_3_COLOR);
    }

    protected void drawAnchor(Graphics2D graphics2D, Point2D.Double double_, Color color) {
        graphics2D.setColor(color);
        graphics2D.fillOval((int)(double_.x - 7.0), (int)(double_.y - 7.0), 14, 14);
        graphics2D.setColor(BASE_COLOR);
        graphics2D.drawOval((int)(double_.x - 7.0), (int)(double_.y - 7.0), 14, 14);
    }

    protected void drawMagnet(Graphics2D graphics2D, Point2D.Double double_) {
        this.drawAnchor(graphics2D, double_, MAGNET_COLOR);
        graphics2D.setColor(BASE_COLOR);
        graphics2D.drawOval((int)(double_.x - 7.0), (int)(double_.y - 7.0), 14, 14);
        graphics2D.drawOval((int)(double_.x - 2.0), (int)(double_.y - 2.0), 4, 4);
    }

    protected void drawBase(Graphics2D graphics2D, Point2D.Double double_) {
        graphics2D.setColor(BASE_FILL_COLOR);
        graphics2D.fillOval((int)(double_.x - 8.0), (int)(double_.y - 8.0), 16, 16);
        graphics2D.setColor(BASE_COLOR);
        graphics2D.drawOval((int)(double_.x - 8.0), (int)(double_.y - 8.0), 16, 16);
    }

    public boolean equals(Object object) {
        if (object instanceof GraphicalTemplateElement) {
            return object == this;
        }
        return false;
    }

    public static enum RelativePosition {
        RP_OUTER,
        RP_INNER_GENERAL,
        RP_INNER_MOVE,
        RP_EDIT_START,
        RP_EDIT_END,
        RP_CONNECT_START5,
        RP_CONNECT_START3,
        RP_CONNECT_END5,
        RP_CONNECT_END3,
        RP_EDIT_TANGENT_3,
        RP_EDIT_TANGENT_5;

    }
}

