/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.applications;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.controlers.ControleurInterpolator;
import fr.orsay.lri.varna.exceptions.ExceptionDrawingAlgorithm;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionModeleStyleBaseSyntaxError;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionParameterError;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.exceptions.MappingException;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.rna.Mapping;
import fr.orsay.lri.varna.models.rna.ModelBaseStyle;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SuperpositionDemo
extends JFrame
implements InterfaceVARNAListener {
    private static final long serialVersionUID = -790155708306987257L;
    private static final String DEFAULT_SEQUENCE1 = "CGCGCACGCGAUAUUUCGCGUCGCGCAUUUGCGCGUAGCGCG";
    private static final String DEFAULT_SEQUENCE2 = "CGCGCACGCGAUAUUUCGCGUCGCGCAUUUGCGCGUAGCGCG";
    private static final String DEFAULT_STRUCTURE1 = "(((((.(((((----....----))))).(((((....)))))..)))))";
    private static final String DEFAULT_STRUCTURE2 = "(((((.(((((((((....))))))))).--------------..)))))";
    private VARNAPanel _vpMaster;
    private VARNAPanel _vpSlave;
    private JPanel _tools = new JPanel();
    private JPanel _input = new JPanel();
    private JPanel _seqPanel = new JPanel();
    private JPanel _struct1Panel = new JPanel();
    private JPanel _struct2Panel = new JPanel();
    private JLabel _info = new JLabel();
    private JTextField _struct1 = new JTextField("(((((.(((((----....----))))).(((((....)))))..)))))");
    private JTextField _struct2 = new JTextField("(((((.(((((((((....))))))))).--------------..)))))");
    private JTextField _seq1 = new JTextField("CGCGCACGCGAUAUUUCGCGUCGCGCAUUUGCGCGUAGCGCG");
    private JTextField _seq2 = new JTextField("CGCGCACGCGAUAUUUCGCGUCGCGCAUUUGCGCGUAGCGCG");
    private JLabel _struct1Label = new JLabel(" Str1:");
    private JLabel _struct2Label = new JLabel(" Str2:");
    private JLabel _seqLabel = new JLabel(" Seq:");
    private JButton _goButton = new JButton("Go");
    private JButton _switchButton = new JButton("Switch");
    private String _str1Backup = "";
    private String _str2Backup = "";
    private RNA _RNA1 = new RNA();
    private RNA _RNA2 = new RNA();
    private static String errorOpt = "error";
    private boolean _error;
    private Color _backgroundColor = Color.white;
    private int _algoCode;
    private int _currentDisplay = 1;

    public static ModelBaseStyle createStyle(String string) {
        ModelBaseStyle modelBaseStyle = new ModelBaseStyle();
        try {
            modelBaseStyle.assignParameters(string);
        }
        catch (ExceptionModeleStyleBaseSyntaxError exceptionModeleStyleBaseSyntaxError) {
            exceptionModeleStyleBaseSyntaxError.printStackTrace();
        }
        catch (ExceptionParameterError exceptionParameterError) {
            exceptionParameterError.printStackTrace();
        }
        return modelBaseStyle;
    }

    public void applyTo(VARNAPanel vARNAPanel, ModelBaseStyle modelBaseStyle, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            ModeleBase modeleBase = vARNAPanel.getRNA().getBaseAt(nArray[i]);
            modeleBase.setStyleBase(modelBaseStyle);
            if (modeleBase.getElementStructure() == -1) continue;
            vARNAPanel.getRNA().getBaseAt(modeleBase.getElementStructure()).setStyleBase(modelBaseStyle);
        }
        vARNAPanel.repaint();
    }

    public SuperpositionDemo() {
        try {
            this._vpMaster = new VARNAPanel(this.getText1(), this.getStruct1());
            this._vpSlave = new VARNAPanel(this.getText2(), this.getStruct2());
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            this._vpMaster.errorDialog(exceptionNonEqualLength);
        }
        this._vpMaster.setPreferredSize(new Dimension(400, 400));
        this.RNAPanelDemoInit();
    }

    private void RNAPanelDemoInit() {
        int n = 40;
        this.setBackground(this._backgroundColor);
        this._vpMaster.setBackground(this._backgroundColor);
        this._vpMaster.addVARNAListener(this);
        this._vpSlave.setBackground(Color.decode("#F0F0F0"));
        this._vpMaster.drawRNA(this.getRNA(this._currentDisplay % 2));
        this._vpSlave.drawRNA(this.getRNA((this._currentDisplay + 1) % 2));
        Font font = Font.decode("MonoSpaced-PLAIN-12");
        this._seqLabel.setHorizontalTextPosition(2);
        this._seqLabel.setPreferredSize(new Dimension(n, 15));
        this._seq1.setFont(font);
        this._seq1.setText(this.getRNA1().getSeq());
        this._seq2.setFont(font);
        this._seq2.setText(this.getRNA2().getSeq());
        this._goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SuperpositionDemo.this._currentDisplay = (SuperpositionDemo.this._currentDisplay + 1) % 2;
                SuperpositionDemo.this._vpMaster.drawRNA(SuperpositionDemo.this.getRNA(SuperpositionDemo.this._currentDisplay));
                SuperpositionDemo.this._vpSlave.drawRNA(SuperpositionDemo.this.getRNA((SuperpositionDemo.this._currentDisplay + 1) % 2));
                SuperpositionDemo.this.onStructureRedrawn();
            }
        });
        this._switchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SuperpositionDemo.this._currentDisplay = (SuperpositionDemo.this._currentDisplay + 1) % 2;
                    Mapping mapping = Mapping.readMappingFromAlignment(SuperpositionDemo.this.getStruct(SuperpositionDemo.this._currentDisplay), SuperpositionDemo.this.getStruct((SuperpositionDemo.this._currentDisplay + 1) % 2));
                    Mapping mapping2 = Mapping.readMappingFromAlignment(SuperpositionDemo.this.getStruct((SuperpositionDemo.this._currentDisplay + 1) % 2), SuperpositionDemo.this.getStruct(SuperpositionDemo.this._currentDisplay));
                    SuperpositionDemo.this._vpMaster.showRNAInterpolated(SuperpositionDemo.this.getRNA(SuperpositionDemo.this._currentDisplay), mapping);
                    SuperpositionDemo.this._vpSlave.showRNAInterpolated(SuperpositionDemo.this.getRNA((SuperpositionDemo.this._currentDisplay + 1) % 2), mapping2);
                    SuperpositionDemo.this.onStructureRedrawn();
                }
                catch (MappingException mappingException) {
                    try {
                        SuperpositionDemo.this._vpMaster.drawRNAInterpolated(SuperpositionDemo.this.getText(SuperpositionDemo.this._currentDisplay), SuperpositionDemo.this.getStruct(SuperpositionDemo.this._currentDisplay));
                    }
                    catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                        exceptionNonEqualLength.printStackTrace();
                    }
                }
                SuperpositionDemo.this._vpMaster.repaint();
                SuperpositionDemo.this._vpSlave.repaint();
            }
        });
        this._seqPanel.setLayout(new BorderLayout());
        this._seqPanel.add((Component)this._seqLabel, "West");
        this._seqPanel.add((Component)this._seq1, "Center");
        this._struct1Label.setPreferredSize(new Dimension(n, 15));
        this._struct1Label.setHorizontalTextPosition(2);
        this._struct1.setFont(font);
        this._struct1Panel.setLayout(new BorderLayout());
        this._struct1Panel.add((Component)this._struct1Label, "West");
        this._struct1Panel.add((Component)this._struct1, "Center");
        this._struct2Label.setPreferredSize(new Dimension(n, 15));
        this._struct2Label.setHorizontalTextPosition(2);
        this._struct2.setFont(font);
        this._struct2Panel.setLayout(new BorderLayout());
        this._struct2Panel.add((Component)this._struct2Label, "West");
        this._struct2Panel.add((Component)this._struct2, "Center");
        this._input.setLayout(new GridLayout(3, 0));
        this._input.add(this._seqPanel);
        this._input.add(this._struct1Panel);
        this._input.add(this._struct2Panel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._tools.setLayout(new BorderLayout());
        this._tools.add((Component)this._input, "Center");
        this._tools.add((Component)this._info, "South");
        this._tools.add((Component)jPanel, "East");
        jPanel.add((Component)this._goButton, "Center");
        jPanel.add((Component)this._switchButton, "South");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this._vpMaster);
        jPanel2.add(this._vpSlave);
        this.getContentPane().add((Component)jPanel2, "Center");
        this.getContentPane().add((Component)this._tools, "South");
        this.setVisible(true);
        this._vpMaster.getVARNAUI().UIRadiate();
        this._vpSlave.getVARNAUI().UIRadiate();
        this.onStructureRedrawn();
    }

    public RNA getMasterRNA() {
        return this.getRNA(this._currentDisplay);
    }

    public RNA getSlaveRNA1() {
        return this.getRNA((this._currentDisplay + 1) % 2);
    }

    public RNA getSlaveRNA2() {
        return this.getRNA((this._currentDisplay + 2) % 2);
    }

    public RNA getRNA(int n) {
        if (n == 0) {
            return this.getRNA1();
        }
        return this.getRNA2();
    }

    public RNA getRNA1() {
        if (!this._str1Backup.equals(this.getStruct1())) {
            try {
                this._RNA1.setRNA(this.getText1(), this.getStruct1());
                this._RNA1.drawRNA(this._vpMaster.getDrawMode(), this._vpMaster.getConfig());
            }
            catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                exceptionUnmatchedClosingParentheses.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                this._vpMaster.errorDialog(exceptionFileFormatOrSyntax);
            }
            catch (ExceptionDrawingAlgorithm exceptionDrawingAlgorithm) {
                exceptionDrawingAlgorithm.printStackTrace();
            }
            this._str1Backup = this.getStruct1();
        }
        return this._RNA1;
    }

    public RNA getRNA2() {
        if (!this._str2Backup.equals(this.getStruct2())) {
            try {
                this._RNA2.setRNA(this.getText2(), this.getStruct2());
                this._RNA2.drawRNA(this._vpMaster.getDrawMode(), this._vpMaster.getConfig());
            }
            catch (ExceptionUnmatchedClosingParentheses exceptionUnmatchedClosingParentheses) {
                exceptionUnmatchedClosingParentheses.printStackTrace();
            }
            catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
                this._vpMaster.errorDialog(exceptionFileFormatOrSyntax);
            }
            catch (ExceptionDrawingAlgorithm exceptionDrawingAlgorithm) {
                exceptionDrawingAlgorithm.printStackTrace();
            }
            this._str2Backup = this.getStruct2();
        }
        return this._RNA2;
    }

    public String getText(int n) {
        return "";
    }

    public String getStruct(int n) {
        if (n == 0) {
            return this._struct1.getText();
        }
        return this._struct2.getText();
    }

    public String getText1() {
        return this._seq1.getText();
    }

    public String getText2() {
        return this._seq2.getText();
    }

    public String getStruct1() {
        return this.cleanStruct(this._struct1.getText());
    }

    public String getStruct2() {
        return this.cleanStruct(this._struct2.getText());
    }

    private String cleanStruct(String string) {
        string = string.replaceAll("[:-]", "");
        return string;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"sequenceDBN", "String", "A raw RNA sequence"}, {"structureDBN", "String", "An RNA structure in dot bracket notation (DBN)"}, {errorOpt, "boolean", "To show errors"}};
        return stringArray;
    }

    public void init() {
        this._vpMaster.setBackground(this._backgroundColor);
        this._error = true;
    }

    private Color getSafeColor(String string, Color color) {
        Color color2;
        try {
            color2 = Color.decode(string);
        }
        catch (Exception exception) {
            try {
                color2 = Color.getColor(string, color);
            }
            catch (Exception exception2) {
                return color;
            }
        }
        return color2;
    }

    public VARNAPanel get_varnaPanel() {
        return this._vpMaster;
    }

    public void set_varnaPanel(VARNAPanel vARNAPanel) {
        this._vpMaster = vARNAPanel;
    }

    public JTextField get_struct() {
        return this._struct1;
    }

    public void set_struct(JTextField jTextField) {
        this._struct1 = jTextField;
    }

    public JLabel get_info() {
        return this._info;
    }

    public void set_info(JLabel jLabel) {
        this._info = jLabel;
    }

    public static void main(String[] stringArray) {
        SuperpositionDemo superpositionDemo = new SuperpositionDemo();
        superpositionDemo.setDefaultCloseOperation(3);
        superpositionDemo.pack();
        superpositionDemo.setVisible(true);
    }

    @Override
    public void onStructureRedrawn() {
        try {
            Mapping mapping = Mapping.readMappingFromAlignment(this.getStruct((this._currentDisplay + 1) % 2), this.getStruct(this._currentDisplay % 2));
            ControleurInterpolator.moveNearOtherRNA(this.getRNA(this._currentDisplay % 2), this.getRNA((this._currentDisplay + 1) % 2), mapping);
            this._vpSlave.repaint();
            this._vpMaster.repaint();
        }
        catch (MappingException mappingException) {
            System.out.println(mappingException.toString());
        }
    }

    @Override
    public void onWarningEmitted(String string) {
    }

    public void onLoad(String string) {
    }

    public void onLoaded() {
    }

    @Override
    public void onUINewStructure(VARNAConfig vARNAConfig, RNA rNA) {
    }

    @Override
    public void onZoomLevelChanged() {
    }

    @Override
    public void onTranslationChanged() {
    }
}

