/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.io.InputStream;
import javajs.util.JSThread;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;

public class JSAudioThread
extends JSThread {
    protected Owner owner;
    protected boolean done;
    protected int myBufferLength;
    protected SourceDataLine line;
    protected int rate;
    protected int nChannels;
    protected int bitsPerSample;
    protected byte[] audioByteBuffer;
    protected int audioBufferByteLength;
    private AudioFormat audioFormat;
    private int myBufferOffset;
    private int playCount;

    public JSAudioThread(Owner owner, AudioFormat audioFormat, byte[] audioByteBuffer) {
        this.owner = owner;
        this.setFormat(audioFormat);
        this.setBuffer(audioByteBuffer);
    }

    public JSAudioThread(Owner owner, int rate, int bitsPerSample, int nChannels, byte[] audioByteBuffer) {
        this.owner = owner;
        this.setFormat(new AudioFormat(rate, bitsPerSample, nChannels, true, false));
        this.setBuffer(audioByteBuffer);
    }

    public JSAudioThread() {
    }

    public JSAudioThread(AudioFormat audioFormat) {
        this.setFormat(audioFormat);
    }

    public void playULawData(byte[] data) {
        AudioPlayer.player.start((InputStream)new AudioDataStream(new AudioData(data)));
    }

    public void playOnce(byte[] data, int offset, int length) {
        this.setBuffer(data);
        this.myBufferOffset = offset;
        this.myBufferLength = length;
        this.playCount = 1;
        this.start();
    }

    public void setBuffer(byte[] audioByteBuffer) {
        this.audioByteBuffer = audioByteBuffer;
        this.audioBufferByteLength = audioByteBuffer.length;
    }

    public SourceDataLine getLine() {
        return this.line;
    }

    public AudioFormat getFormat() {
        return this.audioFormat;
    }

    public void setFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
        this.rate = (int)audioFormat.getSampleRate();
        this.bitsPerSample = audioFormat.getSampleSizeInBits();
        this.nChannels = audioFormat.getChannels();
    }

    public void resetAudio() {
        if (this.line == null) {
            return;
        }
        this.line.flush();
        this.line.close();
        this.line = null;
    }

    @Override
    protected boolean myInit() {
        try {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.audioFormat);
            if (this.line != null) {
                this.line.close();
            }
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(this.audioFormat, this.audioBufferByteLength);
            this.line.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLooping() {
        return !this.done && (--this.playCount >= 0 || this.owner != null && this.owner.checkSoundStatus());
    }

    @Override
    protected boolean myLoop() {
        if (!this.done) {
            this.myBufferLength = this.owner == null ? this.myBufferLength : this.owner.fillAudioBuffer();
            if (this.myBufferLength <= 0) {
                this.done = true;
                return !true;
            }
            try {
                if (this.line == null) {
                    this.myInit();
                }
                this.line.write(this.audioByteBuffer, this.myBufferOffset, this.myBufferLength);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.done = true;
            }
        }
        return !this.done;
    }

    @Override
    protected void whenDone() {
        this.done = true;
    }

    @Override
    protected int getDelayMillis() {
        return 1000 * (this.myBufferLength * 8 / this.bitsPerSample) / this.rate / this.nChannels / 4;
    }

    @Override
    protected void onException(Exception e) {
        e.printStackTrace();
    }

    @Override
    protected void doFinally() {
        if (this.owner != null) {
            this.owner.audioThreadExiting();
        }
    }

    public static interface Owner {
        public boolean checkSoundStatus();

        public int fillAudioBuffer();

        public void audioThreadExiting();
    }
}

