/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Console;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.Datasetsequence;
import jalview.io.vamsas.DatastoreItem;
import jalview.io.vamsas.Rangetype;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.DbRef;
import uk.ac.vamsas.objects.core.Map;
import uk.ac.vamsas.objects.core.MapType;
import uk.ac.vamsas.objects.core.Sequence;

public class Dbref
extends Rangetype {
    SequenceI sq = null;
    Sequence sequence = null;
    DataSet ds;

    public Dbref(VamsasAppDatastore datastore, DBRefEntry dbentry, SequenceI sq2, Sequence sequence2, DataSet dataset) {
        super(datastore, dbentry, DbRef.class);
        this.sq = sq2;
        this.sequence = sequence2;
        this.jvobj = dbentry;
        this.ds = dataset;
        this.doSync();
    }

    public Dbref(VamsasAppDatastore datastore, DbRef ref, Sequence vdseq, SequenceI dsseq) {
        super(datastore, (Vobject)ref, DBRefEntry.class);
        this.sequence = vdseq;
        this.sq = dsseq;
        this.ds = (DataSet)vdseq.getV_parent();
        this.doJvUpdate();
    }

    @Override
    public void updateToDoc() {
        DbRef dbref = (DbRef)this.vobj;
        DBRefEntry jvobj = (DBRefEntry)this.jvobj;
        dbref.setAccessionId(jvobj.getAccessionId());
        dbref.setSource(jvobj.getSource());
        dbref.setVersion(jvobj.getVersion());
        if (jvobj.getMap() != null) {
            Mapping mp = jvobj.getMap();
            if (mp.getMap() != null) {
                Map vMap = null;
                if (dbref.getMapCount() == 0) {
                    vMap = new Map();
                    this.initMapType((MapType)vMap, mp.getMap(), true);
                    dbref.addMap(vMap);
                } else {
                    vMap = dbref.getMap(0);
                    this.initMapType((MapType)vMap, mp.getMap(), true);
                }
                this.updateMapTo(mp);
            }
        } else {
            Console.debug("Ignoring mapless DbRef.Map " + jvobj.getSrcAccString());
        }
    }

    private void updateMapTo(Mapping mp) {
        log.info("Performing updateMapTo remove this message when we know what we're doing.");
        if (mp != null && mp.getTo() != null) {
            DatastoreItem dssync;
            if (mp.getTo().getDatasetSequence() == null && (dssync = this.dsReg.getDatastoreItemFor(mp.getTo())) == null) {
                Datasetsequence datasetsequence = new Datasetsequence(this.datastore, mp.getTo(), mp.getMappedWidth() == mp.getWidth() ? this.sequence.getDictionary() : (mp.getMappedWidth() == 3 ? "info:iubmb.org/nucleosides" : "info:iubmb.org/aminoacids"), this.ds);
            }
        } else {
            log.debug("Ignoring non-dataset sequence mapping.");
        }
    }

    @Override
    public void updateFromDoc() {
        DbRef vobj = (DbRef)this.vobj;
        DBRefEntry jvobj = (DBRefEntry)this.jvobj;
        jvobj.setAccessionId(vobj.getAccessionId());
        jvobj.setSource(vobj.getSource());
        jvobj.setVersion(vobj.getVersion());
        if (vobj.getMapCount() > 0) {
            if (vobj.getMapCount() > 1) {
                Console.debug("Ignoring additional mappings on DbRef: " + jvobj.getSource() + ":" + jvobj.getAccessionId());
            }
            Mapping mp = new Mapping(this.parsemapType((MapType)vobj.getMap(0)));
            if (jvobj.getMap() == null || !mp.equals(jvobj.getMap())) {
                jvobj.setMap(mp);
            }
        }
    }

    @Override
    public void conflict() {
        DbRef vobj = (DbRef)this.vobj;
        DBRefEntry jvobj = (DBRefEntry)this.jvobj;
        Console.debug("Conflict in dbentry update for " + vobj.getAccessionId() + vobj.getSource() + " " + vobj.getVorbaId());
    }

    @Override
    public void addFromDocument() {
        DbRef vobj = (DbRef)this.vobj;
        DBRefEntry jvobj = (DBRefEntry)this.jvobj;
        jvobj = new DBRefEntry(vobj.getSource().toString(), vobj.getVersion().toString(), vobj.getAccessionId().toString());
        this.sq.addDBRef(jvobj);
        if (vobj.getMapCount() > 0) {
            if (vobj.getMapCount() > 1) {
                Console.debug("Ignoring additional mappings on DbRef: " + jvobj.getSource() + ":" + jvobj.getAccessionId());
            }
            Mapping mp = new Mapping(this.parsemapType((MapType)vobj.getMap(0)));
            jvobj.setMap(mp);
        }
        this.bindjvvobj(jvobj, (Vobject)vobj);
    }

    @Override
    public void addToDocument() {
        DBRefEntry jvobj = (DBRefEntry)this.jvobj;
        DbRef dbref = new DbRef();
        this.bindjvvobj(jvobj, (Vobject)dbref);
        dbref.setAccessionId(jvobj.getAccessionId());
        dbref.setSource(jvobj.getSource());
        dbref.setVersion(jvobj.getVersion());
        this.sequence.addDbRef(dbref);
        if (jvobj.getMap() != null) {
            Mapping mp = jvobj.getMap();
            if (mp.getMap() != null) {
                Map vMap = new Map();
                this.initMapType((MapType)vMap, mp.getMap(), true);
                dbref.addMap(vMap);
                this.updateMapTo(mp);
            } else {
                Console.debug("Ignoring mapless DbRef.Map " + jvobj.getSrcAccString());
            }
        }
    }
}

