/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.core;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DecimalFormatTableCellRenderer
extends DefaultTableCellRenderer {
    private DecimalFormat formatter;

    public DecimalFormatTableCellRenderer(boolean isFormated, int significantFigures) {
        String fractionFormater;
        String integerFormater = isFormated ? "###,##0" : "0";
        String string = fractionFormater = isFormated ? "###,##0." : "0.";
        if (significantFigures > 0) {
            StringBuilder significantFigureBuilder = new StringBuilder();
            for (int x = 1; x <= significantFigures; ++x) {
                significantFigureBuilder.append("0");
            }
            this.formatter = new DecimalFormat(fractionFormater + significantFigureBuilder.toString());
        } else {
            this.formatter = new DecimalFormat(integerFormater);
        }
        super.setHorizontalAlignment(4);
    }

    public DecimalFormatTableCellRenderer() {
        super.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        value = value == null ? "" : this.formatter.format(value);
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }
}

