/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenSequences;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class VisibleRowsIterator
implements Iterator<Integer> {
    private int last;
    private int current;
    private int next;
    private HiddenSequences hidden;
    private AlignmentI al;

    public VisibleRowsIterator(int firstrow, int lastrow, AlignmentI alignment) {
        this.al = alignment;
        this.current = firstrow;
        this.last = lastrow;
        this.hidden = this.al.getHiddenSequences();
        while (this.last > this.current && this.hidden.isHidden(this.last)) {
            --this.last;
        }
        this.current = firstrow;
        while (this.current < this.last && this.hidden.isHidden(this.current)) {
            ++this.current;
        }
        this.next = this.current;
    }

    @Override
    public boolean hasNext() {
        return this.next <= this.last;
    }

    @Override
    public Integer next() {
        if (this.next > this.last) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        do {
            ++this.next;
        } while (this.next <= this.last && this.hidden.isHidden(this.next));
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

