/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.components.ColorRenderer;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class VueRNAList
extends JPanel
implements TableModelListener,
ActionListener {
    private JTable table;
    private ValueTableModel _tm;
    private ArrayList<RNA> data;
    private ArrayList<Object> columns;
    private ArrayList<Boolean> included;

    public VueRNAList(ArrayList<RNA> arrayList) {
        super(new BorderLayout());
        this.data = arrayList;
        this.init();
    }

    public ArrayList<RNA> getSelectedRNAs() {
        ArrayList<RNA> arrayList = new ArrayList<RNA>();
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.included.get(i).booleanValue()) continue;
            arrayList.add(this.data.get(i));
        }
        return arrayList;
    }

    private void init() {
        int n;
        Object[] objectArray = new Object[]{"Num", "Selected", "Name", "ID", "Length"};
        this.columns = new ArrayList();
        for (n = 0; n < objectArray.length; ++n) {
            this.columns.add(objectArray[n]);
        }
        this.included = new ArrayList();
        for (n = 0; n < this.data.size(); ++n) {
            this.included.add(new Boolean(true));
        }
        this._tm = new ValueTableModel();
        this.table = new JTable(this._tm);
        this.table.setDefaultRenderer(Color.class, new ColorRenderer(true));
        this.table.setPreferredScrollableViewportSize(new Dimension(600, 300));
        this.table.setAutoResizeMode(0);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(30);
        TableColumn tableColumn2 = this.table.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(30);
        TableColumn tableColumn3 = this.table.getColumnModel().getColumn(2);
        tableColumn3.setPreferredWidth(200);
        TableColumn tableColumn4 = this.table.getColumnModel().getColumn(3);
        tableColumn4.setPreferredWidth(200);
        TableColumn tableColumn5 = this.table.getColumnModel().getColumn(4);
        tableColumn5.setPreferredWidth(30);
        this.table.setAutoResizeMode(4);
        this.table.getModel().addTableModelListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        this.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "East");
        jPanel.add((Component)new JLabel("Please select which model(s) should be imported."), "South");
        JButton jButton = new JButton("Select All");
        jButton.addActionListener(this);
        jButton.setActionCommand("all");
        JButton jButton2 = new JButton("Deselect All");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("none");
        jPanel2.add(jButton);
        jPanel3.add(jButton2);
        this.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel, "South");
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent.getType() == 0) {
            this.table.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("none")) {
            for (int i = 0; i < this.included.size(); ++i) {
                this.included.set(i, false);
            }
            this._tm.fireTableRowsUpdated(0, this.included.size() - 1);
        } else if (actionEvent.getActionCommand().equals("all")) {
            for (int i = 0; i < this.included.size(); ++i) {
                this.included.set(i, true);
            }
            this._tm.fireTableRowsUpdated(0, this.included.size() - 1);
        }
    }

    private class ValueTableModel
    extends AbstractTableModel {
        private ValueTableModel() {
        }

        @Override
        public String getColumnName(int n) {
            return VueRNAList.this.columns.get(n).toString();
        }

        @Override
        public int getRowCount() {
            return VueRNAList.this.data.size();
        }

        @Override
        public int getColumnCount() {
            return VueRNAList.this.columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            RNA rNA = (RNA)VueRNAList.this.data.get(n);
            if (n2 == 0) {
                return new Integer(n + 1);
            }
            if (n2 == 1) {
                return new Boolean((Boolean)VueRNAList.this.included.get(n));
            }
            if (n2 == 2) {
                return new String(rNA.getName());
            }
            if (n2 == 3) {
                return new String(rNA.getID());
            }
            if (n2 == 4) {
                return new Integer(rNA.getSize());
            }
            return "N/A";
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 1) {
                VueRNAList.this.included.set(n, (Boolean)object);
                this.fireTableCellUpdated(n, n2);
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }
}

