/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test.objects;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.objects.core.Alignment;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.VAMSAS;
import uk.ac.vamsas.objects.core.VamsasDocument;
import uk.ac.vamsas.objects.utils.DocumentStuff;
import uk.ac.vamsas.objects.utils.ProvenanceStuff;
import uk.ac.vamsas.objects.utils.Seq;
import uk.ac.vamsas.objects.utils.document.VersionEntries;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;

public class Core {
    static Log log = LogFactory.getLog((Class)Core.class);
    public static String user = "uk.ac.vamsas.test.objects.Core";

    public static void complete(DataSet ds) {
        Sequence[] q = ds.getSequence();
        int j = q.length;
        for (int i = 0; i < j; ++i) {
            q[i].setStart(i + 1);
            q[i].setEnd(q[i].getSequence().length() + i + 1);
        }
    }

    public static VAMSAS getDemoVamsas() {
        VAMSAS v = new VAMSAS();
        DataSet ds = new DataSet();
        ds.addSequence(Seq.newSequence("Dummy1", "ASDFLEQ", "info:iubmb.org/aminoacids", 5, 11));
        ds.addSequence(Seq.newSequence("Dummy2", "ASFLEQ", "info:iubmb.org/aminoacids", 5, 10));
        ds.addSequence(Seq.newSequence("Dummy3", "ADFEQ", "info:iubmb.org/aminoacids", 3, 7));
        ds.setProvenance(ProvenanceStuff.newProvenance(user, "constructed some dummy sequences"));
        Core.complete(ds);
        v.addDataSet(ds);
        Alignment al = new Alignment();
        al.setProvenance(ProvenanceStuff.newProvenance(user, "Created dummy alignment"));
        al.addAlignmentSequence(Seq.newAlignmentSequence("Aligned1", "ASDFLEQ", ds.getSequence(0), -1L, -1L));
        al.addAlignmentSequence(Seq.newAlignmentSequence("Aligned2", "AS-FLEQ", ds.getSequence(1), -1L, -1L));
        al.addAlignmentSequence(Seq.newAlignmentSequence("Aligned3", "A-DF-EQ", ds.getSequence(2), -1L, -1L));
        al.setGapChar("-");
        ds.addAlignment(al);
        return v;
    }

    public static void main(String[] args) {
        System.out.println("VersionEntries.compare(invalid, ALPHA) returned " + VersionEntries.compare("invalid", "alpha"));
        System.out.println("VersionEntries.compare(ALPHA, invalid) returned " + VersionEntries.compare("alpha", "invalid"));
        System.out.println("VersionEntries.compare(BETA, ALPHA) returned " + VersionEntries.compare("beta", "alpha"));
        System.out.println("VersionEntries.compare(ALPHA, BETA) returned " + VersionEntries.compare("alpha", "beta"));
        System.out.println("VersionEntries.compare(ALPHA, ALPHA) returned " + VersionEntries.compare("alpha", "alpha"));
        System.out.println("VersionEntries.compare(invalid, invalid) returned " + VersionEntries.compare("invalid", "invalid"));
        System.out.println("VersionEntries.latestVersion()=" + VersionEntries.latestVersion() + ", dict_aa=" + "info:iubmb.org/aminoacids" + ", dict_na=" + "info:iubmb.org/nucleosides");
        VamsasDocument doc = DocumentStuff.newVamsasDocument(new VAMSAS[]{Core.getDemoVamsas()}, ProvenanceStuff.newProvenance("org.vamsas.objects.test.Core", "Created demo vamsasDocument"), VersionEntries.latestVersion());
        ArchiveReports.reportDocument(doc, null, true, System.out);
    }
}

