/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockedFileOutputStream
extends FileOutputStream {
    private static Log log = LogFactory.getLog((Class)LockedFileOutputStream.class);
    boolean closed = true;

    private void init() {
        FileChannel ch = super.getChannel();
        if (ch != null) {
            try {
                this.closed = !ch.isOpen();
            }
            catch (Exception e) {
                this.closed = true;
                log.debug((Object)"Invalid LockedOutputStream marked closed.", (Throwable)e);
            }
        }
    }

    public LockedFileOutputStream(File file) throws FileNotFoundException {
        super(file);
        this.init();
    }

    public LockedFileOutputStream(File file, boolean append) throws FileNotFoundException {
        super(file, append);
        this.init();
    }

    public LockedFileOutputStream(FileDescriptor fdObj) {
        super(fdObj);
        this.init();
        if (fdObj.valid()) {
            this.closed = false;
        }
    }

    public LockedFileOutputStream(String name) throws FileNotFoundException {
        super(name);
        this.init();
    }

    public LockedFileOutputStream(String name, boolean append) throws FileNotFoundException {
        super(name, append);
        this.init();
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("Close on already closed FileOutputStream.");
        }
        super.flush();
        super.getChannel().force(true);
        log.debug((Object)"Marking Lockedoutputstream closed.");
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("flush on closed FileOutputStream");
        }
        super.flush();
    }

    public FileChannel getChannel() {
        if (!this.closed) {
            return super.getChannel();
        }
        return null;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("write on Closed FileOutputStream");
        }
        super.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (this.closed) {
            throw new IOException("write on Closed FileOutputStream");
        }
        super.write(b);
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("write on Closed FileOutputStream");
        }
        super.write(b);
    }
}

