/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.AAFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.workers.AlignCalcWorker;

public class SecondaryStructureConsensusThread
extends AlignCalcWorker {
    public SecondaryStructureConsensusThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.calcMan.isPending(this)) {
            return;
        }
        this.calcMan.notifyStart(this);
        try {
            AlignmentAnnotation ssConsensus = this.getSSConsensusAnnotation();
            if (ssConsensus == null || this.calcMan.isPending(this)) {
                this.calcMan.workerComplete(this);
                return;
            }
            while (!this.calcMan.notifyWorking(this)) {
                try {
                    if (this.ap != null) {
                        this.ap.paintAlignment(false, false);
                    }
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.alignViewport.isClosed()) {
                this.abortAndDestroy();
                return;
            }
            AlignmentI alignment = this.alignViewport.getAlignment();
            int aWidth = -1;
            if (alignment == null || (aWidth = alignment.getWidth()) < 0) {
                this.calcMan.workerComplete(this);
                return;
            }
            this.eraseSSConsensus(aWidth);
            this.computeSSConsensus(alignment);
            this.updateResultAnnotation(true);
            if (this.ap != null) {
                this.ap.paintAlignment(true, true);
            }
        }
        catch (OutOfMemoryError error) {
            this.calcMan.disableWorker(this);
            this.ap.raiseOOMWarning("calculating consensus", error);
        }
        finally {
            this.calcMan.workerComplete(this);
        }
    }

    protected void eraseSSConsensus(int aWidth) {
        AlignmentAnnotation ssConsensus = this.getSSConsensusAnnotation();
        if (ssConsensus != null) {
            ssConsensus.annotations = new Annotation[aWidth];
        }
    }

    protected void computeSSConsensus(AlignmentI alignment) {
        SequenceI[] aseqs = this.getSequences();
        int width = alignment.getWidth();
        ProfilesI hSSConsensus = AAFrequency.calculateSS(aseqs, width, 0, width, true);
        this.alignViewport.setSequenceSSConsensusHash(hSSConsensus);
        this.setColourSchemeConsensus(hSSConsensus);
    }

    protected SequenceI[] getSequences() {
        return this.alignViewport.getAlignment().getSequencesArray();
    }

    protected void setColourSchemeConsensus(ProfilesI hSSconsensus) {
        ResidueShaderI cs = this.alignViewport.getResidueShading();
        if (cs != null) {
            cs.setSsConsensus(hSSconsensus);
        }
    }

    protected AlignmentAnnotation getSSConsensusAnnotation() {
        return this.alignViewport.getAlignmentSecondaryStructureConsensusAnnotation();
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public void updateResultAnnotation(boolean immediate) {
        AlignmentAnnotation ssConsensus = this.getSSConsensusAnnotation();
        ProfilesI hSSConsensus = (ProfilesI)this.getViewportSSConsensus();
        if (immediate || !this.calcMan.isWorking(this) && ssConsensus != null && hSSConsensus != null) {
            this.deriveSSConsensus(ssConsensus, hSSConsensus);
            ssConsensus.hasData = hSSConsensus.getCount() > 0;
        }
    }

    protected void deriveSSConsensus(AlignmentAnnotation ssConsensusAnnotation, ProfilesI hSSConsensus) {
        long nseq = this.getSequences().length;
        AAFrequency.completeSSConsensus(ssConsensusAnnotation, hSSConsensus, hSSConsensus.getStartColumn(), hSSConsensus.getEndColumn() + 1, this.alignViewport.isIgnoreGapsConsensus(), this.alignViewport.isShowSequenceLogo(), nseq);
    }

    protected Object getViewportSSConsensus() {
        return this.alignViewport.getSequenceSSConsensusHash();
    }
}

