/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.bin.Console;
import jalview.util.ErrorLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class HttpUtils {
    public static final String JALVIEWSCHEMEPREFIX = "jalview";

    public static boolean isPlausibleUri(String s) {
        if (s == null) {
            return false;
        }
        if (HttpUtils.startsWithHttpOrHttps(s) || HttpUtils.isJalviewSchemeUri(s)) {
            return true;
        }
        try {
            URI u = new URI(s);
            if (s.startsWith("file:/")) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidUrl(String url) {
        InputStream is = null;
        try {
            is = HttpUtils.openStream(new URL(url));
            if (is != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException x) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean startsWithHttpOrHttps(String file) {
        return file.startsWith("http://") || file.startsWith("https://");
    }

    public static boolean checkUrlAvailable(URL url, int readTimeout) throws IOException, ProtocolException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("HEAD");
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setConnectTimeout(300);
        connection.setReadTimeout(readTimeout);
        HttpURLConnection conn = HttpUtils.followConnection(connection);
        return conn.getResponseCode() == 200;
    }

    public static HttpURLConnection followConnection(HttpURLConnection conn0) throws IOException {
        return HttpUtils.followConnection(conn0, false);
    }

    public static HttpURLConnection followConnection(HttpURLConnection conn0, boolean followAnyway) throws IOException {
        URL url = conn0.getURL();
        if (url == null) {
            return conn0;
        }
        if (!conn0.getInstanceFollowRedirects()) {
            return conn0;
        }
        if (!"http".equals(url.getProtocol()) && !followAnyway) {
            return conn0;
        }
        HttpURLConnection checkConn = (HttpURLConnection)url.openConnection();
        HttpUtils.httpURLConnectionCopyAttributes(conn0, checkConn);
        boolean redirectToHttps = false;
        int response = checkConn.getResponseCode();
        checkConn.disconnect();
        if (response >= 300 && response < 400) {
            URL loc = new URL(conn0.getHeaderField("Location"));
            if (loc != null && "https".equals(loc.getProtocol())) {
                redirectToHttps = true;
                url = loc;
            }
        } else if (followAnyway) {
            url = checkConn.getURL();
        }
        if (!redirectToHttps && !followAnyway) {
            return conn0;
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        HttpUtils.httpURLConnectionCopyAttributes(conn0, conn);
        return conn;
    }

    private static void httpURLConnectionCopyAttributes(HttpURLConnection conn0, HttpURLConnection conn1) throws ProtocolException {
        conn1.setRequestMethod(conn0.getRequestMethod());
        conn1.setDoInput(conn0.getDoInput());
        conn1.setUseCaches(conn0.getUseCaches());
        conn1.setConnectTimeout(conn0.getConnectTimeout());
        conn1.setReadTimeout(conn0.getReadTimeout());
        conn1.setInstanceFollowRedirects(conn0.getInstanceFollowRedirects());
    }

    public static URLConnection openConnection(URL url) throws IOException {
        return HttpUtils.openConnection(url, false);
    }

    public static URLConnection openConnection(URL url, boolean followAnyway) throws IOException {
        HttpURLConnection conn0;
        if (url == null) {
            Console.debug("HttpUtils.openConnection(url) called with null url");
            return null;
        }
        Console.debug("HttpUtils.openConnection(url) called with url=" + url.toString());
        URLConnection conn = null;
        String protocol = url.getProtocol();
        conn = "http".equals(protocol) || "https".equals(protocol) ? ((conn0 = (HttpURLConnection)url.openConnection()) != null ? HttpUtils.followConnection(conn0, followAnyway) : conn0) : url.openConnection();
        return conn;
    }

    public static InputStream openStream(URL url) throws IOException {
        return HttpUtils.openStream(url, false);
    }

    public static InputStream openStream(URL url, boolean followAnyway) throws IOException {
        if (url == null) {
            return null;
        }
        InputStream is = null;
        String protocol = url.getProtocol();
        if ("http".equals(protocol) || "https".equals(protocol)) {
            HttpURLConnection conn = HttpUtils.followConnection((HttpURLConnection)url.openConnection(), followAnyway);
            if (conn != null) {
                is = conn.getInputStream();
            }
        } else {
            is = url.openStream();
        }
        return is;
    }

    public static boolean isJalviewSchemeUri(String jalviewUriString) {
        URI jalviewUri;
        if (jalviewUriString == null) {
            return false;
        }
        try {
            jalviewUri = new URI(jalviewUriString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String scheme = jalviewUri.getScheme();
        if (scheme == null || !scheme.startsWith(JALVIEWSCHEMEPREFIX)) {
            return false;
        }
        int jspl = JALVIEWSCHEMEPREFIX.length();
        return scheme.length() == jspl || scheme.length() == jspl + 1 || scheme.substring(jspl).equals("http") || scheme.substring(jspl).equals("https");
    }

    public static String equivalentJalviewUrl(String jalviewUriString) {
        URI jalviewUri;
        if (!HttpUtils.isJalviewSchemeUri(jalviewUriString)) {
            return jalviewUriString;
        }
        try {
            jalviewUri = new URI(jalviewUriString);
        }
        catch (URISyntaxException e) {
            return null;
        }
        String scheme = jalviewUri.getScheme();
        String host = jalviewUri.getHost();
        if (host != null && host.length() > 0 || scheme.substring(JALVIEWSCHEMEPREFIX.length()).startsWith("http")) {
            try {
                URI newUri = new URI(scheme.equals("jalviewhttp") ? "http" : "https", jalviewUri.getUserInfo(), host, jalviewUri.getPort(), jalviewUri.getPath(), jalviewUri.getQuery(), jalviewUri.getFragment());
                return newUri.toURL().toString();
            }
            catch (MalformedURLException | URISyntaxException e) {
                ErrorLog.errPrintln("Trying to convert '" + jalviewUriString + "' to URL failed");
            }
        } else {
            return jalviewUri.getPath();
        }
        return null;
    }
}

