/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;

public class ColorUtils {
    private static final int MAX_CACHE_SIZE = 1729;
    static Map<String, Color> myColours = new HashMap<String, Color>();

    public static final Color generateRandomColor(Color mix) {
        Random random = new Random();
        int red = random.nextInt(256);
        int green = random.nextInt(256);
        int blue = random.nextInt(256);
        if (mix != null) {
            red = (red + mix.getRed()) / 2;
            green = (green + mix.getGreen()) / 2;
            blue = (blue + mix.getBlue()) / 2;
        }
        Color color = new Color(red, green, blue);
        return color;
    }

    public static final Color getARandomColor() {
        Color col = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
        return col;
    }

    public static final String toTkCode(Color colour) {
        String colstring = "#" + (colour.getRed() < 16 ? "0" : "") + Integer.toHexString(colour.getRed()) + (colour.getGreen() < 16 ? "0" : "") + Integer.toHexString(colour.getGreen()) + (colour.getBlue() < 16 ? "0" : "") + Integer.toHexString(colour.getBlue());
        return colstring;
    }

    public static Color darkerThan(Color col) {
        return col == null ? null : col.darker().darker().darker();
    }

    public static Color brighterThan(Color col) {
        return col == null ? null : col.brighter().brighter().brighter();
    }

    public static Color getGraduatedColour(float value, float minValue, Color minColour, float maxValue, Color maxColour) {
        if (minValue == maxValue) {
            return minColour;
        }
        if (value < minValue) {
            value = minValue;
        }
        if (value > maxValue) {
            value = maxValue;
        }
        float prop = (value - minValue) / (maxValue - minValue);
        float r = (float)minColour.getRed() + prop * (float)(maxColour.getRed() - minColour.getRed());
        float g = (float)minColour.getGreen() + prop * (float)(maxColour.getGreen() - minColour.getGreen());
        float b = (float)minColour.getBlue() + prop * (float)(maxColour.getBlue() - minColour.getBlue());
        return new Color(r / 255.0f, g / 255.0f, b / 255.0f);
    }

    public static Color bleachColour(Color colour, float bleachFactor) {
        if (bleachFactor >= 1.0f) {
            return Color.WHITE;
        }
        if (bleachFactor <= -1.0f) {
            return Color.BLACK;
        }
        if (bleachFactor == 0.0f) {
            return colour;
        }
        int red = colour.getRed();
        int green = colour.getGreen();
        int blue = colour.getBlue();
        if (bleachFactor > 0.0f) {
            red = (int)((float)red + (float)(255 - red) * bleachFactor);
            green = (int)((float)green + (float)(255 - green) * bleachFactor);
            blue = (int)((float)blue + (float)(255 - blue) * bleachFactor);
            return new Color(red, green, blue);
        }
        float factor = 1.0f + bleachFactor;
        red = (int)((float)red * factor);
        green = (int)((float)green * factor);
        blue = (int)((float)blue * factor);
        return new Color(red, green, blue);
    }

    public static Color parseColourString(String colour) {
        if (colour == null) {
            return null;
        }
        colour = colour.trim();
        Color col = null;
        if ("random".equals(colour)) {
            return ColorUtils.generateRandomColor(null);
        }
        try {
            int value = Integer.parseInt(colour, 16);
            col = new Color(value);
        }
        catch (NumberFormatException value) {
            // empty catch block
        }
        if (col == null) {
            col = ColorUtils.getAWTColorFromName(colour);
        }
        if (col == null) {
            try {
                String[] tokens = colour.split(",");
                if (tokens.length == 3) {
                    int r = Integer.parseInt(tokens[0].trim());
                    int g = Integer.parseInt(tokens[1].trim());
                    int b = Integer.parseInt(tokens[2].trim());
                    col = new Color(r, g, b);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return col;
    }

    public static Color createColourFromName(String name) {
        if (name == null) {
            return Color.white;
        }
        if (myColours.containsKey(name)) {
            return myColours.get(name);
        }
        int lsize = name.length();
        int start = 0;
        int end = lsize / 3;
        int rgbOffset = Math.abs(name.hashCode() % 10) * 15;
        int r = Math.abs(name.substring(start, end).hashCode() + rgbOffset) % 210 + 20;
        start = end;
        if ((end += lsize / 3) > lsize) {
            end = lsize;
        }
        int g = Math.abs(name.substring(start, end).hashCode() + rgbOffset) % 210 + 20;
        int b = Math.abs(name.substring(end).hashCode() + rgbOffset) % 210 + 20;
        Color color = new Color(r, g, b);
        if (myColours.size() < 1729) {
            myColours.put(name, color);
        }
        return color;
    }

    public static Color getAWTColorFromName(String name) {
        if (name == null) {
            return null;
        }
        Color col = null;
        switch (name = name.toLowerCase(Locale.ROOT)) {
            case "black": {
                col = Color.black;
                break;
            }
            case "blue": {
                col = Color.blue;
                break;
            }
            case "cyan": {
                col = Color.cyan;
                break;
            }
            case "darkgray": {
                col = Color.darkGray;
                break;
            }
            case "gray": {
                col = Color.gray;
                break;
            }
            case "green": {
                col = Color.green;
                break;
            }
            case "lightgray": {
                col = Color.lightGray;
                break;
            }
            case "magenta": {
                col = Color.magenta;
                break;
            }
            case "orange": {
                col = Color.orange;
                break;
            }
            case "pink": {
                col = Color.pink;
                break;
            }
            case "red": {
                col = Color.red;
                break;
            }
            case "white": {
                col = Color.white;
                break;
            }
            case "yellow": {
                col = Color.yellow;
            }
        }
        return col;
    }
}

