/*
 * Decompiled with CFR 0.152.
 */
package jalview.urls;

import jalview.urls.UrlLinkDisplay;
import jalview.urls.api.UrlProviderI;
import jalview.util.UrlLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class UrlProviderImpl
implements UrlProviderI {
    protected static final int MIN_SUBST_LENGTH = 4;
    private static final Pattern MIRIAM_PATTERN = Pattern.compile("^MIR:\\d{8}$");
    protected String primaryUrl;

    protected String getPrimaryUrl(String seqid, HashMap<String, UrlLink> urls) {
        if (seqid.length() < 4) {
            return null;
        }
        if (this.primaryUrl == null) {
            return null;
        }
        if (!urls.containsKey(this.primaryUrl)) {
            return null;
        }
        String url = null;
        UrlLink urlLink = urls.get(this.primaryUrl);
        String[] primaryUrls = urlLink.makeUrls(seqid, true);
        url = primaryUrls == null || primaryUrls[0] == null || primaryUrls[0].length() < 4 ? null : primaryUrls[1];
        return url;
    }

    @Override
    public List<UrlLinkDisplay> getLinksForTable() {
        return null;
    }

    protected ArrayList<UrlLinkDisplay> getLinksForTable(HashMap<String, UrlLink> urls, ArrayList<String> selectedUrls, boolean selected) {
        ArrayList<UrlLinkDisplay> displayLinks = new ArrayList<UrlLinkDisplay>();
        for (Map.Entry<String, UrlLink> entry : urls.entrySet()) {
            String key = entry.getKey();
            boolean isPrimary = key.equals(this.primaryUrl);
            boolean isSelected = selectedUrls != null ? selectedUrls.contains(key) : selected;
            displayLinks.add(new UrlLinkDisplay(key, entry.getValue(), isSelected, isPrimary));
        }
        return displayLinks;
    }

    protected boolean isMiriamId(String id) {
        return MIRIAM_PATTERN.matcher(id).matches();
    }

    @Override
    public boolean isUserEntry(String id) {
        return !this.isMiriamId(id);
    }
}

