/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.datamodel.PDBEntry;
import jalview.util.MessageManager;
import java.util.Locale;

public class StructureImportSettings {
    private static boolean visibleChainAnnotation = false;
    private static boolean processSecStr = false;
    private static boolean externalSecondaryStructure = false;
    private static boolean showSeqFeatures = true;
    private static PDBEntry.Type defaultStructureFileFormat = PDBEntry.Type.PDB;
    private static StructureParser defaultPDBFileParser = StructureParser.JMOL_PARSER;
    private static TFType temperatureFactorType;

    public static void addSettings(boolean addAlignmentAnnotations, boolean processSecStr, boolean externalSecStr) {
        visibleChainAnnotation = addAlignmentAnnotations;
        StructureImportSettings.processSecStr = processSecStr;
        externalSecondaryStructure = externalSecStr;
        showSeqFeatures = true;
    }

    public static boolean isVisibleChainAnnotation() {
        return visibleChainAnnotation;
    }

    public static void setTemperatureFactorType(TFType t) {
        temperatureFactorType = t;
    }

    public static void setVisibleChainAnnotation(boolean visibleChainAnnotation) {
        StructureImportSettings.visibleChainAnnotation = visibleChainAnnotation;
    }

    public static boolean isProcessSecondaryStructure() {
        return processSecStr;
    }

    public static void setProcessSecondaryStructure(boolean processSecondaryStructure) {
        processSecStr = processSecondaryStructure;
    }

    public static boolean isExternalSecondaryStructure() {
        return externalSecondaryStructure;
    }

    public static void setExternalSecondaryStructure(boolean externalSecondaryStructure) {
        StructureImportSettings.externalSecondaryStructure = externalSecondaryStructure;
    }

    public static boolean isShowSeqFeatures() {
        return showSeqFeatures;
    }

    public static void setShowSeqFeatures(boolean showSeqFeatures) {
        StructureImportSettings.showSeqFeatures = showSeqFeatures;
    }

    public static PDBEntry.Type getDefaultStructureFileFormat() {
        return defaultStructureFileFormat;
    }

    public static void setDefaultStructureFileFormat(String defaultStructureFileFormat) {
        StructureImportSettings.defaultStructureFileFormat = PDBEntry.Type.valueOf(defaultStructureFileFormat.toUpperCase(Locale.ROOT));
    }

    public static String getDefaultPDBFileParser() {
        return defaultPDBFileParser.toString();
    }

    public static void setDefaultPDBFileParser(StructureParser defaultPDBFileParser) {
        StructureImportSettings.defaultPDBFileParser = defaultPDBFileParser;
    }

    public static void setDefaultPDBFileParser(String defaultPDBFileParser) {
        StructureImportSettings.defaultPDBFileParser = StructureParser.valueOf(defaultPDBFileParser.toUpperCase(Locale.ROOT));
    }

    public static TFType getTemperatureFactorType() {
        return temperatureFactorType;
    }

    public static enum TFType {
        DEFAULT,
        PLDDT;


        public String toString() {
            return MessageManager.getString("label.tftype_" + this.name().toLowerCase(Locale.ROOT));
        }
    }

    public static enum StructureParser {
        JMOL_PARSER,
        JALVIEW_PARSER;

    }
}

