/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.DBRefEntry;
import jalview.io.StructureFile;
import jalview.util.CaseInsensitiveString;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;

public class PDBEntry {
    private static final String CHAIN_ID = "chain_code";
    private Hashtable<String, Object> properties;
    private static final int PDB_ID_LENGTH = 4;
    private static final String FAKED_ID = "faked_pdbid";
    private static final String AUTHORITATIVE_ID = "authoritative_pdbid";
    private String file;
    private String type;
    private String id;
    private StructureFile sf = null;
    private static final String RETRIEVE_FROM = "RETRIEVE_FROM";
    private static final String PROVIDER = "PROVIDER";
    private static final String MODELPAGE = "PROVIDERPAGE";
    private static final String PROVIDERCATEGORY = "PROVIDERCATEGORY";

    public boolean equals(Object obj) {
        boolean typeMatches;
        if (obj == null || !(obj instanceof PDBEntry)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PDBEntry o = (PDBEntry)obj;
        boolean idMatches = this.id == o.id || this.id != null && this.id.equalsIgnoreCase(o.id);
        boolean fileMatches = this.file == o.file || this.file != null && this.file.equals(o.file);
        boolean bl = typeMatches = this.type == o.type || this.type != null && this.type.equals(o.type);
        if (idMatches && fileMatches && typeMatches) {
            return this.properties == o.properties || this.properties != null && this.properties.equals(o.properties);
        }
        return false;
    }

    public PDBEntry() {
    }

    public PDBEntry(String pdbId, String chain, Type type, String filePath) {
        this.init(pdbId, chain, type, filePath);
    }

    void init(String pdbId, String chain, Type entryType, String filePath) {
        this.id = pdbId;
        this.type = entryType == null ? null : entryType.toString();
        this.file = filePath;
        this.setChainCode(chain);
    }

    public PDBEntry(PDBEntry entry) {
        this.file = entry.file;
        this.type = entry.type;
        this.id = entry.id;
        if (entry.properties != null) {
            this.properties = (Hashtable)entry.properties.clone();
        }
    }

    public PDBEntry(DBRefEntry dbr) {
        char chain;
        if (!"PDB".equals(dbr.getSource())) {
            throw new IllegalArgumentException("Invalid source: " + dbr.getSource());
        }
        String pdbId = dbr.getAccessionId();
        String chainCode = null;
        if (pdbId.length() == 5 && ('a' <= (chain = pdbId.charAt(4)) && chain <= 'z' || 'A' <= chain && chain <= 'Z')) {
            pdbId = pdbId.substring(0, 4);
            chainCode = String.valueOf(chain);
        }
        this.init(pdbId, chainCode, null, null);
    }

    public void setFile(String f) {
        this.file = f;
    }

    public String getFile() {
        return this.file;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setType(Type type) {
        this.type = type == null ? null : type.toString();
    }

    public String getType() {
        return this.type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setProperty(String key, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public Enumeration<String> getProperties() {
        if (this.properties == null) {
            return Collections.emptyEnumeration();
        }
        return this.properties.keys();
    }

    public String getChainCode() {
        return this.properties == null || this.properties.get(CHAIN_ID) == null ? null : this.properties.get(CHAIN_ID).toString();
    }

    public void setChainCode(String chainCode) {
        if (chainCode == null) {
            this.deleteProperty(CHAIN_ID);
        } else {
            this.setProperty(CHAIN_ID, new CaseInsensitiveString(chainCode));
        }
    }

    Object deleteProperty(String key) {
        Object result = null;
        if (this.properties != null) {
            result = this.properties.remove(key);
        }
        return result;
    }

    public String toString() {
        return this.id;
    }

    @Deprecated
    public Hashtable<String, Object> getProps() {
        return this.properties;
    }

    @Deprecated
    public void setProps(Hashtable<String, Object> props) {
        this.properties = props;
    }

    public boolean updateFrom(PDBEntry newEntry) {
        String newChain;
        if (this.equals(newEntry)) {
            return true;
        }
        String newId = newEntry.getId();
        if (newId == null || this.getId() == null) {
            return false;
        }
        boolean idMatches = this.getId().equalsIgnoreCase(newId);
        String newFile = newEntry.getFile();
        if (newFile != null && this.getFile() != null) {
            if (!newFile.equals(this.getFile())) {
                return false;
            }
            if (!(idMatches || newEntry.fakedPDBId() || this.isAuthoritative())) {
                return false;
            }
        } else if (!idMatches) {
            return false;
        }
        if ((newChain = newEntry.getChainCode()) != null && newChain.length() > 0 && this.getChainCode() != null && this.getChainCode().length() > 0 && !this.getChainCode().equalsIgnoreCase(newChain)) {
            return false;
        }
        String newType = newEntry.getType();
        if (this.getFile() == null && newFile != null) {
            this.setFile(newFile);
            this.setType(newType);
        }
        if (this.getType() == null && newType != null) {
            this.setType(newType);
        }
        if (newChain != null && newChain.length() > 0 && !newChain.equalsIgnoreCase(this.getChainCode())) {
            this.setChainCode(newChain);
        }
        Enumeration<String> newProps = newEntry.getProperties();
        while (newProps.hasMoreElements()) {
            String key = newProps.nextElement();
            Object value = newEntry.getProperty(key);
            if (FAKED_ID.equals(key) || AUTHORITATIVE_ID.equals(key) || value.equals(this.getProperty(key))) continue;
            this.setProperty(key, value);
        }
        return true;
    }

    public void setAuthoritative(boolean isAuthoritative) {
        this.setProperty(AUTHORITATIVE_ID, isAuthoritative);
    }

    public boolean isAuthoritative() {
        if (this._hasProperty(AUTHORITATIVE_ID)) {
            return (Boolean)this.getProperty(AUTHORITATIVE_ID);
        }
        return false;
    }

    public boolean fakedPDBId() {
        return this._hasProperty(FAKED_ID);
    }

    public void setFakedPDBId(boolean faked) {
        if (faked) {
            this.setProperty(FAKED_ID, Boolean.TRUE);
        } else if (this.properties != null) {
            this.properties.remove(FAKED_ID);
        }
    }

    private boolean _hasProperty(String key) {
        return this.properties != null && this.properties.containsKey(key);
    }

    public void setRetrievalUrl(String urlStr) {
        this.setProperty(RETRIEVE_FROM, urlStr);
    }

    public boolean hasRetrievalUrl() {
        return this._hasProperty(RETRIEVE_FROM);
    }

    public String getRetrievalUrl() {
        return (String)this.getProperty(RETRIEVE_FROM);
    }

    public void setProvider(String provider) {
        this.setProperty(PROVIDER, provider);
    }

    public String getProvider() {
        return (String)this.getProperty(PROVIDER);
    }

    public void setProviderPage(String urlStr) {
        this.setProperty(MODELPAGE, urlStr);
    }

    public String getProviderPage() {
        return (String)this.getProperty(MODELPAGE);
    }

    public boolean hasProviderPage() {
        return this._hasProperty(MODELPAGE);
    }

    public boolean hasProvider() {
        return this._hasProperty(PROVIDER);
    }

    public StructureFile getStructureFile() {
        return this.sf;
    }

    public void setStructureFile(StructureFile f) {
        this.sf = f;
    }

    public boolean hasStructureFile() {
        return this.sf != null && this.sf.inFile != null && this.sf.inFile.exists();
    }

    public void setProviderCategory(String providerCategory) {
        this.setProperty(PROVIDERCATEGORY, providerCategory);
    }

    public String getProviderCategory() {
        return (String)this.getProperty(PROVIDERCATEGORY);
    }

    public boolean hasProviderCategory() {
        return this._hasProperty(PROVIDERCATEGORY);
    }

    public static enum Type {
        PDB("pdb", "pdb"),
        MMCIF("mmcif", "cif"),
        BCIF("bcif", "bcif"),
        FILE("?", "?");

        String ext;
        String format;

        private Type(String fmt, String ex) {
            this.format = fmt;
            this.ext = ex;
        }

        public String getFormat() {
            return this.format;
        }

        public String getExtension() {
            return this.ext;
        }

        public static Type getType(String value) {
            for (Type t : Type.values()) {
                if (!t.toString().equalsIgnoreCase(value)) continue;
                return t;
            }
            return null;
        }

        public boolean matches(String t) {
            return this.toString().equalsIgnoreCase(t);
        }
    }
}

