/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.scoremodels.DistanceScoreModel;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.SeqCigar;
import jalview.math.Matrix;
import jalview.math.MatrixI;
import jalview.util.Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SecondaryStructureDistanceModel
extends DistanceScoreModel {
    private static final String NAME = "Secondary Structure Similarity";
    private ScoreMatrix ssRateMatrix;
    private String description;
    FeatureRenderer fr;

    @Override
    public ScoreModelI getInstance(AlignmentViewPanel view) {
        try {
            SecondaryStructureDistanceModel instance = (SecondaryStructureDistanceModel)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            instance.configureFromAlignmentView(view);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            Console.errPrintln("Error in " + this.getClass().getName() + ".getInstance(): " + e.getMessage());
            return null;
        }
        catch (ReflectiveOperationException roe) {
            return null;
        }
    }

    boolean configureFromAlignmentView(AlignmentViewPanel view) {
        this.fr = view.cloneFeatureRenderer();
        return true;
    }

    @Override
    public MatrixI findDistances(AlignmentView seqData, SimilarityParamsI params) {
        SeqCigar[] seqs = seqData.getSequences();
        int noseqs = seqs.length;
        int cpwidth = 0;
        double[][] similarities = new double[noseqs][noseqs];
        String ssSource = params.getSecondaryStructureSource();
        this.ssRateMatrix = ScoreModels.getInstance().getSecondaryStructureMatrix();
        String selectedSSSource = "Secondary Structure";
        if (ssSource.equals(Constants.SECONDARY_STRUCTURE_LABELS.get("jnetpred"))) {
            selectedSSSource = "jnetpred";
        }
        int[] viscont = seqData.getVisibleContigs();
        HashMap<String, HashSet<String>> ssAlignmentAnnotationForSequences = new HashMap<String, HashSet<String>>();
        AlignmentAnnotation[] alignAnnotList = this.fr.getViewport().getAlignment().getAlignmentAnnotation();
        if (alignAnnotList.length > 0) {
            for (AlignmentAnnotation aa : alignAnnotList) {
                if (aa.sequenceRef == null || !selectedSSSource.equals(aa.label)) continue;
                ssAlignmentAnnotationForSequences.computeIfAbsent(aa.sequenceRef.getName(), k -> new HashSet()).add(aa.description);
            }
        }
        Set<SeqCigar> seqsWithUndefinedSS = this.findSeqsWithUndefinedSS(seqs, ssAlignmentAnnotationForSequences);
        for (int vc = 0; vc < viscont.length; vc += 2) {
            for (int cpos = viscont[vc]; cpos <= viscont[vc + 1]; ++cpos) {
                ++cpwidth;
                Set<SeqCigar> seqsWithoutGapAtCol = this.findSeqsWithoutGapAtColumn(seqs, cpos);
                for (int i = 0; i < noseqs - 1; ++i) {
                    for (int j = i + 1; j < noseqs; ++j) {
                        AlignmentAnnotation[] aa;
                        int seqPosition;
                        SeqCigar sc1 = seqs[i];
                        SeqCigar sc2 = seqs[j];
                        boolean undefinedSS1 = seqsWithUndefinedSS.contains(sc1);
                        boolean undefinedSS2 = seqsWithUndefinedSS.contains(sc2);
                        if (undefinedSS1 && undefinedSS2) {
                            double[] dArray = similarities[i];
                            int n = j;
                            dArray[n] = dArray[n] + (double)this.ssRateMatrix.getMaximumScore();
                            continue;
                        }
                        if (undefinedSS1 || undefinedSS2) {
                            double[] dArray = similarities[i];
                            int n = j;
                            dArray[n] = dArray[n] + (double)this.ssRateMatrix.getMinimumScore();
                            continue;
                        }
                        boolean gap1 = !seqsWithoutGapAtCol.contains(sc1);
                        boolean gap2 = !seqsWithoutGapAtCol.contains(sc2);
                        char ss1 = '*';
                        char ss2 = '*';
                        if (!gap1 && !undefinedSS1) {
                            seqPosition = seqs[i].findPosition(cpos);
                            aa = seqs[i].getRefSeq().getAnnotation(selectedSSSource);
                            if (aa != null) {
                                ss1 = AlignmentUtils.findSSAnnotationForGivenSeqposition(aa[0], seqPosition);
                            }
                        }
                        if (!gap2 && !undefinedSS2) {
                            seqPosition = seqs[j].findPosition(cpos);
                            aa = seqs[j].getRefSeq().getAnnotation(selectedSSSource);
                            if (aa != null) {
                                ss2 = AlignmentUtils.findSSAnnotationForGivenSeqposition(aa[0], seqPosition);
                            }
                        }
                        if ((gap1 || gap2) && !params.includeGaps()) continue;
                        double similarityScore = this.ssRateMatrix.getPairwiseScore(ss1, ss2);
                        double[] dArray = similarities[i];
                        int n = j;
                        dArray[n] = dArray[n] + similarityScore;
                    }
                }
            }
        }
        for (int i = 0; i < noseqs; ++i) {
            for (int j = i + 1; j < noseqs; ++j) {
                double[] dArray = similarities[i];
                int n = j;
                dArray[n] = dArray[n] / (double)cpwidth;
                similarities[j][i] = similarities[i][j];
            }
        }
        return ScoreMatrix.similarityToDistance(new Matrix(similarities));
    }

    private Set<SeqCigar> findSeqsWithoutGapAtColumn(SeqCigar[] seqs, int columnPosition) {
        HashSet<SeqCigar> seqsWithoutGapAtCol = new HashSet<SeqCigar>();
        for (SeqCigar seq : seqs) {
            int spos = seq.findPosition(columnPosition);
            if (spos == -1) continue;
            seqsWithoutGapAtCol.add(seq);
        }
        return seqsWithoutGapAtCol;
    }

    private Set<SeqCigar> findSeqsWithUndefinedSS(SeqCigar[] seqs, Map<String, HashSet<String>> ssAlignmentAnnotationForSequences) {
        HashSet<SeqCigar> seqsWithUndefinedSS = new HashSet<SeqCigar>();
        for (SeqCigar seq : seqs) {
            if (!this.isSSUndefinedOrNotAdded(seq, ssAlignmentAnnotationForSequences)) continue;
            seqsWithUndefinedSS.add(seq);
        }
        return seqsWithUndefinedSS;
    }

    private boolean isSSUndefinedOrNotAdded(SeqCigar seq, Map<String, HashSet<String>> ssAlignmentAnnotationForSequences) {
        for (String label : Constants.SECONDARY_STRUCTURE_LABELS.keySet()) {
            AlignmentAnnotation[] annotations = seq.getRefSeq().getAnnotation(label);
            if (annotations == null) continue;
            for (AlignmentAnnotation annotation : annotations) {
                HashSet<String> descriptionSet = ssAlignmentAnnotationForSequences.get(annotation.sequenceRef.getName());
                if (descriptionSet == null || !descriptionSet.contains(annotation.description)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDNA() {
        return false;
    }

    @Override
    public boolean isProtein() {
        return false;
    }

    @Override
    public boolean isSecondaryStructure() {
        return true;
    }

    public String toString() {
        return "Score between sequences based on similarity between binary vectors marking secondary structure displayed at each column";
    }
}

