/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.SequenceIdMatcher;
import jalview.analysis.TreeBuilder;
import jalview.bin.Console;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.NodeTransformI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.io.NewickFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

public class TreeModel {
    SequenceI[] sequences;
    private AlignmentView seqData;
    int noseqs;
    BinaryNode top;
    double maxDistValue;
    double maxheight;
    int ycount;
    Vector<BinaryNode> node;
    boolean hasDistances = true;
    boolean hasBootstrap = false;
    private boolean hasRootDistance = true;

    public TreeModel(SequenceI[] seqs, AlignmentView odata, NewickFile treefile) {
        this(seqs, treefile.getTree(), treefile.HasDistances(), treefile.HasBootstrap(), treefile.HasRootDistance());
        this.seqData = odata;
        this.associateLeavesToSequences(seqs);
    }

    public TreeModel(TreeBuilder tree) {
        this(tree.getSequences(), tree.getTopNode(), tree.hasDistances(), tree.hasBootstrap(), tree.hasRootDistance());
        this.seqData = tree.getOriginalData();
    }

    public TreeModel(SequenceI[] seqs, BinaryNode root, boolean hasDist, boolean hasBoot, boolean hasRootDist) {
        this.sequences = seqs;
        this.top = root;
        this.hasDistances = hasDist;
        this.hasBootstrap = hasBoot;
        this.hasRootDistance = hasRootDist;
        this.maxheight = this.findHeight(this.top);
    }

    public void associateLeavesToSequences(SequenceI[] seqs) {
        SequenceIdMatcher algnIds = new SequenceIdMatcher(seqs);
        Vector<BinaryNode> leaves = this.findLeaves(this.top);
        int i = 0;
        int namesleft = seqs.length;
        Vector<SequenceI> one2many = new Vector<SequenceI>();
        while (i < leaves.size()) {
            SequenceNode j = (SequenceNode)leaves.elementAt(i++);
            String realnam = j.getName();
            SequenceI nam = null;
            if (namesleft > -1) {
                nam = algnIds.findIdMatch(realnam);
            }
            if (nam != null) {
                j.setElement(nam);
                if (one2many.contains(nam)) continue;
                one2many.addElement(nam);
                --namesleft;
                continue;
            }
            j.setElement(new Sequence(realnam, "THISISAPLACEHLDER"));
            j.setPlaceholder(true);
        }
    }

    public String print() {
        NewickFile fout = new NewickFile(this.getTopNode());
        return fout.print(this.hasBootstrap(), this.hasDistances(), this.hasRootDistance());
    }

    public void updatePlaceHolders(List<SequenceI> list) {
        Vector<BinaryNode> leaves = this.findLeaves(this.top);
        int sz = leaves.size();
        SequenceIdMatcher seqmatcher = null;
        int i = 0;
        while (i < sz) {
            SequenceI nam;
            SequenceNode leaf;
            if (list.contains((leaf = (SequenceNode)leaves.elementAt(i++)).element())) {
                leaf.setPlaceholder(false);
                continue;
            }
            if (seqmatcher == null) {
                SequenceI[] seqs = new SequenceI[list.size()];
                for (int j = 0; j < seqs.length; ++j) {
                    seqs[j] = list.get(j);
                }
                seqmatcher = new SequenceIdMatcher(seqs);
            }
            if ((nam = seqmatcher.findIdMatch(leaf.getName())) != null) {
                if (!leaf.isPlaceholder()) {
                    // empty if block
                }
                leaf.setPlaceholder(false);
                leaf.setElement(nam);
                continue;
            }
            if (!leaf.isPlaceholder()) {
                leaf.setElement(new Sequence(leaf.getName(), "THISISAPLACEHLDER"));
            }
            leaf.setPlaceholder(true);
        }
    }

    public void renameAssociatedNodes() {
        this.applyToNodes(new NodeTransformI(){

            @Override
            public void transform(BinaryNode nd) {
                Object el = nd.element();
                if (el != null && el instanceof SequenceI) {
                    nd.setName(((SequenceI)el).getName());
                }
            }
        });
    }

    public Vector<BinaryNode> findLeaves(BinaryNode top2) {
        Vector<BinaryNode> leaves = new Vector<BinaryNode>();
        this.findLeaves(top2, leaves);
        return leaves;
    }

    Vector<BinaryNode> findLeaves(BinaryNode nd, Vector<BinaryNode> leaves) {
        if (nd == null) {
            return leaves;
        }
        if (nd.left() == null && nd.right() == null) {
            leaves.addElement(nd);
            return leaves;
        }
        this.findLeaves(nd.left(), leaves);
        this.findLeaves(nd.right(), leaves);
        return leaves;
    }

    void printNode(BinaryNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() == null && nd.right() == null) {
            Console.outPrintln("Leaf = " + ((SequenceI)nd.element()).getName());
            Console.outPrintln("Dist " + nd.dist);
            Console.outPrintln("Boot " + nd.getBootstrap());
        } else {
            Console.outPrintln("Dist " + nd.dist);
            this.printNode(nd.left());
            this.printNode(nd.right());
        }
    }

    public double getMaxHeight() {
        return this.maxheight;
    }

    public List<BinaryNode> groupNodes(float threshold) {
        ArrayList<BinaryNode> groups = new ArrayList<BinaryNode>();
        this._groupNodes(groups, this.getTopNode(), threshold);
        return groups;
    }

    protected void _groupNodes(List<BinaryNode> groups, BinaryNode nd, float threshold) {
        if (nd == null) {
            return;
        }
        if (nd.height / this.maxheight > (double)threshold) {
            groups.add(nd);
        } else {
            this._groupNodes(groups, nd.left(), threshold);
            this._groupNodes(groups, nd.right(), threshold);
        }
    }

    public double findHeight(BinaryNode nd) {
        if (nd == null) {
            return this.maxheight;
        }
        if (nd.left() == null && nd.right() == null) {
            nd.height = nd.parent().height + nd.dist;
            if (nd.height > this.maxheight) {
                return nd.height;
            }
            return this.maxheight;
        }
        if (nd.parent() != null) {
            nd.height = nd.parent().height + nd.dist;
        } else {
            this.maxheight = 0.0;
            nd.height = 0.0;
        }
        this.maxheight = this.findHeight(nd.left());
        this.maxheight = this.findHeight(nd.right());
        return this.maxheight;
    }

    void printN(BinaryNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() != null && nd.right() != null) {
            this.printN(nd.left());
            this.printN(nd.right());
        } else {
            Console.outPrintln(" name = " + ((SequenceI)nd.element()).getName());
        }
        Console.outPrintln(" dist = " + nd.dist + " " + nd.count + " " + nd.height);
    }

    public void reCount(BinaryNode nd) {
        this.ycount = 0;
        this._reCount(nd);
    }

    void _reCount(BinaryNode nd) {
        if (nd == null) {
            return;
        }
        if (nd.left() != null && nd.right() != null) {
            this._reCount(nd.left());
            this._reCount(nd.right());
            BinaryNode l = nd.left();
            BinaryNode r = nd.right();
            nd.count = l.count + r.count;
            nd.ycount = (l.ycount + r.ycount) / 2.0f;
        } else {
            nd.count = 1;
            nd.ycount = this.ycount++;
        }
    }

    public void swapNodes(BinaryNode nd) {
        if (nd == null) {
            return;
        }
        BinaryNode tmp = nd.left();
        nd.setLeft(nd.right());
        nd.setRight(tmp);
    }

    void changeDirection(BinaryNode nd, BinaryNode dir) {
        if (nd == null) {
            return;
        }
        if (nd.parent() != this.top) {
            this.changeDirection(nd.parent(), nd);
            BinaryNode tmp = nd.parent();
            if (dir == nd.left()) {
                nd.setParent(dir);
                nd.setLeft(tmp);
            } else if (dir == nd.right()) {
                nd.setParent(dir);
                nd.setRight(tmp);
            }
        } else if (dir == nd.left()) {
            nd.setParent(nd.left());
            if (this.top.left() == nd) {
                nd.setRight(this.top.right());
            } else {
                nd.setRight(this.top.left());
            }
        } else {
            nd.setParent(nd.right());
            if (this.top.left() == nd) {
                nd.setLeft(this.top.right());
            } else {
                nd.setLeft(this.top.left());
            }
        }
    }

    public BinaryNode getTopNode() {
        return this.top;
    }

    public boolean hasDistances() {
        return this.hasDistances;
    }

    public boolean hasBootstrap() {
        return this.hasBootstrap;
    }

    public boolean hasRootDistance() {
        return this.hasRootDistance;
    }

    public void applyToNodes(NodeTransformI nodeTransformI) {
        Enumeration<BinaryNode> nodes = this.node.elements();
        while (nodes.hasMoreElements()) {
            nodeTransformI.transform(nodes.nextElement());
        }
    }

    public AlignmentView getOriginalData() {
        return this.seqData;
    }
}

