/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

public class CodingUtils {
    private static final int CODON_ENCODING_BITSHIFT = 2;

    public static int encodeCodon(char[] codon) {
        if (codon == null) {
            return -1;
        }
        return CodingUtils.encodeCodon(codon[2]) + (CodingUtils.encodeCodon(codon[1]) << 2) + (CodingUtils.encodeCodon(codon[0]) << 4);
    }

    public static int encodeCodon(char c) {
        int result = Integer.MIN_VALUE;
        switch (c) {
            case 'A': 
            case 'a': {
                result = 0;
                break;
            }
            case 'C': 
            case 'c': {
                result = 1;
                break;
            }
            case 'G': 
            case 'g': {
                result = 2;
                break;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                result = 3;
            }
        }
        return result;
    }

    public static char[] decodeCodon(int encoded) {
        char[] result = new char[3];
        result[2] = CodingUtils.decodeNucleotide(encoded & 3);
        result[1] = CodingUtils.decodeNucleotide((encoded >>>= 2) & 3);
        result[0] = CodingUtils.decodeNucleotide((encoded >>>= 2) & 3);
        return result;
    }

    public static void decodeCodon2(int encoded, char[] result) {
        result[2] = CodingUtils.decodeNucleotide(encoded & 3);
        result[1] = CodingUtils.decodeNucleotide((encoded >>>= 2) & 3);
        result[0] = CodingUtils.decodeNucleotide((encoded >>>= 2) & 3);
    }

    public static char decodeNucleotide(int i) {
        char result = '0';
        switch (i) {
            case 0: {
                result = 'A';
                break;
            }
            case 1: {
                result = 'C';
                break;
            }
            case 2: {
                result = 'G';
                break;
            }
            case 3: {
                result = 'T';
            }
        }
        return result;
    }
}

