/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.rna;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class VARNASecDraw {
    public static VARNAPanel _vp = null;
    public int _depth = 0;
    public static Random _rnd = new Random();
    private static int MAX_NUM_DIR = 8;

    private void buildTree(int n, int n2, RNATree rNATree, RNA rNA) {
        if (n >= n2) {
            rNATree.addPortion(new UnpairedPortion(n, n2 - n + 1));
        }
        if (rNA.get_listeBases().get(n).getElementStructure() == n2) {
            int n3 = n;
            int n4 = n2;
            boolean bl = false;
            while (n + 1 < rNA.get_listeBases().size() && n2 - 1 >= 0 && n + 1 <= n2 - 1 && !bl) {
                if (rNA.get_listeBases().get(n).getElementStructure() != n2) {
                    bl = true;
                    continue;
                }
                ++n;
                --n2;
            }
            int n5 = n;
            int n6 = n2;
            RNATree rNATree2 = new RNATree();
            if (n < n2 - 1) {
                this.buildTree(n5, n6, rNATree2, rNA);
            }
            PairedPortion pairedPortion = new PairedPortion(n3, n4, n5 - n3, rNATree2);
            rNATree.addPortion(pairedPortion);
        } else {
            int n7;
            int n8 = n7 = n;
            int n9 = 0;
            while (n7 <= n2) {
                int n10 = rNA.get_listeBases().get(n7).getElementStructure();
                if (n10 != -1) {
                    if (n9 > 0) {
                        rNATree.addPortion(new UnpairedPortion(n8, n9));
                    }
                    this.buildTree(n7, n10, rNATree, rNA);
                    n8 = n7 = n10 + 1;
                    n9 = 0;
                    continue;
                }
                ++n9;
                ++n7;
            }
            if (n9 > 0) {
                rNATree.addPortion(new UnpairedPortion(n8, n9));
            }
        }
    }

    public int[] nextPlacement(int[] nArray) throws Exception {
        int n = nArray.length - 1;
        int n2 = MAX_NUM_DIR;
        boolean bl = false;
        while (n >= 0 && !bl) {
            if (nArray[n] == n2 - 1) {
                n2 = nArray[n];
                --n;
                continue;
            }
            bl = true;
        }
        if (n < 0) {
            throw new Exception("No more placement available");
        }
        int n3 = n++;
        nArray[n3] = nArray[n3] + 1;
        while (n < nArray.length) {
            nArray[n] = nArray[n - 1] + 1;
            ++n;
        }
        return nArray;
    }

    public void drawTree(double d, double d2, RNATree rNATree, double d3, RNA rNA) throws Exception {
        double d4;
        boolean bl = true;
        double d5 = d;
        double d6 = d2;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        double d7 = 65.0 + 40.0;
        for (int i = 0; i < rNATree.getNumPortions(); ++i) {
            Portion portion = rNATree.getPortion(i);
            if (portion instanceof PairedPortion) {
                d7 += 65.0 + 40.0;
                ++n2;
                continue;
            }
            d7 += 40.0 * (double)portion.getNumBases();
            n3 += portion.getNumBases() + 1;
        }
        double d8 = rNA.determineRadius(n2, n3, d7 / (Math.PI * 2));
        for (int i = 0; i < rNATree.getNumPortions(); ++i) {
            Portion portion = rNATree.getPortion(i);
            if (!(portion instanceof PairedPortion)) continue;
            ++n;
        }
        int[] nArray = new int[n];
        double d9 = d4 = (double)MAX_NUM_DIR / ((double)n + 1.0);
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.round(d9);
            d9 += d4;
        }
        System.out.println();
        double d10 = Math.PI * 2 / (double)MAX_NUM_DIR;
        while (bl) {
            Object object;
            int n4;
            d5 = d + d8 * Math.cos(d3 + Math.PI);
            d6 = d2 + d8 * Math.sin(d3 + Math.PI);
            ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
            int n5 = 0;
            for (n4 = 0; n4 < rNATree.getNumPortions(); ++n4) {
                object = rNATree.getPortion(n4);
                if (object instanceof PairedPortion) {
                    double d11 = d3 + (double)nArray[n5] * d10;
                    ++n5;
                    PairedPortion pairedPortion = (PairedPortion)object;
                    for (int i = 0; i < pairedPortion._len; ++i) {
                        int n6 = pairedPortion._pos1 + i;
                        int n7 = pairedPortion._pos2 - i;
                        double d12 = Math.cos(d11);
                        double d13 = Math.sin(d11);
                        double d14 = d5 + ((double)i * 40.0 + d8) * d12;
                        double d15 = d6 + ((double)i * 40.0 + d8) * d13;
                        rNA.get_listeBases().get(n6).setCoords(new Point2D.Double(d14 + 65.0 * d13 / 2.0, d15 - 65.0 * d12 / 2.0));
                        rNA.get_listeBases().get(n7).setCoords(new Point2D.Double(d14 - 65.0 * d13 / 2.0, d15 + 65.0 * d12 / 2.0));
                    }
                    double d16 = d5 + ((double)(pairedPortion._len - 1) * 40.0 + d8) * Math.cos(d11);
                    double d17 = d6 + ((double)(pairedPortion._len - 1) * 40.0 + d8) * Math.sin(d11);
                    this.drawTree(d16, d17, pairedPortion._r, d11 + Math.PI, rNA);
                    arrayList.add(pairedPortion.getOutline(rNA));
                    continue;
                }
                if (!(object instanceof UnpairedPortion)) continue;
                UnpairedPortion unpairedPortion = (UnpairedPortion)object;
                for (int i = 0; i < unpairedPortion._len; ++i) {
                    rNA.get_listeBases().get(unpairedPortion._pos + i).setCoords(new Point2D.Double(d5, d6));
                }
            }
            if (arrayList.size() > 0) {
                bl = false;
                for (n4 = 0; n4 < arrayList.size() && !bl; ++n4) {
                    object = new Area((Shape)arrayList.get(n4));
                    for (int i = n4 + 1; i < arrayList.size() && !bl; ++i) {
                        Area area = new Area((Shape)arrayList.get(i));
                        ((Area)object).intersect(area);
                        if (((Area)object).isEmpty()) continue;
                        bl = true;
                    }
                }
                if (!bl) continue;
                nArray = this.nextPlacement(nArray);
                continue;
            }
            bl = false;
        }
    }

    public double determineRadius(int n, int n2, RNA rNA) {
        double d = (double)n * 65.0 + (double)(n + n2) * 40.0;
        return d / (Math.PI * 2);
    }

    public void predrawTree(double d, double d2, RNATree rNATree, double d3, RNA rNA, HelixEmbedding helixEmbedding, ArrayList<HelixEmbedding> arrayList) throws Exception {
        double d4;
        double d5 = d;
        double d6 = d2;
        int n = 0;
        int n2 = 0;
        double d7 = 65.0 + 40.0;
        for (int i = 0; i < rNATree.getNumPortions(); ++i) {
            Portion portion = rNATree.getPortion(i);
            if (portion instanceof PairedPortion) {
                d7 += 65.0 + 40.0;
                ++n;
                continue;
            }
            d7 += 40.0 * (double)portion.getNumBases();
            n2 += portion.getNumBases();
        }
        double d8 = this.determineRadius(n + 1, n2, rNA);
        int[] nArray = new int[n];
        double d9 = d4 = (double)MAX_NUM_DIR / ((double)n + 1.0);
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.round(d9);
            d9 += d4;
        }
        double d10 = Math.PI * 2 / (double)MAX_NUM_DIR;
        d5 = d + d8 * Math.cos(d3 + Math.PI);
        d6 = d2 + d8 * Math.sin(d3 + Math.PI);
        int n3 = 0;
        for (int i = 0; i < rNATree.getNumPortions(); ++i) {
            Portion portion = rNATree.getPortion(i);
            if (portion instanceof PairedPortion) {
                double d11 = d3 + (double)nArray[n3] * d10;
                PairedPortion pairedPortion = (PairedPortion)portion;
                for (int j = 0; j < pairedPortion._len; ++j) {
                    int n4 = pairedPortion._pos1 + j;
                    int n5 = pairedPortion._pos2 - j;
                    double d12 = Math.cos(d11);
                    double d13 = Math.sin(d11);
                    double d14 = d5 + ((double)j * 40.0 + d8) * d12;
                    double d15 = d6 + ((double)j * 40.0 + d8) * d13;
                    rNA.get_listeBases().get(n4).setCoords(new Point2D.Double(d14 + 65.0 * d13 / 2.0, d15 - 65.0 * d12 / 2.0));
                    rNA.get_listeBases().get(n5).setCoords(new Point2D.Double(d14 - 65.0 * d13 / 2.0, d15 + 65.0 * d12 / 2.0));
                }
                double d16 = d5 + ((double)(pairedPortion._len - 1) * 40.0 + d8) * Math.cos(d11);
                double d17 = d6 + ((double)(pairedPortion._len - 1) * 40.0 + d8) * Math.sin(d11);
                HelixEmbedding helixEmbedding2 = new HelixEmbedding(new Point2D.Double(d5, d6), pairedPortion, rNA, helixEmbedding);
                helixEmbedding.addHelixEmbedding(helixEmbedding2, nArray[n3]);
                arrayList.add(helixEmbedding2);
                this.predrawTree(d16, d17, pairedPortion._r, d11 + Math.PI, rNA, helixEmbedding2, arrayList);
                ++n3;
                continue;
            }
            if (!(portion instanceof UnpairedPortion)) continue;
            UnpairedPortion unpairedPortion = (UnpairedPortion)portion;
            for (int j = 0; j < unpairedPortion._len; ++j) {
                rNA.get_listeBases().get(unpairedPortion._pos + j).setCoords(new Point2D.Double(d5, d6));
            }
        }
    }

    public RNATree drawRNA(double d, RNA rNA) {
        RNATree rNATree = new RNATree();
        this.buildTree(0, rNA.get_listeBases().size() - 1, rNATree, rNA);
        System.out.println(rNATree);
        ArrayList<HelixEmbedding> arrayList = new ArrayList<HelixEmbedding>();
        HelixEmbedding helixEmbedding = null;
        try {
            helixEmbedding = new HelixEmbedding(new Point2D.Double(0.0, 0.0), new PairedPortion(0, 0, 0, rNATree), rNA, null);
            this.predrawTree(0.0, 0.0, rNATree, 0.0, rNA, helixEmbedding, arrayList);
            double d2 = Double.MAX_VALUE;
            for (int i = 1000; i > 0 && d2 > 0.0; --i) {
                HelixEmbedding helixEmbedding2 = arrayList.get(_rnd.nextInt(arrayList.size()));
                int n = helixEmbedding2.chooseNextMove();
                if (_vp != null) {
                    GeneralPath generalPath = new GeneralPath();
                    for (int j = 0; j < arrayList.size(); ++j) {
                        generalPath.append(arrayList.get(j).getShape(), false);
                    }
                    rNA._debugShape = generalPath;
                    _vp.paintImmediately(0, 0, _vp.getWidth(), _vp.getHeight());
                }
                double d3 = 0.0;
                for (int j = 0; j < arrayList.size(); ++j) {
                    GeneralPath generalPath = arrayList.get(j).getShape();
                    for (int k = j + 1; k < arrayList.size(); ++k) {
                        GeneralPath generalPath2 = arrayList.get(k).getShape();
                        Area area = new Area(generalPath);
                        area.intersect(new Area(generalPath2));
                        if (area.isEmpty()) continue;
                        d3 += 1.0;
                    }
                }
                if (d3 - d2 > 0.0) {
                    helixEmbedding2.cancelMove(n);
                } else {
                    d2 = d3;
                }
                System.out.println(d3);
            }
            if (helixEmbedding != null) {
                helixEmbedding.reflectCoordinates();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return rNATree;
    }

    private class HelixEmbedding {
        private GeneralPath _clip;
        Point2D.Double _support;
        ArrayList<HelixEmbedding> _children = new ArrayList();
        ArrayList<Integer> _indices = new ArrayList();
        PairedPortion _p;
        RNA _r;
        HelixEmbedding _parent;

        public HelixEmbedding(Point2D.Double double_, PairedPortion pairedPortion, RNA rNA, HelixEmbedding helixEmbedding) {
            this._support = double_;
            this._clip = pairedPortion.getLocalOutline(rNA);
            this._p = pairedPortion;
            this._r = rNA;
            this._parent = helixEmbedding;
        }

        public void addHelixEmbedding(HelixEmbedding helixEmbedding, int n) {
            this._children.add(helixEmbedding);
            this._indices.add(n);
        }

        public GeneralPath getShape() {
            return this._clip;
        }

        public int chooseNextMove() {
            int n = this._parent._children.indexOf(this);
            if (this._parent._children.size() < MAX_NUM_DIR - 1) {
                int n2;
                int n3;
                if (this._parent._children.size() == 1) {
                    n3 = 1;
                    n2 = MAX_NUM_DIR - 1;
                } else {
                    n3 = n == 0 ? 1 : this._parent._indices.get(n - 1) + 1;
                    n2 = n == this._parent._children.size() - 1 ? MAX_NUM_DIR - 1 : this._parent._indices.get(n + 1) - 1;
                }
                int n4 = this._parent._indices.get(n);
                int n5 = n3 + _rnd.nextInt(n2 + 1 - n3);
                double d = (double)(n5 - n4) * Math.PI * 2.0 / (double)MAX_NUM_DIR;
                this._parent._indices.set(n, n5);
                this.rotate(d);
                return n5 - n4;
            }
            return 0;
        }

        public void cancelMove(int n) {
            int n2 = this._parent._children.indexOf(this);
            int n3 = this._parent._indices.get(n2);
            double d = (double)(-n) * Math.PI * 2.0 / (double)MAX_NUM_DIR;
            this._parent._indices.set(n2, n3 - n);
            this.rotate(d);
        }

        public void rotate(double d) {
            this.transform(AffineTransform.getRotateInstance(d, this._support.x, this._support.y));
        }

        private void transform(AffineTransform affineTransform) {
            this._clip.transform(affineTransform);
            Point2D point2D = affineTransform.transform(this._support, null);
            this._support.setLocation(point2D.getX(), point2D.getY());
            for (int i = 0; i < this._children.size(); ++i) {
                this._children.get(i).transform(affineTransform);
            }
        }

        public void reflectCoordinates() {
            Object object;
            Object object2;
            ArrayList<ModeleBase> arrayList = this._r.get_listeBases();
            if (this._p._len > 0) {
                Point2D.Double double_;
                PathIterator pathIterator = this._clip.getPathIterator(AffineTransform.getRotateInstance(0.0));
                ArrayList<Point2D.Double> arrayList2 = new ArrayList<Point2D.Double>();
                while (!pathIterator.isDone()) {
                    object2 = new double[6];
                    int n = pathIterator.currentSegment((double[])object2);
                    if (n == 0 || n == 1) {
                        double_ = new Point2D.Double(object2[0], object2[1]);
                        arrayList2.add(double_);
                        System.out.println(Arrays.toString(object2));
                    }
                    pathIterator.next();
                }
                if (arrayList2.size() < 4) {
                    return;
                }
                object2 = (Point2D.Double)arrayList2.get(0);
                object = (Point2D.Double)arrayList2.get(1);
                double_ = (Point2D.Double)arrayList2.get(2);
                Point2D.Double double_2 = (Point2D.Double)arrayList2.get(3);
                double d = object2.distance((Point2D)object);
                double d2 = ((Point2D.Double)object).x - object2.x;
                double d3 = ((Point2D.Double)object).y - object2.y;
                double d4 = 0.0;
                if (this._p._len > 1) {
                    d2 /= d;
                    d3 /= d;
                    d4 = d / ((double)this._p._len - 1.0);
                    System.out.println("DELTA: " + d4 + " " + 40.0);
                }
                for (int i = 0; i < this._p._len; ++i) {
                    int n = this._p._pos1 + i;
                    int n2 = this._p._pos2 - i;
                    ModeleBase modeleBase = arrayList.get(n);
                    modeleBase.setCoords(new Point2D.Double(object2.x + (double)i * d2 * d4, object2.y + (double)i * d3 * d4));
                    ModeleBase modeleBase2 = arrayList.get(n2);
                    modeleBase2.setCoords(new Point2D.Double(double_2.x + (double)i * d2 * d4, double_2.y + (double)i * d3 * d4));
                }
            }
            for (int i = 0; i < this._children.size(); ++i) {
                this._children.get(i).reflectCoordinates();
            }
            if (this._children.size() > 0) {
                Point2D.Double double_ = this._children.get((int)0)._support;
                for (int i = 0; i < this._p._r.getNumPortions(); ++i) {
                    object2 = this._p._r.getPortion(i);
                    if (!(object2 instanceof UnpairedPortion)) continue;
                    object = (UnpairedPortion)object2;
                    for (int j = 0; j < ((UnpairedPortion)object)._len; ++j) {
                        int n = ((UnpairedPortion)object)._pos + j;
                        ModeleBase modeleBase = arrayList.get(n);
                        modeleBase.setCoords(double_);
                    }
                }
            } else {
                this.placeTerminalLoop(arrayList, this._r);
            }
        }

        private void placeTerminalLoop(ArrayList<ModeleBase> arrayList, RNA rNA) {
            Portion portion;
            if (this._children.size() == 0 && this._p._r.getNumPortions() == 1 && (portion = this._p._r.getPortion(0)) instanceof UnpairedPortion) {
                UnpairedPortion unpairedPortion = (UnpairedPortion)portion;
                double d = VARNASecDraw.this.determineRadius(1, unpairedPortion.getNumBases(), this._r);
                int n = this._p._pos1 + this._p._len - 1;
                int n2 = this._p._pos2 - (this._p._len - 1);
                ModeleBase modeleBase = arrayList.get(n);
                ModeleBase modeleBase2 = arrayList.get(n2);
                Point2D.Double double_ = modeleBase.getCoords();
                Point2D.Double double_2 = modeleBase2.getCoords();
                Point2D.Double double_3 = new Point2D.Double((double_.x + double_2.x) / 2.0, (double_.y + double_2.y) / 2.0);
                double d2 = (double_.x - double_2.x) / double_.distance(double_2);
                double d3 = (double_.y - double_2.y) / double_.distance(double_2);
                double d4 = -d3;
                double d5 = d2;
                Point2D.Double double_4 = new Point2D.Double(double_3.x + d * d4, double_3.y + d * d5);
                double d6 = 40.0 * (1.0 + (double)unpairedPortion.getNumBases()) + 65.0;
                double d7 = Math.PI * 2 * 40.0 / d6;
                double d8 = Math.PI * 2 * 65.0 / (2.0 * d6);
                for (int i = 0; i < unpairedPortion._len; ++i) {
                    int n3 = unpairedPortion._pos + i;
                    ModeleBase modeleBase3 = arrayList.get(n3);
                    double d9 = -Math.cos(d8 += d7) * d4 + Math.sin(d8) * d2;
                    double d10 = -Math.cos(d8) * d5 + Math.sin(d8) * d3;
                    Point2D.Double double_5 = new Point2D.Double(double_4.x + d * d9, double_4.y + d * d10);
                    modeleBase3.setCoords(double_5);
                }
            }
        }

        public String toString() {
            return "Emb.Hel.: " + this._p.toString();
        }
    }

    public class RNATree {
        ArrayList<Portion> _portions = new ArrayList();
        int _numPairedPortions = 0;

        public void addPortion(Portion portion) {
            this._portions.add(portion);
            if (portion instanceof PairedPortion) {
                ++this._numPairedPortions;
            }
        }

        public int getNumPortions() {
            return this._portions.size();
        }

        public Portion getPortion(int n) {
            return this._portions.get(n);
        }

        public String toString() {
            String string = "";
            ++VARNASecDraw.this._depth;
            for (int i = 0; i < this._portions.size(); ++i) {
                string = string + String.format("%1$#" + VARNASecDraw.this._depth + "s", Character.valueOf(' '));
                string = string + this._portions.get(i).toString();
                if (i >= this._portions.size() - 1) continue;
                string = string + "\n";
            }
            --VARNASecDraw.this._depth;
            return string;
        }

        public GeneralPath getOutline(RNA rNA) {
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < this._portions.size(); ++i) {
                generalPath.append(this._portions.get(i).getOutline(rNA), true);
            }
            return generalPath;
        }
    }

    public class PairedPortion
    extends Portion {
        int _pos1;
        int _pos2;
        int _len;
        RNATree _r;

        public PairedPortion(int n, int n2, int n3, RNATree rNATree) {
            this._pos1 = n;
            this._pos2 = n2;
            this._len = n3;
            this._r = rNATree;
        }

        @Override
        public ArrayList<Integer> getBaseList() {
            return null;
        }

        public String toString() {
            return "H[" + this._pos1 + "," + (this._pos1 + this._len - 1) + "][" + (this._pos2 - this._len + 1) + "," + this._pos2 + "]\n" + this._r.toString();
        }

        @Override
        public int getNumBases() {
            return 2 * this._len;
        }

        public GeneralPath getLocalOutline(RNA rNA) {
            GeneralPath generalPath = new GeneralPath();
            if (this._len > 0) {
                ArrayList<ModeleBase> arrayList = rNA.get_listeBases();
                Point2D.Double double_ = arrayList.get(this._pos1).getCoords();
                Point2D.Double double_2 = arrayList.get(this._pos1 + this._len - 1).getCoords();
                Point2D.Double double_3 = arrayList.get(this._pos2 - this._len + 1).getCoords();
                Point2D.Double double_4 = arrayList.get(this._pos2).getCoords();
                generalPath.moveTo((float)double_.x, (float)double_.y);
                generalPath.lineTo((float)double_2.x, (float)double_2.y);
                generalPath.lineTo((float)double_3.x, (float)double_3.y);
                generalPath.lineTo((float)double_4.x, (float)double_4.y);
            }
            return generalPath;
        }

        @Override
        public GeneralPath getOutline(RNA rNA) {
            return this.getOutline(rNA, false);
        }

        public GeneralPath getOutline(RNA rNA, boolean bl) {
            ArrayList<ModeleBase> arrayList = rNA.get_listeBases();
            Point2D.Double double_ = arrayList.get(this._pos1).getCoords();
            Point2D.Double double_2 = arrayList.get(this._pos1 + this._len - 1).getCoords();
            Point2D.Double double_3 = arrayList.get(this._pos2 - this._len + 1).getCoords();
            Point2D.Double double_4 = arrayList.get(this._pos2).getCoords();
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)double_.x, (float)double_.y);
            generalPath.lineTo((float)double_2.x, (float)double_2.y);
            if (!bl) {
                generalPath.append(this._r.getOutline(rNA), true);
            }
            generalPath.lineTo((float)double_3.x, (float)double_3.y);
            generalPath.lineTo((float)double_4.x, (float)double_4.y);
            return generalPath;
        }
    }

    public class UnpairedPortion
    extends Portion {
        int _pos;
        int _len;

        public UnpairedPortion(int n, int n2) {
            this._len = n2;
            this._pos = n;
        }

        @Override
        public ArrayList<Integer> getBaseList() {
            return null;
        }

        public String toString() {
            return "U[" + this._pos + "," + (this._pos + this._len - 1) + "]";
        }

        @Override
        public int getNumBases() {
            return this._len;
        }

        @Override
        public GeneralPath getOutline(RNA rNA) {
            GeneralPath generalPath = new GeneralPath();
            ArrayList<ModeleBase> arrayList = rNA.get_listeBases();
            Point2D.Double double_ = arrayList.get(this._pos).getCoords();
            generalPath.moveTo((float)double_.x, (float)double_.y);
            for (int i = 1; i < this._len; ++i) {
                Point2D.Double double_2 = arrayList.get(this._pos + i).getCoords();
                generalPath.lineTo((float)double_2.x, (float)double_2.y);
            }
            return generalPath;
        }
    }

    public abstract class Portion {
        public abstract ArrayList<Integer> getBaseList();

        public abstract int getNumBases();

        public abstract GeneralPath getOutline(RNA var1);
    }
}

