/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.math.BigInteger;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javajs.util.JSONException;
import javajs.util.Lst;
import javajs.util.SB;

public class JSJSONParser {
    private String str;
    private int index;
    private int len;
    private boolean asHashTable;

    public Map<String, Object> parseMap(String str, boolean asHashTable) {
        this.index = 0;
        this.asHashTable = asHashTable;
        this.str = str;
        this.len = str.length();
        if (this.getChar() != '{') {
            return null;
        }
        this.returnChar();
        return (Map)this.getValue(false);
    }

    public Object parse(String str, boolean asHashTable) {
        this.index = 0;
        this.asHashTable = asHashTable;
        this.str = str;
        this.len = str.length();
        return this.getValue(false);
    }

    private char next() {
        return this.index < this.len ? this.str.charAt(this.index++) : (char)'\u0000';
    }

    private void returnChar() {
        --this.index;
    }

    private char getChar() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    private Object getValue(boolean isKey) throws JSONException {
        int i = this.index;
        char c = this.getChar();
        switch (c) {
            case '\u0000': {
                return null;
            }
            case '\"': 
            case '\'': {
                return this.getString(c);
            }
            case '{': {
                if (!isKey) {
                    return this.getObject();
                }
                c = '\u0000';
                break;
            }
            case '[': {
                if (!isKey) {
                    return this.getArray();
                }
                c = '\u0000';
                break;
            }
            default: {
                this.returnChar();
                while (c >= ' ' && "[,]{:}'\"".indexOf(c) < 0) {
                    c = this.next();
                }
                this.returnChar();
                if (!isKey || c == ':') break;
                c = '\u0000';
            }
        }
        if (isKey && c == '\u0000') {
            throw new JSONException("invalid key");
        }
        String string = this.str.substring(i, this.index).trim();
        if (!isKey) {
            if (string.equals("true")) {
                return Boolean.TRUE;
            }
            if (string.equals("false")) {
                return Boolean.FALSE;
            }
            if (string.equals("null")) {
                return this.asHashTable ? string : null;
            }
        }
        if ((c = string.charAt(0)) >= '0' && c <= '9' || c == '-') {
            try {
                if (string.indexOf(46) < 0 && string.indexOf(101) < 0 && string.indexOf(69) < 0) {
                    return Integer.valueOf(string);
                }
                Float d = Float.valueOf(string);
                if (!d.isInfinite() && !d.isNaN()) {
                    return d;
                }
            }
            catch (Exception e) {
                try {
                    return Long.valueOf(string);
                }
                catch (Exception e1) {
                    try {
                        return new BigInteger(string);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        System.out.println("JSON parser cannot parse " + string);
        throw new JSONException("invalid value");
    }

    private String getString(char quote) throws JSONException {
        SB sb = null;
        int i0 = this.index;
        while (true) {
            int i1 = this.index;
            char c = this.next();
            block1 : switch (c) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            break block1;
                        }
                        case 'b': {
                            c = '\b';
                            break block1;
                        }
                        case 't': {
                            c = '\t';
                            break block1;
                        }
                        case 'n': {
                            c = '\n';
                            break block1;
                        }
                        case 'f': {
                            c = '\f';
                            break block1;
                        }
                        case 'r': {
                            c = '\r';
                            break block1;
                        }
                        case 'u': {
                            int i = this.index;
                            this.index += 4;
                            try {
                                c = (char)Integer.parseInt(this.str.substring(i, this.index), 16);
                                break block1;
                            }
                            catch (Exception e) {
                                throw this.syntaxError("Substring bounds error");
                            }
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
                default: {
                    if (c != quote) break;
                    return sb == null ? this.str.substring(i0, i1) : sb.toString();
                }
            }
            if (this.index > i1 + 1 && sb == null) {
                sb = new SB();
                sb.append(this.str.substring(i0, i1));
            }
            if (sb == null) continue;
            sb.appendC(c);
        }
    }

    private Object getObject() {
        Map<String, Object> map = this.asHashTable ? new Hashtable() : new LinkedHashMap();
        String key = null;
        switch (this.getChar()) {
            case '}': {
                return map;
            }
            case '\u0000': {
                throw new JSONException("invalid object");
            }
        }
        this.returnChar();
        boolean isKey = false;
        block9: while (true) {
            if (isKey = !isKey) {
                key = this.getValue(true).toString();
            } else {
                map.put(key, this.getValue(false));
            }
            switch (this.getChar()) {
                case '}': {
                    return map;
                }
                case ':': {
                    if (isKey) continue block9;
                    isKey = true;
                }
                case ',': {
                    if (isKey) break block9;
                    continue block9;
                }
            }
            break;
        }
        throw this.syntaxError("Expected ',' or ':' or '}'");
    }

    private Object getArray() {
        Lst<Object> l = new Lst<Object>();
        switch (this.getChar()) {
            case ']': {
                return l;
            }
            case '\u0000': {
                throw new JSONException("invalid array");
            }
        }
        this.returnChar();
        boolean isNull = false;
        block12: while (true) {
            if (isNull) {
                l.addLast((Object)null);
                isNull = false;
            } else {
                l.addLast(this.getValue(false));
            }
            switch (this.getChar()) {
                case ',': {
                    switch (this.getChar()) {
                        case ']': {
                            return l;
                        }
                        case ',': {
                            isNull = true;
                        }
                    }
                    this.returnChar();
                    continue block12;
                }
                case ']': {
                    return l;
                }
            }
            break;
        }
        throw this.syntaxError("Expected ',' or ']'");
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + " for " + this.str.substring(0, Math.min(this.index, this.len)));
    }
}

